/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.datasource.spec.mult;

import com.kingdee.bos.qing.datasource.exception.AbstractDataSourceException;
import com.kingdee.bos.qing.datasource.meta.DSFieldKey;
import com.kingdee.bos.qing.datasource.meta.DSMeta;
import com.kingdee.bos.qing.datasource.meta.DSMetaEntity;
import com.kingdee.bos.qing.datasource.meta.DSMetaProperty;
import com.kingdee.bos.qing.datasource.meta.DSMetaRelation;
import com.kingdee.bos.qing.datasource.model.MultiDataSourceWrap;
import com.kingdee.bos.qing.datasource.model.filter.IPushdownFilter;
import com.kingdee.bos.qing.datasource.spec.AbstractDataSourceVisitor;
import com.kingdee.bos.qing.datasource.spec.AbstractSingleDataSourceVisitor;
import com.kingdee.bos.qing.datasource.spec.IDataIterator;
import com.kingdee.bos.qing.datasource.spec.IDataSourceExtend;
import com.kingdee.bos.qing.datasource.spec.IDataSourceVisitor;
import com.kingdee.bos.qing.datasource.spec.IDistinctValueCollecter;
import com.kingdee.bos.qing.datasource.spec.mult.MultiDataIterator;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MultiDataSourceVisitor
extends AbstractDataSourceVisitor
implements IDataSourceExtend {
    private MultiDataSourceWrap multiDataSourceWrap;
    private List<DSMetaEntity> entities;
    private List<DSMetaRelation> relations;
    private DSMeta dSMeta;

    public MultiDataSourceVisitor(MultiDataSourceWrap multiDataSourceWrap, List<DSMetaEntity> entities, List<DSMetaRelation> relations) {
        this.multiDataSourceWrap = multiDataSourceWrap;
        this.entities = entities;
        this.relations = relations;
    }

    @Override
    public boolean hasData() {
        return true;
    }

    public IDataIterator iterator() {
        return new MultiDataIterator(this.multiDataSourceWrap, this.entities, this.relations);
    }

    public MultiDataSourceWrap getMultiDataSourceWrap() {
        return this.multiDataSourceWrap;
    }

    public Calendar[] getDateScope(DSFieldKey field) throws AbstractDataSourceException, InterruptedException {
        IDataSourceVisitor dataSourceVisitor = this.getDataSourceVisitor(field);
        if (dataSourceVisitor == null) {
            return null;
        }
        return dataSourceVisitor.getDateScope(field);
    }

    public BigDecimal[] getNumberScope(DSFieldKey field) throws AbstractDataSourceException, InterruptedException {
        IDataSourceVisitor dataSourceVisitor = this.getDataSourceVisitor(field);
        if (dataSourceVisitor == null) {
            return null;
        }
        return dataSourceVisitor.getNumberScope(field);
    }

    private IDataSourceVisitor getDataSourceVisitor(DSFieldKey field) throws AbstractDataSourceException {
        HashSet<String> key = new HashSet<String>();
        key.add(field.getEntityName());
        return this.multiDataSourceWrap.get(key);
    }

    public void collectDistinctValue(IDistinctValueCollecter valueCollecter, List<DSFieldKey> fields, Set<IPushdownFilter> filters) throws AbstractDataSourceException, InterruptedException {
        if (valueCollecter == null) {
            return;
        }
        if (fields == null || fields.isEmpty()) {
            return;
        }
        ArrayList<DSFieldKey> exsitField = new ArrayList<DSFieldKey>();
        boolean hasFieldExsit = false;
        for (int index = 0; index < fields.size(); ++index) {
            DSFieldKey field = fields.get(index);
            boolean isFoundField = false;
            for (DSMetaEntity dsMetaEntity : this.entities) {
                if (!dsMetaEntity.getName().equals(field.getEntityName())) continue;
                for (DSMetaProperty metaProperty : dsMetaEntity.getProperties()) {
                    if (!metaProperty.getName().equals(field.getPropertyName())) continue;
                    isFoundField = true;
                    break;
                }
                if (!isFoundField) continue;
                break;
            }
            if (isFoundField) {
                hasFieldExsit = true;
                exsitField.add(field);
                continue;
            }
            fields.set(index, null);
        }
        if (!hasFieldExsit) {
            return;
        }
        AbstractSingleDataSourceVisitor.collectDistinctValueWithIterator(this.iterator(), valueCollecter, fields, exsitField, filters);
    }

    @Override
    public boolean isFieldsExisted(Collection<String> searchFields) {
        throw new UnsupportedOperationException("not supported");
    }

    public DSMeta getMeta() {
        if (this.dSMeta == null) {
            this.dSMeta = new DSMeta();
            this.dSMeta.setEntities(this.entities);
            this.dSMeta.setRelations(this.relations);
        }
        return this.dSMeta;
    }

    public Map<String, String> getUnionTableAdditionFilter(String unionTableName, String subTableBizName) {
        return this.multiDataSourceWrap.getUnionTableAdditionFilter(unionTableName, subTableBizName);
    }
}

