/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.datasource.spec.qs;

import com.kingdee.bos.qing.datasource.exception.AbstractDataSourceException;
import com.kingdee.bos.qing.datasource.io.IMutiFileSupport;
import com.kingdee.bos.qing.datasource.meta.DSFieldKey;
import com.kingdee.bos.qing.datasource.meta.DataType;
import com.kingdee.bos.qing.datasource.meta.MetaInfo;
import com.kingdee.bos.qing.datasource.meta.MetaInfoDecodeUtil;
import com.kingdee.bos.qing.datasource.model.filter.AbstractUnderDSFilter;
import com.kingdee.bos.qing.datasource.model.filter.IPushdownFilter;
import com.kingdee.bos.qing.datasource.model.filter.UnderDSContinuousFilter;
import com.kingdee.bos.qing.datasource.model.filter.UnderDSDiscreteFilter;
import com.kingdee.bos.qing.datasource.spec.AbstractDataIterator;
import com.kingdee.bos.qing.datasource.spec.qs.QSInputstream;
import com.kingdee.bos.qing.datasource.spec.qsdatahandler.DefaultDataHandlerFactory;
import com.kingdee.bos.qing.datasource.spec.qsdatahandler.IQsDataHandler;
import com.kingdee.bos.qing.datasource.spec.qsdatahandler.IQsDataHandlerFactory;
import com.kingdee.bos.qing.datasource.spec.qsdatahandler.Int64DataHandler;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFileVisitor;
import com.kingdee.bos.qing.filesystem.stream.QingInputStream;
import com.kingdee.bos.qing.util.CloseUtil;
import java.io.Closeable;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import q.datasource.io.AbstractInputStream;
import q.storage.columnar.QingStorageRecordReader;
import q.storage.columnar.api.b;
import q.storage.columnar.api.impl.QingStorageReadSupport;
import q.storage.columnar.metadata.FileMetaData;
import q.storage.columnar.predicate.QSFilterApi;
import q.storage.columnar.util.QingStorageUtils;
import shaded.org.apache.parquet.example.data.Group;
import shaded.org.apache.parquet.filter2.compat.FilterCompat;
import shaded.org.apache.parquet.filter2.predicate.FilterApi;
import shaded.org.apache.parquet.filter2.predicate.FilterPredicate;
import shaded.org.apache.parquet.filter2.predicate.Operators;
import shaded.org.apache.parquet.filter2.predicate.UserDefinedPredicate;
import shaded.org.apache.parquet.io.api.Binary;
import shaded.org.apache.parquet.schema.MessageType;
import shaded.org.apache.parquet.schema.PrimitiveType;
import shaded.org.apache.parquet.schema.Type;

public class QSDataIterator
extends AbstractDataIterator {
    private static final Map<String, Object> oneRow = new HashMap<String, Object>();
    private static final IQsDataHandler ROW_NUM_DATA_HANDLER = new Int64DataHandler(true);
    private IQingFileVisitor _dataFile;
    private List<String> _qsFieldNames;
    private List<PrimitiveType> _qsFieldPrimTypes;
    private FilterCompat.Filter _qsfilter = FilterCompat.NOOP;
    private QingStorageRecordReader _reader;
    private long _rowCount;
    private long _currentRowIndex;
    private MessageType _recordSchema;
    private int _readerIndex;
    private boolean _isMutiFileSupport = false;
    private Group _record;
    private Map<String, Object> _currentRow;
    private IQsDataHandlerFactory dataHandlerFactory;

    public QSDataIterator(IQingFileVisitor dataFile, MetaInfo metaInfo, long rowCount, List<String> qsFieldNames, List<PrimitiveType> qsFieldPrimTypes, IQsDataHandlerFactory dataHandlerFactory) throws AbstractDataSourceException {
        super(metaInfo);
        this._rowCount = rowCount;
        this._dataFile = dataFile;
        this._qsFieldNames = qsFieldNames;
        this._qsFieldPrimTypes = qsFieldPrimTypes;
        this.dataHandlerFactory = dataHandlerFactory;
        if (this._dataFile instanceof IMutiFileSupport) {
            this._isMutiFileSupport = true;
            IMutiFileSupport mutiFileSupport = (IMutiFileSupport)this._dataFile;
            mutiFileSupport.setCurrentFile(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QSDataIterator(IQingFileVisitor dataFile, IQsDataHandlerFactory dataHandlerFactory) throws AbstractDataSourceException {
        super(QSDataIterator.passMetaInfo(dataFile));
        IMutiFileSupport mutiFileSupport;
        QingInputStream inputstream = null;
        FileMetaData fileMetaData = null;
        try {
            this._dataFile = dataFile;
            inputstream = dataFile.getInputStream();
            fileMetaData = QingStorageUtils.readQingStorageMetaData((AbstractInputStream)new QSInputstream(inputstream), (boolean)true);
            this._rowCount = fileMetaData.getRowCount();
            if (this._dataFile instanceof IMutiFileSupport) {
                mutiFileSupport = (IMutiFileSupport)this._dataFile;
                for (int index = 1; index < mutiFileSupport.getFileCount(); ++index) {
                    mutiFileSupport.setCurrentFile(index);
                    inputstream = this._dataFile.getInputStream();
                    FileMetaData subFileMetaData = QingStorageUtils.readQingStorageMetaData((AbstractInputStream)new QSInputstream(inputstream), (boolean)true);
                    this._rowCount += subFileMetaData.getRowCount();
                }
                mutiFileSupport.setCurrentFile(0);
            }
            List qsFieldTypes = fileMetaData.getSchema().getFields();
            this._qsFieldNames = new ArrayList<String>(qsFieldTypes.size());
            this._qsFieldPrimTypes = new ArrayList<PrimitiveType>(qsFieldTypes.size());
            for (Type qsFieldType : qsFieldTypes) {
                this._qsFieldNames.add(qsFieldType.getName());
                this._qsFieldPrimTypes.add(qsFieldType.asPrimitiveType());
            }
        }
        catch (IOException e) {
            try {
                AbstractDataSourceException.accessExcetpion((Throwable)e);
            }
            catch (Throwable throwable) {
                CloseUtil.close((Closeable[])new Closeable[]{inputstream});
                throw throwable;
            }
            CloseUtil.close((Closeable[])new Closeable[]{inputstream});
        }
        CloseUtil.close((Closeable[])new Closeable[]{inputstream});
        this.dataHandlerFactory = dataHandlerFactory;
        if (this._dataFile instanceof IMutiFileSupport) {
            this._isMutiFileSupport = true;
            mutiFileSupport = (IMutiFileSupport)this._dataFile;
            mutiFileSupport.setCurrentFile(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static MetaInfo passMetaInfo(IQingFileVisitor dataFile) throws AbstractDataSourceException {
        MetaInfo metaInfo;
        QingInputStream inputstream = null;
        try {
            inputstream = dataFile.getInputStream();
            FileMetaData fileMetaData = QingStorageUtils.readQingStorageMetaData((AbstractInputStream)new QSInputstream(inputstream), (boolean)true);
            String metaInfoString = (String)fileMetaData.getKeyValueMetaData().get(".metadata.");
            metaInfo = MetaInfoDecodeUtil.decode((String)metaInfoString);
        }
        catch (IOException e) {
            try {
                AbstractDataSourceException.accessExcetpion((Throwable)e);
            }
            catch (Throwable throwable) {
                CloseUtil.close((Closeable[])new Closeable[]{inputstream});
                inputstream = null;
                throw throwable;
            }
            CloseUtil.close((Closeable[])new Closeable[]{inputstream});
            return null;
        }
        CloseUtil.close((Closeable[])new Closeable[]{inputstream});
        return metaInfo;
    }

    public QSDataIterator(IQingFileVisitor dataFile) throws AbstractDataSourceException {
        this(dataFile, new DefaultDataHandlerFactory(false));
    }

    public IQingFileVisitor getDataFile() {
        return this._dataFile;
    }

    @Override
    protected void initImpl(Set<DSFieldKey> fields, Set<IPushdownFilter> dsFilters) throws AbstractDataSourceException {
        CloseUtil.close((Closeable[])new Closeable[]{this._reader});
        this._reader = null;
        if (this._hasData) {
            this.parseFilter(dsFilters);
            if (this._interestingFieldIndexs.size() == 0) {
                if (this._isMutiFileSupport) {
                    IMutiFileSupport mutiFileSupport = (IMutiFileSupport)this._dataFile;
                    mutiFileSupport.setCurrentFile(0);
                }
                this._currentRowIndex = 0L;
                return;
            }
            PrimitiveType[] columns = new PrimitiveType[this._interestingFieldIndexs.size()];
            int index = 0;
            Iterator iterator = this._interestingFieldIndexs.iterator();
            while (iterator.hasNext()) {
                int fieldIndex = (Integer)iterator.next();
                columns[index++] = this._qsFieldPrimTypes.get(fieldIndex);
            }
            this._recordSchema = new MessageType("envelope", (Type[])columns);
            this._readerIndex = 0;
            QingInputStream inputStream = null;
            try {
                inputStream = this._dataFile.getInputStream();
                this._reader = new QingStorageRecordReader((b)new QingStorageReadSupport(), this._qsfilter);
                this._reader.initialize((AbstractInputStream)new QSInputstream(inputStream), this._recordSchema);
            }
            catch (IOException e) {
                CloseUtil.close((Closeable[])new Closeable[]{inputStream});
                AbstractDataSourceException.accessExcetpion((Throwable)e);
            }
        }
    }

    private FilterPredicate parseDSContinuousFilter(int fieldNameIndex, DataType dataType, UnderDSContinuousFilter continuousFilter) {
        Operators.UserDefined subPredicate = null;
        boolean isContainNull = continuousFilter.isContainNull();
        Object ceiling = continuousFilter.getCeiling();
        Object floor = continuousFilter.getFloor();
        if (ceiling == null && floor == null && !isContainNull) {
            return subPredicate;
        }
        if (DataType.NUMBER == dataType) {
            BigDecimal bigDecimal;
            Operators.BinaryColumn binaryColumn = FilterApi.binaryColumn((String)this.getFieldID(fieldNameIndex));
            if (ceiling != null) {
                bigDecimal = (BigDecimal)ceiling;
                subPredicate = FilterApi.userDefined((Operators.Column)binaryColumn, (UserDefinedPredicate)QSFilterApi.decimal_ltEq((BigDecimal)bigDecimal));
            }
            if (floor != null) {
                bigDecimal = (BigDecimal)floor;
                Object object = subPredicate = subPredicate == null ? FilterApi.userDefined((Operators.Column)binaryColumn, (UserDefinedPredicate)QSFilterApi.decimal_gtEq((BigDecimal)bigDecimal)) : FilterApi.and((FilterPredicate)FilterApi.userDefined((Operators.Column)binaryColumn, (UserDefinedPredicate)QSFilterApi.decimal_gtEq((BigDecimal)bigDecimal)), (FilterPredicate)subPredicate);
            }
            if (isContainNull) {
                subPredicate = subPredicate == null ? FilterApi.eq((Operators.Column)binaryColumn, null) : FilterApi.or((FilterPredicate)FilterApi.eq((Operators.Column)binaryColumn, null), (FilterPredicate)subPredicate);
            }
            return subPredicate;
        }
        if (DataType.INT == dataType) {
            Long longValue;
            BigDecimal bigDecimal;
            Operators.LongColumn longColumn = FilterApi.longColumn((String)this.getFieldID(fieldNameIndex));
            if (ceiling != null) {
                bigDecimal = (BigDecimal)ceiling;
                longValue = bigDecimal.longValue();
                subPredicate = FilterApi.ltEq((Operators.Column)longColumn, (Comparable)longValue);
            }
            if (floor != null) {
                bigDecimal = (BigDecimal)floor;
                longValue = bigDecimal.longValue();
                Object object = subPredicate = subPredicate == null ? FilterApi.gtEq((Operators.Column)longColumn, (Comparable)longValue) : FilterApi.and((FilterPredicate)FilterApi.gtEq((Operators.Column)longColumn, (Comparable)longValue), (FilterPredicate)subPredicate);
            }
            if (isContainNull) {
                subPredicate = subPredicate == null ? FilterApi.eq((Operators.Column)longColumn, null) : FilterApi.or((FilterPredicate)FilterApi.eq((Operators.Column)longColumn, null), (FilterPredicate)subPredicate);
            }
        } else if (DataType.DATE == dataType || DataType.DATETIME == dataType) {
            Long longValue;
            Calendar calendar;
            Operators.LongColumn longColumn = FilterApi.longColumn((String)this.getFieldID(fieldNameIndex));
            if (ceiling != null) {
                calendar = (Calendar)ceiling;
                longValue = calendar.getTimeInMillis();
                subPredicate = FilterApi.ltEq((Operators.Column)longColumn, (Comparable)longValue);
            }
            if (floor != null) {
                calendar = (Calendar)floor;
                longValue = calendar.getTimeInMillis();
                Object object = subPredicate = subPredicate == null ? FilterApi.gtEq((Operators.Column)longColumn, (Comparable)longValue) : FilterApi.and((FilterPredicate)FilterApi.gtEq((Operators.Column)longColumn, (Comparable)longValue), (FilterPredicate)subPredicate);
            }
            if (isContainNull) {
                subPredicate = subPredicate == null ? FilterApi.eq((Operators.Column)longColumn, null) : FilterApi.or((FilterPredicate)FilterApi.eq((Operators.Column)longColumn, null), (FilterPredicate)subPredicate);
            }
        } else {
            throw new RuntimeException("Something must be wrong.");
        }
        return subPredicate;
    }

    private FilterPredicate parseDSDiscreteFilter(int fieldNameIndex, DataType dataType, UnderDSDiscreteFilter underDSDiscreteFilter) {
        boolean isExclud;
        Operators.UserDefined subPredicate;
        block43: {
            boolean hasData;
            boolean hasNull;
            List selectedValues;
            block44: {
                Operators.LongColumn longColumn;
                block46: {
                    Integer iFiscalYearStart;
                    Integer[] containsValue;
                    UnderDSDiscreteFilter.PartValue partValue;
                    block45: {
                        block42: {
                            subPredicate = null;
                            selectedValues = underDSDiscreteFilter.getSelected();
                            isExclud = underDSDiscreteFilter.isExclude();
                            hasNull = false;
                            hasData = false;
                            if (DataType.STRING != dataType && DataType.BOOLEAN != dataType) break block42;
                            Operators.BinaryColumn binaryColumn = FilterApi.binaryColumn((String)this.getFieldID(fieldNameIndex));
                            ArrayList<Binary> binaries = new ArrayList<Binary>();
                            for (int index = 0; index < selectedValues.size(); ++index) {
                                Object value = selectedValues.get(index);
                                if (value == null) {
                                    hasNull = true;
                                    continue;
                                }
                                hasData = true;
                                binaries.add(Binary.fromString((String)((String)selectedValues.get(index))));
                            }
                            int size = binaries.size() + (hasNull ? 1 : 0);
                            Binary[] containsValue2 = new Binary[size];
                            if (hasData) {
                                binaries.toArray(containsValue2);
                            }
                            subPredicate = FilterApi.userDefined((Operators.Column)binaryColumn, (UserDefinedPredicate)QSFilterApi.contains((Comparable[])containsValue2));
                            if (hasNull) {
                                subPredicate = subPredicate == null ? FilterApi.eq((Operators.Column)binaryColumn, null) : FilterApi.or((FilterPredicate)FilterApi.eq((Operators.Column)binaryColumn, null), (FilterPredicate)subPredicate);
                            }
                            break block43;
                        }
                        if (DataType.DATE != dataType && DataType.DATETIME != dataType) break block44;
                        partValue = underDSDiscreteFilter.getPartValue();
                        longColumn = FilterApi.longColumn((String)this.getFieldID(fieldNameIndex));
                        hasNull = selectedValues.contains(null);
                        containsValue = null;
                        iFiscalYearStart = underDSDiscreteFilter.getFiscalYearStart();
                        if (iFiscalYearStart > 1) break block45;
                        switch (partValue) {
                            case DATE_YEAR: {
                                containsValue = this.parseDateToIntValueForFilter(selectedValues, 0);
                                subPredicate = FilterApi.userDefined((Operators.Column)longColumn, (UserDefinedPredicate)QSFilterApi.date_range_year((Integer[])containsValue));
                                break block46;
                            }
                            case DATE_YQ: {
                                containsValue = this.parseDateToIntValueForFilter(selectedValues, 0);
                                subPredicate = FilterApi.userDefined((Operators.Column)longColumn, (UserDefinedPredicate)QSFilterApi.date_range_yearQuarter((Integer[])containsValue));
                                break block46;
                            }
                            case DATE_QUARTER: {
                                containsValue = this.parseDateToIntValueForFilter(selectedValues, 0);
                                subPredicate = FilterApi.userDefined((Operators.Column)longColumn, (UserDefinedPredicate)QSFilterApi.date_range_quarter((Integer[])containsValue));
                                break block46;
                            }
                            case DATE_DAY: {
                                containsValue = this.parseDateToIntValueForFilter(selectedValues, 0);
                                subPredicate = FilterApi.userDefined((Operators.Column)longColumn, (UserDefinedPredicate)QSFilterApi.date_range_day((Integer[])containsValue));
                                break block46;
                            }
                            case DATE_MONTH: {
                                containsValue = this.parseDateToIntValueForFilter(selectedValues, 0);
                                subPredicate = FilterApi.userDefined((Operators.Column)longColumn, (UserDefinedPredicate)QSFilterApi.date_range_month((Integer[])containsValue));
                                break block46;
                            }
                            case DATE_YM: {
                                containsValue = this.parseDateToIntValueForFilter(selectedValues, 1);
                                subPredicate = FilterApi.userDefined((Operators.Column)longColumn, (UserDefinedPredicate)QSFilterApi.date_range_yearMonth((Integer[])containsValue));
                                break block46;
                            }
                            case DATE_YMD: {
                                containsValue = this.parseDateToIntValueForFilter(selectedValues, 100);
                                subPredicate = FilterApi.userDefined((Operators.Column)longColumn, (UserDefinedPredicate)QSFilterApi.date_range_yearMonthDay((Integer[])containsValue));
                                break block46;
                            }
                            case DATE_EXACT: {
                                Comparable[] containsLongValue = this.parseDateToLongValueForFilter(selectedValues);
                                subPredicate = FilterApi.userDefined((Operators.Column)longColumn, (UserDefinedPredicate)QSFilterApi.contains((Comparable[])containsLongValue));
                                break block46;
                            }
                            default: {
                                throw new RuntimeException("Something must be wrong.");
                            }
                        }
                    }
                    switch (partValue) {
                        case DATE_YEAR: {
                            Integer[] years = this.parseDateToIntValueForFilter(selectedValues, 0);
                            containsValue = this.parseFY(iFiscalYearStart, years);
                            subPredicate = FilterApi.userDefined((Operators.Column)longColumn, (UserDefinedPredicate)QSFilterApi.date_range_yearMonth((Integer[])containsValue));
                            break;
                        }
                        case DATE_YQ: {
                            Integer[] yearQuarters = this.parseDateToIntValueForFilter(selectedValues, 0);
                            containsValue = this.parseFYQ(iFiscalYearStart, yearQuarters);
                            subPredicate = FilterApi.userDefined((Operators.Column)longColumn, (UserDefinedPredicate)QSFilterApi.date_range_yearMonth((Integer[])containsValue));
                            break;
                        }
                        case DATE_QUARTER: {
                            Integer[] quarters = this.parseDateToIntValueForFilter(selectedValues, 0);
                            containsValue = this.parseFQ(iFiscalYearStart, quarters);
                            subPredicate = FilterApi.userDefined((Operators.Column)longColumn, (UserDefinedPredicate)QSFilterApi.date_range_month((Integer[])containsValue));
                            break;
                        }
                        case DATE_YM: {
                            Integer[] yearMonths = this.parseDateToIntValueForFilter(selectedValues, 1);
                            subPredicate = FilterApi.userDefined((Operators.Column)longColumn, (UserDefinedPredicate)QSFilterApi.date_range_yearMonth((Integer[])yearMonths));
                            break;
                        }
                        case DATE_YMD: {
                            Integer[] yearMonthDays = this.parseDateToIntValueForFilter(selectedValues, 100);
                            subPredicate = FilterApi.userDefined((Operators.Column)longColumn, (UserDefinedPredicate)QSFilterApi.date_range_yearMonthDay((Integer[])yearMonthDays));
                            break;
                        }
                        case DATE_EXACT: {
                            Comparable[] longTimes = this.parseDateToLongValueForFilter(selectedValues);
                            subPredicate = FilterApi.userDefined((Operators.Column)longColumn, (UserDefinedPredicate)QSFilterApi.contains((Comparable[])longTimes));
                            break;
                        }
                        case DATE_DAY: {
                            containsValue = this.parseDateToIntValueForFilter(selectedValues, 0);
                            subPredicate = FilterApi.userDefined((Operators.Column)longColumn, (UserDefinedPredicate)QSFilterApi.date_range_day((Integer[])containsValue));
                            break;
                        }
                        case DATE_MONTH: {
                            containsValue = this.parseDateToIntValueForFilter(selectedValues, 0);
                            subPredicate = FilterApi.userDefined((Operators.Column)longColumn, (UserDefinedPredicate)QSFilterApi.date_range_month((Integer[])containsValue));
                            break;
                        }
                        default: {
                            throw new RuntimeException("Something must be wrong.");
                        }
                    }
                }
                if (hasNull) {
                    subPredicate = subPredicate == null ? FilterApi.eq((Operators.Column)longColumn, null) : FilterApi.or((FilterPredicate)FilterApi.eq((Operators.Column)longColumn, null), (FilterPredicate)subPredicate);
                }
                break block43;
            }
            if (DataType.INT == dataType) {
                Operators.LongColumn longColumn = FilterApi.longColumn((String)this.getFieldID(fieldNameIndex));
                ArrayList<Long> longValues = new ArrayList<Long>();
                for (int index = 0; index < selectedValues.size(); ++index) {
                    Object value = selectedValues.get(index);
                    if (value == null) {
                        hasNull = true;
                        continue;
                    }
                    hasData = true;
                    try {
                        longValues.add(Long.valueOf(value.toString()));
                        continue;
                    }
                    catch (NumberFormatException years) {
                        // empty catch block
                    }
                }
                int size = longValues.size() + (hasNull ? 1 : 0);
                Comparable[] containsValue = new Long[size];
                if (hasData) {
                    longValues.toArray(containsValue);
                }
                subPredicate = FilterApi.userDefined((Operators.Column)longColumn, (UserDefinedPredicate)QSFilterApi.contains((Comparable[])containsValue));
                if (hasNull) {
                    subPredicate = subPredicate == null ? FilterApi.eq((Operators.Column)longColumn, null) : FilterApi.or((FilterPredicate)FilterApi.eq((Operators.Column)longColumn, null), (FilterPredicate)subPredicate);
                }
            } else if (DataType.NUMBER == dataType) {
                Operators.BinaryColumn binaryColumn = FilterApi.binaryColumn((String)this.getFieldID(fieldNameIndex));
                ArrayList<Binary> binaries = new ArrayList<Binary>();
                for (int index = 0; index < selectedValues.size(); ++index) {
                    Object value = selectedValues.get(index);
                    if (value == null) {
                        hasNull = true;
                        continue;
                    }
                    hasData = true;
                    try {
                        BigDecimal bigDecimal = new BigDecimal(value.toString());
                        byte[] bytes = QingStorageUtils.encodeBigDecimal((BigDecimal)bigDecimal, (int)16);
                        binaries.add(Binary.fromConstantByteArray((byte[])bytes));
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                int size = binaries.size() + (hasNull ? 1 : 0);
                Binary[] containsValue = new Binary[size];
                if (hasData) {
                    binaries.toArray(containsValue);
                }
                subPredicate = FilterApi.userDefined((Operators.Column)binaryColumn, (UserDefinedPredicate)QSFilterApi.contains((Comparable[])containsValue));
                if (hasNull) {
                    subPredicate = subPredicate == null ? FilterApi.eq((Operators.Column)binaryColumn, null) : FilterApi.or((FilterPredicate)FilterApi.eq((Operators.Column)binaryColumn, null), (FilterPredicate)subPredicate);
                }
            } else {
                throw new RuntimeException("Something must be wrong.");
            }
        }
        if (isExclud) {
            subPredicate = FilterApi.not((FilterPredicate)subPredicate);
        }
        return subPredicate;
    }

    private Integer[] parseFY(Integer iFiscalYearStart, Integer[] years) {
        ArrayList<Integer> yearMonths = new ArrayList<Integer>();
        for (Integer year : years) {
            if (year == null) {
                yearMonths.add(null);
                continue;
            }
            for (int month = 1; month <= 12; ++month) {
                if (month < iFiscalYearStart) {
                    yearMonths.add(year * 100 + month);
                    continue;
                }
                yearMonths.add((year - 1) * 100 + month);
            }
        }
        Integer[] containsValue = new Integer[yearMonths.size()];
        containsValue = yearMonths.toArray(containsValue);
        return containsValue;
    }

    private Integer[] parseFQ(Integer iFiscalYearStart, Integer[] quarters) {
        ArrayList<Integer> months = new ArrayList<Integer>();
        for (Integer quarter : quarters) {
            if (quarter == null) {
                months.add(null);
                continue;
            }
            for (int time = 1; time <= 3; ++time) {
                Integer month = (quarter - 1) * 3 + time + iFiscalYearStart - 2;
                if (month < 12) {
                    months.add(month);
                    continue;
                }
                months.add(month % 12);
            }
        }
        Integer[] containsValue = new Integer[months.size()];
        containsValue = months.toArray(containsValue);
        return containsValue;
    }

    private Integer[] parseFYQ(Integer iFiscalYearStart, Integer[] yearQuarters) {
        ArrayList<Integer> yearMonths = new ArrayList<Integer>();
        for (Integer yearQuarter : yearQuarters) {
            if (yearQuarter == null) {
                yearMonths.add(null);
                continue;
            }
            Integer year = yearQuarter / 100;
            Integer quarter = yearQuarter % 100;
            for (int time = 1; time <= 3; ++time) {
                Integer month = (quarter - 1) * 3 + time + iFiscalYearStart;
                if (month <= 12) {
                    yearMonths.add(year * 100 + month);
                    continue;
                }
                yearMonths.add((year - 1) * 100 + month % 12);
            }
        }
        Integer[] containsValue = new Integer[yearMonths.size()];
        containsValue = yearMonths.toArray(containsValue);
        return containsValue;
    }

    private void parseFilter(Set<IPushdownFilter> dsFilters) {
        this._qsfilter = FilterCompat.NOOP;
        if (dsFilters != null && !dsFilters.isEmpty()) {
            FilterPredicate predicate = null;
            for (IPushdownFilter dsFilter : dsFilters) {
                if (dsFilter instanceof AbstractUnderDSFilter) {
                    int fieldNameIndex = this._metaInfo.getFieldNameIndex(((AbstractUnderDSFilter)dsFilter).getField().getPropertyName());
                    DataType dataType = this._metaInfo.getFieldDataType(fieldNameIndex);
                    FilterPredicate subPredicate = null;
                    if (dsFilter instanceof UnderDSContinuousFilter) {
                        UnderDSContinuousFilter underDSContinuousFilter = (UnderDSContinuousFilter)dsFilter;
                        subPredicate = this.parseDSContinuousFilter(fieldNameIndex, dataType, underDSContinuousFilter);
                    } else if (dsFilter instanceof UnderDSDiscreteFilter) {
                        UnderDSDiscreteFilter underDSDiscreteFilter = (UnderDSDiscreteFilter)dsFilter;
                        subPredicate = this.parseDSDiscreteFilter(fieldNameIndex, dataType, underDSDiscreteFilter);
                    }
                    predicate = predicate == null ? subPredicate : FilterApi.and(predicate, subPredicate);
                    continue;
                }
                throw new RuntimeException("TODO");
            }
            if (predicate != null) {
                this._qsfilter = FilterCompat.get(predicate);
            }
        }
    }

    private String getFieldID(int index) {
        return this._qsFieldNames.get(index);
    }

    private Integer[] parseDateToIntValueForFilter(List<String> selectedValues, int addValue) {
        boolean hasData = false;
        boolean hasNull = false;
        ArrayList<Integer> integers = new ArrayList<Integer>();
        for (int index = 0; index < selectedValues.size(); ++index) {
            String value = selectedValues.get(index);
            if (value == null) {
                hasNull = true;
                continue;
            }
            hasData = true;
            try {
                int dateTimeValue = Integer.parseInt(selectedValues.get(index));
                integers.add(dateTimeValue + addValue);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        int size = integers.size() + (hasNull ? 1 : 0);
        Integer[] containsValue = new Integer[size];
        if (hasData) {
            integers.toArray(containsValue);
        }
        return containsValue;
    }

    private Long[] parseDateToLongValueForFilter(List<String> selectedValues) {
        boolean hasData = false;
        boolean hasNull = false;
        ArrayList<Long> longs = new ArrayList<Long>();
        for (int index = 0; index < selectedValues.size(); ++index) {
            String value = selectedValues.get(index);
            if (value == null) {
                hasNull = true;
                continue;
            }
            hasData = true;
            try {
                Long dateTimeValue = Long.parseLong(selectedValues.get(index));
                longs.add(dateTimeValue);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        int size = longs.size() + (hasNull ? 1 : 0);
        Long[] containsValue = new Long[size];
        if (hasData) {
            longs.toArray(containsValue);
        }
        return containsValue;
    }

    @Override
    protected boolean hasNextRowImpl() throws AbstractDataSourceException, InterruptedException {
        this._currentRow = null;
        if (!this._hasData) {
            return false;
        }
        if (this._recordSchema == null) {
            this._currentRow = oneRow;
            if (this._currentRowIndex < this._rowCount) {
                ++this._currentRowIndex;
                return true;
            }
            return false;
        }
        boolean success = false;
        QingInputStream inputstream = null;
        try {
            success = this._reader.nextKeyValue();
            while (this._isMutiFileSupport && !success) {
                CloseUtil.close((Closeable[])new Closeable[]{this._reader});
                this._reader = null;
                IMutiFileSupport mutiFileSupport = (IMutiFileSupport)this._dataFile;
                ++this._readerIndex;
                if (this._readerIndex >= mutiFileSupport.getFileCount()) break;
                mutiFileSupport.setCurrentFile(this._readerIndex);
                inputstream = this._dataFile.getInputStream();
                this._reader = new QingStorageRecordReader((b)new QingStorageReadSupport(), this._qsfilter);
                this._reader.initialize((AbstractInputStream)new QSInputstream(inputstream), this._recordSchema);
                success = this._reader.nextKeyValue();
            }
            if (success) {
                this._record = (Group)this._reader.getCurrentValue();
            }
        }
        catch (IOException e) {
            CloseUtil.close((Closeable[])new Closeable[]{this._reader});
            CloseUtil.close((Closeable[])new Closeable[]{inputstream});
            this._reader = null;
            AbstractDataSourceException.accessExcetpion((Throwable)e);
        }
        catch (InterruptedException e) {
            CloseUtil.close((Closeable[])new Closeable[]{this._reader});
            CloseUtil.close((Closeable[])new Closeable[]{inputstream});
            this._reader = null;
            throw e;
        }
        if (success) {
            HashMap<String, Object> row = new HashMap<String, Object>();
            for (int index = 0; index < this._interestingFieldIndexs.size(); ++index) {
                int fieldIndex = (Integer)this._interestingFieldIndexs.get(index);
                String fieldFullName = (String)this._allFullFieldNames.get(fieldIndex);
                int count = this._record.getFieldRepetitionCount(index);
                if (count == 0) {
                    row.put(fieldFullName, null);
                    continue;
                }
                if (this._interestingRowIDFieldIndexs.contains(fieldIndex)) {
                    Object realValue = ROW_NUM_DATA_HANDLER.handle(this._record, index, DataType.INT);
                    row.put(fieldFullName, realValue);
                    continue;
                }
                DataType dataType = this._metaInfo.getFieldDataType(fieldIndex);
                IQsDataHandler dataHandler = this.dataHandlerFactory.getDataHandler(dataType);
                Object realValue = dataHandler.handle(this._record, index, dataType);
                row.put(fieldFullName, realValue);
            }
            this._currentRow = row;
        }
        return success;
    }

    @Override
    protected Map<String, Object> nextRowImpl() {
        return this._currentRow;
    }

    @Override
    protected void closeImpl() {
        CloseUtil.close((Closeable[])new Closeable[]{this._reader});
        this._reader = null;
    }

    public void setAllFieldsNeeded(boolean isAllFieldsNeeded) {
    }
}

