/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.datasource.spec.qs;

import com.kingdee.bos.qing.common.framework.server.task.ServerRequestInvokeContext;
import com.kingdee.bos.qing.datasource.exception.AbstractDataSourceException;
import com.kingdee.bos.qing.datasource.exception.DataSourceNoDataException;
import com.kingdee.bos.qing.datasource.io.IMutiFileSupport;
import com.kingdee.bos.qing.datasource.meta.DSFieldKey;
import com.kingdee.bos.qing.datasource.meta.DSMeta;
import com.kingdee.bos.qing.datasource.meta.DSMetaEntity;
import com.kingdee.bos.qing.datasource.meta.DSMetaProperty;
import com.kingdee.bos.qing.datasource.meta.DataType;
import com.kingdee.bos.qing.datasource.meta.MetaInfo;
import com.kingdee.bos.qing.datasource.meta.MetaInfoDecodeUtil;
import com.kingdee.bos.qing.datasource.model.filter.AbstractUnderDSFilter;
import com.kingdee.bos.qing.datasource.model.filter.IPushdownFilter;
import com.kingdee.bos.qing.datasource.spec.AbstractSingleDataSourceVisitor;
import com.kingdee.bos.qing.datasource.spec.IDataIterator;
import com.kingdee.bos.qing.datasource.spec.IDataSourceCountable;
import com.kingdee.bos.qing.datasource.spec.IDistinctValueCollecter;
import com.kingdee.bos.qing.datasource.spec.qs.QSDataIterator;
import com.kingdee.bos.qing.datasource.spec.qs.QSInputstream;
import com.kingdee.bos.qing.datasource.spec.qsdatahandler.DefaultDataHandlerFactory;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFileVisitor;
import com.kingdee.bos.qing.filesystem.stream.QingInputStream;
import com.kingdee.bos.qing.util.CloseUtil;
import com.kingdee.bos.qing.util.LogUtil;
import java.io.Closeable;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import q.datasource.io.AbstractInputStream;
import q.storage.columnar.metadata.FileMetaData;
import q.storage.columnar.util.QingStorageUtils;
import shaded.org.apache.parquet.column.statistics.LongStatistics;
import shaded.org.apache.parquet.hadoop.metadata.ColumnPath;
import shaded.org.apache.parquet.schema.PrimitiveType;
import shaded.org.apache.parquet.schema.Type;

public class QSDataSourceVisitor
extends AbstractSingleDataSourceVisitor
implements IDataSourceCountable {
    private long _rowCount = -1L;
    private MetaInfo _metaInfo;
    private DSMeta _dSMeta;
    private IQingFileVisitor _dataFile;
    private List<String> _qsFieldNames;
    private ArrayList<PrimitiveType> _qsFieldPrimTypes;
    private Set<AbstractUnderDSFilter> _outerFilter;

    public void setOuterFilter(Set<AbstractUnderDSFilter> outerFilter) {
        this._outerFilter = outerFilter;
    }

    public Set<AbstractUnderDSFilter> getOuterFilter() {
        return this._outerFilter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QSDataSourceVisitor(IQingFileVisitor dataFile) throws AbstractDataSourceException {
        this._dataFile = dataFile;
        QingInputStream inputstream = null;
        try {
            inputstream = dataFile.getInputStream();
            FileMetaData fileMetaData = QingStorageUtils.readQingStorageMetaData((AbstractInputStream)new QSInputstream(inputstream), (boolean)true);
            this._rowCount = fileMetaData.getRowCount();
            if (this._dataFile instanceof IMutiFileSupport) {
                IMutiFileSupport mutiFileSupport = (IMutiFileSupport)this._dataFile;
                for (int index = 1; index < mutiFileSupport.getFileCount(); ++index) {
                    mutiFileSupport.setCurrentFile(index);
                    inputstream = this._dataFile.getInputStream();
                    FileMetaData subFileMetaData = QingStorageUtils.readQingStorageMetaData((AbstractInputStream)new QSInputstream(inputstream), (boolean)true);
                    this._rowCount += subFileMetaData.getRowCount();
                }
                mutiFileSupport.setCurrentFile(0);
            }
            String metaInfoString = (String)fileMetaData.getKeyValueMetaData().get(".metadata.");
            List qsFieldTypes = fileMetaData.getSchema().getFields();
            this._qsFieldNames = new ArrayList<String>(qsFieldTypes.size());
            this._qsFieldPrimTypes = new ArrayList(qsFieldTypes.size());
            for (Type qsFieldType : qsFieldTypes) {
                this._qsFieldNames.add(qsFieldType.getName());
                this._qsFieldPrimTypes.add(qsFieldType.asPrimitiveType());
            }
            this._metaInfo = MetaInfoDecodeUtil.decode((String)metaInfoString);
        }
        catch (IOException e) {
            try {
                AbstractDataSourceException.accessExcetpion((Throwable)e);
            }
            catch (Throwable throwable) {
                CloseUtil.close((Closeable[])new Closeable[]{inputstream});
                throw throwable;
            }
            CloseUtil.close((Closeable[])new Closeable[]{inputstream});
        }
        CloseUtil.close((Closeable[])new Closeable[]{inputstream});
    }

    public IQingFileVisitor getDataFile() {
        return this._dataFile;
    }

    @Override
    public boolean hasData() {
        return this._rowCount != 0L;
    }

    @Override
    public long getRowCount() {
        return this._rowCount;
    }

    public IDataIterator iterator() throws AbstractDataSourceException {
        if (!this.hasData()) {
            throw new DataSourceNoDataException("no data in datasource");
        }
        QSDataIterator iterator = new QSDataIterator(this._dataFile, this._metaInfo, this._rowCount, this._qsFieldNames, this._qsFieldPrimTypes, new DefaultDataHandlerFactory(false));
        iterator.setOuterFilter(this._outerFilter);
        return iterator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean collectDistinctValue(IDistinctValueCollecter valueCollecter, DSFieldKey field, int fieldIndex, int resultSize) throws AbstractDataSourceException, InterruptedException {
        boolean supportGetDistinctValuePushDown;
        QingInputStream inputstream;
        block20: {
            String fieldName = field.getPropertyName();
            int fieldNameIndex = this._metaInfo.getFieldNameIndex(fieldName);
            inputstream = null;
            DataType dataType = this._metaInfo.getFieldDataType(fieldNameIndex);
            int currentFileIndex = 0;
            if (this._dataFile instanceof IMutiFileSupport) {
                IMutiFileSupport mutiFileSupport = (IMutiFileSupport)this._dataFile;
                mutiFileSupport.setCurrentFile(currentFileIndex);
            }
            String qsFieldName = this._qsFieldNames.get(fieldNameIndex);
            supportGetDistinctValuePushDown = true;
            try {
                inputstream = this._dataFile.getInputStream();
                HashSet allDistinctValues = new HashSet();
                while (inputstream != null) {
                    ServerRequestInvokeContext.staticCheckInterrupt();
                    Set distinctValues = null;
                    if (DataType.STRING == dataType) {
                        distinctValues = QingStorageUtils.getDistinctStringValuesFast((AbstractInputStream)new QSInputstream(inputstream), (ColumnPath)ColumnPath.fromDotString((String)qsFieldName), (boolean)true);
                    } else if (DataType.NUMBER == dataType) {
                        distinctValues = QingStorageUtils.getDistinctDecimalValuesFast((AbstractInputStream)new QSInputstream(inputstream), (ColumnPath)ColumnPath.fromDotString((String)qsFieldName), (boolean)true);
                    } else if (DataType.DATE == dataType || DataType.INT == dataType) {
                        distinctValues = QingStorageUtils.getDistinctLongValuesFast((AbstractInputStream)new QSInputstream(inputstream), (ColumnPath)ColumnPath.fromDotString((String)qsFieldName), (boolean)true);
                    }
                    if (distinctValues == null || distinctValues.size() <= 0) {
                        supportGetDistinctValuePushDown = false;
                        allDistinctValues.clear();
                        break;
                    }
                    allDistinctValues.addAll(distinctValues);
                    if (this._dataFile instanceof IMutiFileSupport && ++currentFileIndex < ((IMutiFileSupport)this._dataFile).getFileCount()) {
                        IMutiFileSupport mutiFileSupport = (IMutiFileSupport)this._dataFile;
                        mutiFileSupport.setCurrentFile(currentFileIndex);
                        inputstream = this._dataFile.getInputStream();
                        continue;
                    }
                    inputstream = null;
                }
                if (!supportGetDistinctValuePushDown) break block20;
                for (Object value : allDistinctValues) {
                    HashMap<String, Object> result = new HashMap<String, Object>(resultSize);
                    ServerRequestInvokeContext.staticCheckInterrupt();
                    if (value == null) {
                        result.put(field.toFullName(), value);
                        valueCollecter.collect(result);
                    } else if (DataType.DATE == dataType) {
                        Calendar calendar = Calendar.getInstance();
                        calendar.setTimeInMillis((Long)value);
                        result.put(field.toFullName(), calendar);
                        valueCollecter.collect(result);
                    } else if (DataType.INT == dataType) {
                        BigDecimal bigDecimal = new BigDecimal((Long)value);
                        result.put(field.toFullName(), bigDecimal);
                        valueCollecter.collect(result);
                    } else {
                        result.put(field.toFullName(), value);
                        valueCollecter.collect(result);
                    }
                    if (!valueCollecter.isBreak()) continue;
                    break;
                }
            }
            catch (IOException e) {
                try {
                    LogUtil.error((String)e.getMessage(), (Throwable)e);
                }
                catch (Throwable throwable) {
                    CloseUtil.close((Closeable[])new Closeable[]{inputstream});
                    throw throwable;
                }
                CloseUtil.close((Closeable[])new Closeable[]{inputstream});
            }
        }
        CloseUtil.close((Closeable[])new Closeable[]{inputstream});
        return supportGetDistinctValuePushDown;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Calendar[] getDateScope(DSFieldKey field) throws AbstractDataSourceException, InterruptedException {
        if (!this.hasData()) {
            return null;
        }
        int fieldNameIndex = this._metaInfo.getFieldNameIndex(field.getPropertyName());
        DataType dataType = this._metaInfo.getFieldDataType(fieldNameIndex);
        if (dataType == null || DataType.DATE != dataType && DataType.DATETIME != dataType) {
            return null;
        }
        QingInputStream inputstream = null;
        int currentFileIndex = 0;
        Calendar minValue = null;
        Calendar maxValue = null;
        if (this._dataFile instanceof IMutiFileSupport) {
            IMutiFileSupport mutiFileSupport = (IMutiFileSupport)this._dataFile;
            mutiFileSupport.setCurrentFile(currentFileIndex);
        }
        String qsFieldName = this._qsFieldNames.get(fieldNameIndex);
        try {
            inputstream = this._dataFile.getInputStream();
            while (inputstream != null) {
                ServerRequestInvokeContext.staticCheckInterrupt();
                LongStatistics statistics = (LongStatistics)QingStorageUtils.getStatistics((AbstractInputStream)new QSInputstream(inputstream), (ColumnPath)ColumnPath.fromDotString((String)qsFieldName), (boolean)true);
                Calendar minCalendar = Calendar.getInstance();
                minCalendar.setTimeInMillis(statistics.getMin());
                if (minValue == null) {
                    minValue = minCalendar;
                } else if (minCalendar.compareTo(minValue) < 0) {
                    minValue = minCalendar;
                }
                Calendar maxCalendar = Calendar.getInstance();
                maxCalendar.setTimeInMillis(statistics.getMax());
                if (maxValue == null) {
                    maxValue = maxCalendar;
                } else if (maxCalendar.compareTo(maxValue) > 0) {
                    maxValue = maxCalendar;
                }
                if (this._dataFile instanceof IMutiFileSupport && ++currentFileIndex < ((IMutiFileSupport)this._dataFile).getFileCount()) {
                    IMutiFileSupport mutiFileSupport = (IMutiFileSupport)this._dataFile;
                    mutiFileSupport.setCurrentFile(currentFileIndex);
                    inputstream = this._dataFile.getInputStream();
                    continue;
                }
                inputstream = null;
            }
        }
        catch (IOException e) {
            try {
                LogUtil.error((String)e.getMessage(), (Throwable)e);
            }
            catch (Throwable throwable) {
                CloseUtil.close((Closeable[])new Closeable[]{inputstream});
                throw throwable;
            }
            CloseUtil.close((Closeable[])new Closeable[]{inputstream});
        }
        CloseUtil.close((Closeable[])new Closeable[]{inputstream});
        if (minValue == null && maxValue == null) {
            return null;
        }
        return new Calendar[]{minValue, maxValue};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BigDecimal[] getNumberScope(DSFieldKey field) throws AbstractDataSourceException, InterruptedException {
        if (!this.hasData()) {
            return null;
        }
        String fieldName = field.getPropertyName();
        int fieldNameIndex = this._metaInfo.getFieldNameIndex(fieldName);
        DataType dataType = this._metaInfo.getFieldDataType(fieldNameIndex);
        if (dataType == null || DataType.INT != dataType && DataType.NUMBER != dataType) {
            return null;
        }
        BigDecimal minValue = null;
        BigDecimal maxValue = null;
        IDataIterator iterator = this.iterator();
        try {
            HashSet<DSFieldKey> keys = new HashSet<DSFieldKey>();
            keys.add(field);
            iterator.init(keys, null, null);
            while (iterator.hasNextRow()) {
                ServerRequestInvokeContext.staticCheckInterrupt();
                Map row = iterator.nextRow();
                Object value = row.get(field.toFullName());
                if (value == null) continue;
                BigDecimal comparingValue = null;
                comparingValue = value instanceof BigDecimal ? (BigDecimal)value : new BigDecimal(String.valueOf(value));
                minValue = minValue == null ? comparingValue : minValue.min(comparingValue);
                if (maxValue == null) {
                    maxValue = comparingValue;
                    continue;
                }
                maxValue = maxValue.max(comparingValue);
            }
        }
        catch (Throwable throwable) {
            CloseUtil.close((Closeable[])new Closeable[]{iterator});
            throw throwable;
        }
        CloseUtil.close((Closeable[])new Closeable[]{iterator});
        if (minValue == null && maxValue == null) {
            return null;
        }
        return new BigDecimal[]{minValue, maxValue};
    }

    @Override
    public void doCollectDistinctValue(IDistinctValueCollecter valueCollecter, List<DSFieldKey> fields, List<DSFieldKey> exsitField, Set<IPushdownFilter> filters) throws AbstractDataSourceException, InterruptedException {
        boolean supportGetDistinctValuePushDown = false;
        if ((filters == null || filters.isEmpty()) && exsitField.size() == 1) {
            DSFieldKey firstField = null;
            int firstFieldIndex = -1;
            for (int index = 0; index < fields.size(); ++index) {
                DSFieldKey field = fields.get(index);
                if (field == null) continue;
                firstField = field;
                firstFieldIndex = index;
                break;
            }
            if (firstField != null) {
                supportGetDistinctValuePushDown = this.collectDistinctValue(valueCollecter, firstField, firstFieldIndex, fields.size());
            }
        }
        if (!supportGetDistinctValuePushDown) {
            QSDataSourceVisitor.collectDistinctValueWithIterator(this.iterator(), valueCollecter, fields, exsitField, filters);
        }
    }

    @Override
    public MetaInfo getMetaInfo() {
        return this._metaInfo;
    }

    public DSMeta getMeta() {
        if (this._dSMeta == null) {
            this._dSMeta = new DSMeta();
            ArrayList<DSMetaProperty> properties = new ArrayList<DSMetaProperty>(this._metaInfo.getSize());
            int c = this._metaInfo.getSize();
            for (int i = 0; i < c; ++i) {
                String name = this._metaInfo.getFieldName(i);
                String displayName = this._metaInfo.getFieldDisplayName(i);
                DataType dataType = this._metaInfo.getFieldDataType(i);
                Boolean fieldIsHide = this._metaInfo.getFieldIsHides(i);
                properties.add(new DSMetaProperty(name, displayName, dataType, null, fieldIsHide));
            }
            DSMetaEntity dsme = DSMetaEntity.createInstanceForSingleMode(properties);
            dsme.setSubViews(this._metaInfo.getSubViews());
            dsme.setViewItems(this._metaInfo.getViewItems());
            dsme.setParentChildDimensions(this._metaInfo.getDsParentChildDimensions());
            ArrayList<DSMetaEntity> dsmes = new ArrayList<DSMetaEntity>();
            dsmes.add(dsme);
            this._dSMeta.setEntities(dsmes);
            this._dSMeta.setEliminations(this._metaInfo.getEliminations());
        }
        return this._dSMeta;
    }
}

