/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.datasource.spec.qsdatahandler;

import com.kingdee.bos.qing.datasource.meta.DataType;
import com.kingdee.bos.qing.datasource.spec.qsdatahandler.IQsDataHandler;
import java.math.BigDecimal;
import java.util.Calendar;
import shaded.org.apache.parquet.example.data.Group;

public class Int64DataHandler
implements IQsDataHandler {
    private boolean usePrimitive = false;

    public Int64DataHandler(boolean usePrimitive) {
        this.usePrimitive = usePrimitive;
    }

    @Override
    public Object handle(Group _record, int colIndex, DataType dataType) {
        Long value = _record.getLong(colIndex, 0);
        if (this.usePrimitive) {
            return value;
        }
        if (dataType == DataType.DATE || dataType == DataType.DATETIME) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTimeInMillis(value);
            return calendar;
        }
        return new BigDecimal(value);
    }
}

