/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.dbmanage;

import com.kingdee.bos.qing.common.context.IQingContextable;
import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.dao.IDBAccessable;
import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ITransactionManagement;
import com.kingdee.bos.qing.data.domain.source.db.AbstractDBSourceJDBCAdapter;
import com.kingdee.bos.qing.data.domain.source.db.IConnectionFactory;
import com.kingdee.bos.qing.data.exception.UnSupportDataSourceException;
import com.kingdee.bos.qing.data.exception.api.OpenAPIException;
import com.kingdee.bos.qing.data.model.designtime.AbstractSource;
import com.kingdee.bos.qing.data.model.designtime.source.DBSource;
import com.kingdee.bos.qing.data.util.SourceFactory;
import com.kingdee.bos.qing.dbmanage.domain.DBConnectionDomain;
import com.kingdee.bos.qing.dbmanage.exception.NoDbManagePermException;
import com.kingdee.bos.qing.dbmanage.model.DBConnection;
import com.kingdee.bos.qing.response.IResponseWrap;
import com.kingdee.bos.qing.response.ResponseSuccessWrap;
import com.kingdee.bos.qing.response.ResponseUtil;
import com.kingdee.bos.qing.util.JsonUtil;
import java.util.List;
import java.util.Map;

public abstract class AbstractDBManageService
implements IDBAccessable,
IQingContextable {
    private IDBExcuter dbExcuter;
    private ITransactionManagement tx;
    protected QingContext qingContext;
    private DBConnectionDomain dbConnectionDomain;

    public void setQingContext(QingContext qingContext) {
        this.qingContext = qingContext;
    }

    public void setDbExcuter(IDBExcuter dbExcuter) {
        this.dbExcuter = dbExcuter;
    }

    public void setTx(ITransactionManagement tx) {
        this.tx = tx;
    }

    private DBConnectionDomain getDBConnectionDomain() {
        if (this.dbConnectionDomain == null) {
            this.dbConnectionDomain = new DBConnectionDomain(this.dbExcuter, this.tx, this.qingContext);
        }
        return this.dbConnectionDomain;
    }

    public byte[] saveDBConnection(Map<String, String> params) {
        try {
            if (this.checkDBManagePermImpl(params)) {
                String jsonDBConnection = params.get("model");
                boolean isPwdUpdated = Boolean.parseBoolean(params.get("passwordUpdated"));
                DBConnection dbConnection = SourceFactory.decodeFromJson(jsonDBConnection, DBConnection.class);
                dbConnection.setShared(false);
                dbConnection = this.getDBConnectionDomain().saveDBConnection(dbConnection, isPwdUpdated);
                return ResponseUtil.output((IResponseWrap)new ResponseSuccessWrap((Object)dbConnection));
            }
            return ResponseUtil.output((Exception)((Object)new NoDbManagePermException()));
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    public byte[] loadDBConnections(Map<String, String> params) {
        try {
            List<DBConnection> dbConnections = this.getDBConnectionDomain().loadDBConnWithoutDBCenter();
            return ResponseUtil.output((IResponseWrap)new ResponseSuccessWrap(dbConnections));
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    public byte[] deleteDBConnection(Map<String, String> params) {
        try {
            if (this.checkDBManagePermImpl(params)) {
                String dbInfoId = params.get("id");
                this.getDBConnectionDomain().deleteDBConnection(dbInfoId);
                return ResponseUtil.output((IResponseWrap)new ResponseSuccessWrap((Object)true));
            }
            return ResponseUtil.output((Exception)((Object)new NoDbManagePermException()));
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    @Deprecated
    public byte[] deleteDBConnections(Map<String, String> params) {
        String jsonIds = params.get("dbIds");
        List ids = (List)JsonUtil.decodeFromString((String)jsonIds, List.class);
        try {
            if (this.checkDBManagePermImpl(params)) {
                this.getDBConnectionDomain().deleteDBConnectionsWithoutTx(ids);
                return ResponseUtil.output((IResponseWrap)new ResponseSuccessWrap((Object)true));
            }
            return ResponseUtil.output((Exception)((Object)new NoDbManagePermException()));
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    public byte[] updateDBConnection(Map<String, String> params) {
        String jsonDBConnection = params.get("model");
        boolean isPwdUpdated = Boolean.parseBoolean(params.get("passwordUpdated"));
        DBConnection dbConnection = SourceFactory.decodeFromJson(jsonDBConnection, DBConnection.class);
        try {
            if (this.checkDBManagePermImpl(params)) {
                return ResponseUtil.output((IResponseWrap)new ResponseSuccessWrap((Object)this.getDBConnectionDomain().updateDBConnection(dbConnection, isPwdUpdated)));
            }
            return ResponseUtil.output((Exception)((Object)new NoDbManagePermException()));
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    public byte[] checkConnection(Map<String, String> params) {
        try {
            if (this.checkDBManagePermImpl(params)) {
                String jsonSource = params.get("source");
                String dbConnectId = params.get("dbConnectId");
                boolean isPwdUpdated = Boolean.parseBoolean(params.get("passwordUpdated"));
                AbstractSource source = SourceFactory.instancefromJson(jsonSource);
                if (!isPwdUpdated) {
                    this.getDBConnectionDomain().getActualPassword(source, dbConnectId);
                }
                DBSource dbSource = AbstractDBSourceJDBCAdapter.createDBSourceBySource(source, this.qingContext);
                IConnectionFactory connFactory = AbstractDBSourceJDBCAdapter.createConnFactoryBySource(source, this.qingContext);
                AbstractDBSourceJDBCAdapter jdbcAdapter = AbstractDBSourceJDBCAdapter.newInstance(dbSource);
                jdbcAdapter.setConnectionFactory(connFactory);
                boolean result = jdbcAdapter.checkConnection(this.qingContext, source);
                ResponseSuccessWrap wrap = new ResponseSuccessWrap((Object)result);
                return ResponseUtil.output((IResponseWrap)wrap);
            }
            return ResponseUtil.output((Exception)((Object)new NoDbManagePermException()));
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    public byte[] loadDBRefInfo(Map<String, String> params) {
        try {
            String id = params.get("id");
            return ResponseUtil.output((IResponseWrap)new ResponseSuccessWrap(this.getDBConnectionDomain().loadDBRefInfo(id)));
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    public byte[] loadDBRefInfoTimes(Map<String, String> params) {
        try {
            String id = params.get("id");
            return ResponseUtil.output((IResponseWrap)new ResponseSuccessWrap((Object)this.getDBConnectionDomain().loadDBRefInfo(id).size()));
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    public byte[] getDatabaseNameList(Map<String, String> params) {
        try {
            if (this.checkDBManagePermImpl(params)) {
                String jsonSource = params.get("source");
                String dbConnectId = params.get("dbConnectId");
                boolean isPwdUpdated = Boolean.parseBoolean(params.get("passwordUpdated"));
                AbstractSource source = SourceFactory.instancefromJson(jsonSource);
                if (!isPwdUpdated) {
                    this.getDBConnectionDomain().getActualPassword(source, dbConnectId);
                }
                DBSource dbSource = AbstractDBSourceJDBCAdapter.createDBSourceBySource(source, this.qingContext);
                IConnectionFactory connFactory = AbstractDBSourceJDBCAdapter.createConnFactoryBySource(source, this.qingContext);
                AbstractDBSourceJDBCAdapter jdbcAdapter = AbstractDBSourceJDBCAdapter.newInstance(dbSource);
                jdbcAdapter.setConnectionFactory(connFactory);
                List<String> result = jdbcAdapter.getDatabaseNameList(source);
                ResponseSuccessWrap wrap = new ResponseSuccessWrap(result);
                return ResponseUtil.output((IResponseWrap)wrap);
            }
            return ResponseUtil.output((Exception)((Object)new NoDbManagePermException()));
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    public byte[] saveOrUpdateDBPermissionInfo(Map<String, String> params) {
        try {
            if (this.checkDBManagePermImpl(params)) {
                String jsonDBConnection = params.get("model");
                boolean bAuthToAll = Boolean.parseBoolean(params.get("authToAll"));
                DBConnection dbConnection = SourceFactory.decodeFromJson(jsonDBConnection, DBConnection.class);
                this.getDBConnectionDomain().saveOrUpdateDBPermissionInfo(dbConnection, bAuthToAll);
                ResponseSuccessWrap wrap = new ResponseSuccessWrap((Object)true);
                return ResponseUtil.output((IResponseWrap)wrap);
            }
            return ResponseUtil.output((Exception)((Object)new NoDbManagePermException()));
        }
        catch (Exception ex) {
            return ResponseUtil.output((Exception)ex);
        }
    }

    public byte[] loadDBPermissionInfo(Map<String, String> params) {
        try {
            if (this.checkDBManagePermImpl(params)) {
                String jsonDBConnection = params.get("model");
                DBConnection dbConnection = SourceFactory.decodeFromJson(jsonDBConnection, DBConnection.class);
                this.getDBConnectionDomain().loadDBPermissionInfo(dbConnection);
                ResponseSuccessWrap wrap = new ResponseSuccessWrap((Object)dbConnection);
                return ResponseUtil.output((IResponseWrap)wrap);
            }
            return ResponseUtil.output((Exception)((Object)new NoDbManagePermException()));
        }
        catch (Exception ex) {
            return ResponseUtil.output((Exception)ex);
        }
    }

    public byte[] checkDBManagePermission(Map<String, String> params) {
        try {
            boolean flag = this.checkDBManagePermImpl(params);
            ResponseSuccessWrap wrap = new ResponseSuccessWrap((Object)flag);
            return ResponseUtil.output((IResponseWrap)wrap);
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    public byte[] checkOpenAPIConnection(Map<String, String> params) throws UnSupportDataSourceException, OpenAPIException {
        return this.openAPIInitialCheck(params);
    }

    protected abstract boolean checkDBManagePermImpl(Map<String, String> var1);

    protected abstract byte[] openAPIInitialCheck(Map<String, String> var1) throws OpenAPIException, UnSupportDataSourceException;
}

