/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.imexport.model.resource;

import com.kingdee.bos.qing.data.exception.ModelParseException;
import com.kingdee.bos.qing.data.model.designtime.AbstractSource;
import com.kingdee.bos.qing.data.model.designtime.SourceType;
import com.kingdee.bos.qing.data.util.SourceFactory;
import com.kingdee.bos.qing.util.LogUtil;
import java.util.List;
import org.jdom2.Content;
import org.jdom2.Element;

public class DBConnInfo {
    private String id;
    private String name;
    private AbstractSource dbSource;
    private SourceType dbSourceType;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public AbstractSource getDbSource() {
        return this.dbSource;
    }

    public void setDbSource(AbstractSource dbSource) {
        this.dbSource = dbSource;
    }

    public SourceType getDbSourceType() {
        return this.dbSourceType;
    }

    public void setDbSourceType(SourceType dbSourceType) {
        this.dbSourceType = dbSourceType;
    }

    public Element toXml() {
        Element xml = new Element("DBConnInfo");
        xml.setAttribute("id", this.id);
        if (this.name != null) {
            xml.setAttribute("name", this.name);
        }
        xml.setAttribute("dbSourceType", this.dbSourceType.toPersistance());
        if (this.dbSource != null) {
            Element contentElement = new Element("DBSource");
            contentElement.addContent((Content)this.dbSource.toXml());
            xml.addContent((Content)contentElement);
        }
        return xml;
    }

    public void fromXml(Element xml, String version) {
        this.id = xml.getAttributeValue("id");
        this.name = xml.getAttributeValue("name");
        this.dbSourceType = SourceType.fromPersistanceSilence(xml.getAttributeValue("dbSourceType"));
        Element dbSourceElement = xml.getChild("DBSource");
        if (dbSourceElement != null) {
            try {
                List childrenElement = dbSourceElement.getChildren();
                if (childrenElement != null && childrenElement.size() > 0) {
                    Element sourceElement = (Element)childrenElement.get(0);
                    this.dbSource = SourceFactory.instanceFromXml(sourceElement);
                    this.dbSource.fromXml(sourceElement);
                }
            }
            catch (ModelParseException e) {
                LogUtil.error((String)"Import macro dbSource failed, unknown source type.");
            }
        }
    }
}

