/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.macro.dao;

import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ResultHandler;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.dbmanage.model.DBConnectionPO;
import com.kingdee.bos.qing.macro.model.MacroType;
import com.kingdee.bos.qing.macro.model.po.SQLMacroPO;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;

public class SQLMacroManageDao {
    private IDBExcuter dbExcuter;

    public SQLMacroManageDao(IDBExcuter dbExcuter) {
        this.dbExcuter = dbExcuter;
    }

    public String saveSQLMacro(SQLMacroPO sqlMacro) throws AbstractQingIntegratedException, SQLException {
        String sql = "INSERT INTO T_QING_SQL_MACRO (FID, FMACROID, FSQLTYPE, FSQL) VALUES (?,?,?,?)";
        Object[] params = new Object[4];
        String fId = UUID.randomUUID().toString();
        int i = 0;
        params[i++] = fId;
        params[i++] = sqlMacro.getFid();
        params[i++] = sqlMacro.getSQLType();
        params[i++] = this.dbExcuter.createSqlParameterBytes(sqlMacro.getContent(), 0, sqlMacro.getContent().length);
        this.dbExcuter.execute(sql, params);
        return fId;
    }

    public void updateSQLMacro(SQLMacroPO sqlMacro) throws AbstractQingIntegratedException, SQLException {
        String sql = "UPDATE T_QING_SQL_MACRO SET FSQLTYPE=?, FSQL=? WHERE FMACROID=?";
        Object[] params = new Object[3];
        int i = 0;
        params[i++] = sqlMacro.getSQLType();
        params[i++] = this.dbExcuter.createSqlParameterBytes(sqlMacro.getContent(), 0, sqlMacro.getContent().length);
        params[i++] = sqlMacro.getFid();
        this.dbExcuter.execute(sql, params);
    }

    public void deleteSQLMacro(String fId) throws AbstractQingIntegratedException, SQLException {
        this.dbExcuter.execute("DELETE FROM T_QING_SQL_MACRO WHERE FID=?", new Object[]{fId});
    }

    public void deleteSQLMacroByMacroId(String macroId) throws AbstractQingIntegratedException, SQLException {
        this.dbExcuter.execute("DELETE FROM T_QING_SQL_MACRO WHERE FMACROID=?", new Object[]{macroId});
    }

    public void deleteSQLMacrosByMacroIds(List<String> macroIds) throws AbstractQingIntegratedException, SQLException {
        ArrayList<Object[]> params = new ArrayList<Object[]>(macroIds.size());
        for (String macroId : macroIds) {
            params.add(new Object[]{macroId});
        }
        this.dbExcuter.executeBatch("DELETE FROM T_QING_SQL_MACRO WHERE FMACROID=?", params);
    }

    private String appendConditionWhenSearchTextNoNull(String sql, String searchText, Object[] objects) {
        if (searchText != null && searchText.length() > 0) {
            sql = sql + " WHERE UPPER(M.FUID) like ? OR UPPER(M.FNAME) like ? OR UPPER(M.FDESC) like ?";
            searchText = "%%" + searchText.toUpperCase() + "%%";
            Arrays.fill(objects, searchText);
        }
        return sql;
    }

    public List<String> getMacroIds(String searchText) throws AbstractQingIntegratedException, SQLException {
        String sql = "SELECT M.FID FROM ((T_QING_MACRO M LEFT JOIN T_QING_SQL_MACRO S ON M.FID = S.FMACROID) LEFT JOIN T_QING_DBINFO_REF DR ON M.FID = DR.FFROMID) LEFT JOIN T_QING_DBINFO D ON DR.FTOID = D.FID ";
        Object[] objects = new Object[3];
        sql = this.appendConditionWhenSearchTextNoNull(sql, searchText, objects);
        return (List)this.dbExcuter.query(sql, objects[0] == null ? new Object[]{} : objects, (ResultHandler)new ResultHandler<List<String>>(){

            public List<String> handle(ResultSet rs) throws SQLException {
                ArrayList<String> macroIds = new ArrayList<String>(10);
                while (rs.next()) {
                    macroIds.add(rs.getString("FID"));
                }
                return macroIds;
            }
        });
    }

    public Integer getRefTimeOfDeleteMacroIds(List<String> macroIds) throws AbstractQingIntegratedException, SQLException {
        int size = macroIds.size();
        StringBuilder sb = new StringBuilder();
        Object[] params = new Object[size];
        sb.append("SELECT SUM(FREFTIME) macro_sum FROM T_QING_MACRO_REF WHERE FTOID IN ");
        sb.append('(');
        for (int i = 0; i < size; ++i) {
            params[i] = macroIds.get(i);
            sb.append('?');
            if (i >= size - 1) continue;
            sb.append(',');
        }
        sb.append(')');
        return (Integer)this.dbExcuter.query(sb.toString(), params, (ResultHandler)new ResultHandler<Integer>(){

            public Integer handle(ResultSet rs) throws SQLException {
                if (rs.next()) {
                    return rs.getInt("macro_sum");
                }
                return 0;
            }
        });
    }

    public Integer getMacrosCount(String searchText) throws AbstractQingIntegratedException, SQLException {
        String sql = "SELECT COUNT(*) macro_count FROM ((T_QING_MACRO M LEFT JOIN T_QING_SQL_MACRO S ON M.FID = S.FMACROID) LEFT JOIN T_QING_DBINFO_REF DR ON M.FID = DR.FFROMID) LEFT JOIN T_QING_DBINFO D ON DR.FTOID = D.FID ";
        Object[] objects = new Object[3];
        sql = this.appendConditionWhenSearchTextNoNull(sql, searchText, objects);
        return (Integer)this.dbExcuter.query(sql, objects[0] == null ? new Object[]{} : objects, (ResultHandler)new ResultHandler<Integer>(){

            public Integer handle(ResultSet rs) throws SQLException {
                if (rs.next()) {
                    return rs.getInt("macro_count");
                }
                return 0;
            }
        });
    }

    public SQLMacroPO loadSQLMacroByUid(String uid) throws AbstractQingIntegratedException, SQLException {
        String sql = "SELECT M.FUID, M.FMODIFIERID, D.FID as FDBINFOFID, D.FCONTENT, D.FDBSOURCETYPE, D.FNAME AS FDBNAME FROM (T_QING_MACRO M LEFT JOIN T_QING_DBINFO_REF DR ON M.FID = DR.FFROMID) LEFT JOIN T_QING_DBINFO D ON DR.FTOID = D.FID WHERE M.FUID = ?";
        Object[] objects = new Object[]{uid};
        return (SQLMacroPO)this.dbExcuter.query(sql, objects, (ResultHandler)new ResultHandler<SQLMacroPO>(){

            public SQLMacroPO handle(ResultSet rs) throws SQLException {
                if (rs.next()) {
                    SQLMacroPO macro = new SQLMacroPO();
                    macro.setUid(rs.getString("FUID"));
                    macro.setModifierId(rs.getString("FMODIFIERID"));
                    String dbInfoFid = rs.getString("FDBINFOFID");
                    if (dbInfoFid != null) {
                        DBConnectionPO dbInfo = new DBConnectionPO();
                        dbInfo.setId(rs.getString("FDBINFOFID"));
                        dbInfo.setName(rs.getString("FDBNAME"));
                        dbInfo.setDbSourceType(rs.getInt("FDBSOURCETYPE"));
                        dbInfo.setContent(rs.getBytes("FCONTENT"));
                        macro.setDBInfo(dbInfo);
                    }
                    return macro;
                }
                return null;
            }
        });
    }

    public List<SQLMacroPO> loadSQLMacros(Integer offset, Integer pageSize, String searchText) throws AbstractQingIntegratedException, SQLException {
        String sql = "SELECT TOP %s,%s M.FID, M.FUID, M.FNAME, M.FDESC, M.FTYPE, M.FMULTIVALUED, M.FCREATORID, M.FCREATETIME, M.FMODIFIERID, M.FMODIFYTIME, S.FSQLTYPE, S.FSQL, D.FID as FDBINFOFID, D.FCONTENT, D.FDBSOURCETYPE, D.FNAME AS FDBNAME FROM ((T_QING_MACRO M LEFT JOIN T_QING_SQL_MACRO S ON M.FID = S.FMACROID) LEFT JOIN T_QING_DBINFO_REF DR ON M.FID = DR.FFROMID) LEFT JOIN T_QING_DBINFO D ON DR.FTOID = D.FID ";
        String sqlOffset = String.format(sql, pageSize, offset);
        Object[] objects = new Object[3];
        sqlOffset = this.appendConditionWhenSearchTextNoNull(sqlOffset, searchText, objects);
        sqlOffset = sqlOffset + " ORDER BY M.FCREATETIME desc";
        return (List)this.dbExcuter.query(sqlOffset, objects[0] == null ? new Object[]{} : objects, (ResultHandler)new ResultHandler<List<SQLMacroPO>>(){

            public List<SQLMacroPO> handle(ResultSet rs) throws SQLException {
                ArrayList<SQLMacroPO> macros = new ArrayList<SQLMacroPO>(10);
                while (rs.next()) {
                    SQLMacroPO macro = new SQLMacroPO();
                    macro.setFid(rs.getString("FID"));
                    macro.setUid(rs.getString("FUID"));
                    macro.setName(rs.getString("FNAME"));
                    macro.setDesc(rs.getString("FDESC"));
                    macro.setType(MacroType.fromPersistent(rs.getInt("FTYPE")));
                    macro.setMultiValued(rs.getString("FMULTIVALUED").equals("1"));
                    macro.setCreatorId(rs.getString("FCREATORID"));
                    macro.setCreateTime(rs.getTimestamp("FCREATETIME"));
                    macro.setModifierId(rs.getString("FMODIFIERID"));
                    macro.setModifyTime(rs.getTimestamp("FMODIFYTIME"));
                    String dbInfoFid = rs.getString("FDBINFOFID");
                    if (dbInfoFid != null) {
                        DBConnectionPO dbInfo = new DBConnectionPO();
                        dbInfo.setId(rs.getString("FDBINFOFID"));
                        dbInfo.setName(rs.getString("FDBNAME"));
                        dbInfo.setDbSourceType(rs.getInt("FDBSOURCETYPE"));
                        dbInfo.setContent(rs.getBytes("FCONTENT"));
                        macro.setDBInfo(dbInfo);
                    }
                    macro.setSQLType(rs.getInt("FSQLTYPE"));
                    macro.setContent(rs.getBytes("FSQL"));
                    macros.add(macro);
                }
                return macros;
            }
        });
    }

    public List<SQLMacroPO> loadAllSQLMacros() throws AbstractQingIntegratedException, SQLException {
        String sql = "SELECT M.FID, M.FUID, M.FNAME, M.FDESC, M.FTYPE, M.FMULTIVALUED, M.FCREATORID, M.FCREATETIME, M.FMODIFIERID, M.FMODIFYTIME, S.FSQLTYPE, S.FSQL, D.FID as FDBINFOFID, D.FCONTENT, D.FDBSOURCETYPE, D.FNAME AS FDBNAME FROM ((T_QING_MACRO M LEFT JOIN T_QING_SQL_MACRO S ON M.FID = S.FMACROID) LEFT JOIN T_QING_DBINFO_REF DR ON M.FID = DR.FFROMID) LEFT JOIN T_QING_DBINFO D ON DR.FTOID = D.FID ORDER BY M.FCREATETIME desc";
        return (List)this.dbExcuter.query(sql, new Object[0], (ResultHandler)new ResultHandler<List<SQLMacroPO>>(){

            public List<SQLMacroPO> handle(ResultSet rs) throws SQLException {
                ArrayList<SQLMacroPO> macros = new ArrayList<SQLMacroPO>(10);
                while (rs.next()) {
                    SQLMacroPO macro = new SQLMacroPO();
                    macro.setFid(rs.getString("FID"));
                    macro.setUid(rs.getString("FUID"));
                    macro.setName(rs.getString("FNAME"));
                    macro.setDesc(rs.getString("FDESC"));
                    macro.setType(MacroType.fromPersistent(rs.getInt("FTYPE")));
                    macro.setMultiValued(rs.getString("FMULTIVALUED").equals("1"));
                    macro.setCreatorId(rs.getString("FCREATORID"));
                    macro.setCreateTime(rs.getTimestamp("FCREATETIME"));
                    macro.setModifierId(rs.getString("FMODIFIERID"));
                    macro.setModifyTime(rs.getTimestamp("FMODIFYTIME"));
                    String dbInfoFid = rs.getString("FDBINFOFID");
                    if (dbInfoFid != null) {
                        DBConnectionPO dbInfo = new DBConnectionPO();
                        dbInfo.setId(rs.getString("FDBINFOFID"));
                        dbInfo.setName(rs.getString("FDBNAME"));
                        dbInfo.setDbSourceType(rs.getInt("FDBSOURCETYPE"));
                        dbInfo.setContent(rs.getBytes("FCONTENT"));
                        macro.setDBInfo(dbInfo);
                    }
                    macro.setSQLType(rs.getInt("FSQLTYPE"));
                    macro.setContent(rs.getBytes("FSQL"));
                    macros.add(macro);
                }
                return macros;
            }
        });
    }

    public SQLMacroPO loadMacro(String macroId) throws AbstractQingIntegratedException, SQLException {
        String sql = "SELECT M.FID, M.FUID, M.FNAME, M.FDESC, M.FTYPE, M.FMULTIVALUED, M.FCREATORID, M.FMODIFIERID, S.FSQLTYPE, S.FSQL, D.FID as FDBINFOFID, D.FCONTENT, D.FDBSOURCETYPE, D.FNAME AS FDBNAME FROM ((T_QING_MACRO M LEFT JOIN T_QING_SQL_MACRO S ON M.FID = S.FMACROID) LEFT JOIN T_QING_DBINFO_REF DR ON M.FID = DR.FFROMID) LEFT JOIN T_QING_DBINFO D ON DR.FTOID = D.FID WHERE M.FID=?";
        return (SQLMacroPO)this.dbExcuter.query(sql, new Object[]{macroId}, (ResultHandler)new ResultHandler<SQLMacroPO>(){

            public SQLMacroPO handle(ResultSet rs) throws SQLException {
                SQLMacroPO macro = null;
                if (rs.next()) {
                    macro = new SQLMacroPO();
                    macro.setFid(rs.getString("FID"));
                    macro.setUid(rs.getString("FUID"));
                    macro.setName(rs.getString("FNAME"));
                    macro.setDesc(rs.getString("FDESC"));
                    macro.setType(MacroType.fromPersistent(rs.getInt("FTYPE")));
                    macro.setMultiValued(rs.getString("FMULTIVALUED").equals("1"));
                    macro.setCreatorId(rs.getString("FCREATORID"));
                    macro.setModifierId(rs.getString("FMODIFIERID"));
                    String dbInfoFid = rs.getString("FDBINFOFID");
                    if (dbInfoFid != null) {
                        DBConnectionPO dbInfo = new DBConnectionPO();
                        dbInfo.setId(rs.getString("FDBINFOFID"));
                        dbInfo.setName(rs.getString("FDBNAME"));
                        dbInfo.setDbSourceType(rs.getInt("FDBSOURCETYPE"));
                        dbInfo.setContent(rs.getBytes("FCONTENT"));
                        macro.setDBInfo(dbInfo);
                    }
                    macro.setSQLType(rs.getInt("FSQLTYPE"));
                    macro.setContent(rs.getBytes("FSQL"));
                }
                return macro;
            }
        });
    }
}

