/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.macro.domain;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ITransactionManagement;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.common.strategy.CustomStrategyRegistrar;
import com.kingdee.bos.qing.dbmanage.domain.DBConnectionDomain;
import com.kingdee.bos.qing.dbmanage.exception.DBManageException;
import com.kingdee.bos.qing.dbmanage.model.DBConnection;
import com.kingdee.bos.qing.macro.dao.MacroManageDao;
import com.kingdee.bos.qing.macro.domain.MacroCommonDomain;
import com.kingdee.bos.qing.macro.exception.MacroDBConnectionNoExistException;
import com.kingdee.bos.qing.macro.exception.MacroDuplicateNameException;
import com.kingdee.bos.qing.macro.exception.MacroDuplicateUidException;
import com.kingdee.bos.qing.macro.exception.MacroNoAuthorityException;
import com.kingdee.bos.qing.macro.exception.MacroNotFoundException;
import com.kingdee.bos.qing.macro.exception.QingMacroException;
import com.kingdee.bos.qing.macro.model.po.MacroReference;
import com.kingdee.bos.qing.macro.model.vo.Macro;
import com.kingdee.bos.qing.macro.model.vo.MacroValue;
import com.kingdee.bos.qing.macro.model.vo.MacrosPaginationVo;
import com.kingdee.bos.qing.macro.model.vo.PreviewData;
import com.kingdee.bos.qing.macro.model.vo.Reference;
import com.kingdee.bos.qing.macro.model.vo.SQLMacro;
import com.kingdee.bos.qing.macro.oplog.MacroOpLog;
import com.kingdee.bos.qing.macro.strategy.IMacroCheckPermission;
import com.kingdee.bos.qing.oplog.IOpLogConstant;
import com.kingdee.bos.qing.oplog.model.OpLogActionType;
import com.kingdee.bos.qing.oplog.model.OpLogBO;
import com.kingdee.bos.qing.util.IntegratedHelper;
import com.kingdee.bos.qing.util.MacroCheckPermissionUtil;
import com.kingdee.bos.qing.util.OpLogUtil;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractMacroDomain {
    protected IDBExcuter dbExcuter;
    protected ITransactionManagement tx;
    protected QingContext qingContext;
    private MacroCommonDomain commonDomain;
    private DBConnectionDomain dbConnectionDomain;
    private MacroManageDao macroManageDao;
    private IMacroCheckPermission macroCheckPermission;

    protected DBConnectionDomain getDBConnectionDomain() {
        if (this.dbConnectionDomain == null) {
            this.dbConnectionDomain = new DBConnectionDomain(this.dbExcuter, this.tx, this.qingContext);
        }
        return this.dbConnectionDomain;
    }

    protected IMacroCheckPermission getMacroCheckPermission() {
        if (this.macroCheckPermission == null) {
            this.macroCheckPermission = (IMacroCheckPermission)CustomStrategyRegistrar.getStrategy(IMacroCheckPermission.class);
        }
        return this.macroCheckPermission;
    }

    public AbstractMacroDomain(IDBExcuter dbExcuter, ITransactionManagement tx, QingContext qingContext) {
        this.dbExcuter = dbExcuter;
        this.tx = tx;
        this.qingContext = qingContext;
    }

    private MacroManageDao getMacroManageDao() {
        if (this.macroManageDao == null) {
            this.macroManageDao = new MacroManageDao(this.dbExcuter);
        }
        return this.macroManageDao;
    }

    private MacroCommonDomain getCommonDomain() {
        if (this.commonDomain == null) {
            this.commonDomain = new MacroCommonDomain(this.dbExcuter, this.qingContext);
        }
        return this.commonDomain;
    }

    public Macro saveMacroWithoutTx(Macro macro, boolean checkExecutable) throws QingMacroException, AbstractQingIntegratedException, SQLException {
        DBConnection dbConnect;
        DBConnection dbConnect2;
        if (!this.getCommonDomain().hasManageAuthority()) {
            return null;
        }
        String userId = this.qingContext.getUserId();
        Macro macroAlreadyExist = this.getMacroManageDao().loadMacroByUid(macro.getUid());
        if (macroAlreadyExist != null) {
            throw new MacroDuplicateUidException();
        }
        macroAlreadyExist = this.getMacroManageDao().loadMacroByName(macro.getName());
        if (macroAlreadyExist != null) {
            throw new MacroDuplicateNameException();
        }
        if (macro instanceof SQLMacro && (dbConnect2 = ((SQLMacro)macro).getDBInfo()) != null) {
            try {
                this.getDBConnectionDomain().getActualPassword(dbConnect2.getDbSource(), dbConnect2.getId());
            }
            catch (AbstractQingIntegratedException e) {
                throw e;
            }
            catch (SQLException e) {
                throw e;
            }
            catch (Exception e) {
                throw new QingMacroException(e);
            }
        }
        String macroId = this.getMacroManageDao().saveMacro(userId, macro);
        this.getMacroManageDao().updateRefToIdByToPath(macro.getUid(), macroId);
        macro.setReference(this.loadMacroReference(macroId));
        String userName = IntegratedHelper.getUserName(this.qingContext, this.dbExcuter, userId);
        macro.setCreatorName(userName);
        macro.setModifierName(userName);
        long currentTime = System.currentTimeMillis();
        macro.setCreateTime(currentTime);
        macro.setModifyTime(currentTime);
        macro.setFid(macroId);
        this.saveWithoutTx(macro, checkExecutable);
        if (macro instanceof SQLMacro && (dbConnect = ((SQLMacro)macro).getDBInfo()) != null) {
            this.getDBConnectionDomain().replacePasswordWithUUID(dbConnect.getDbSource());
        }
        return macro;
    }

    private void checkDBPermission(DBConnection dbConnect) throws AbstractQingIntegratedException, SQLException, MacroDBConnectionNoExistException, MacroNoAuthorityException {
        if (dbConnect.isDBSource()) {
            List<String> dbConnIds = this.getDBConnectionDomain().loadAllDBConnIdsWithoutDBCenter();
            if (!dbConnIds.contains(dbConnect.getId())) {
                throw new MacroDBConnectionNoExistException();
            }
            if (dbConnect.isDBSource() && !this.getDBConnectionDomain().isDBConnHasPermission(this.qingContext.getUserId(), dbConnect.getId()).booleanValue()) {
                throw new MacroNoAuthorityException();
            }
        } else if (dbConnect.isDBCenterSource() && MacroCheckPermissionUtil.macroCheckDBCenterSourceNoPermission(this.getMacroCheckPermission(), dbConnect, this.qingContext.getUserId())) {
            throw new MacroNoAuthorityException();
        }
    }

    public Macro saveMacro(Macro macro, boolean checkExecutable) throws QingMacroException {
        try {
            DBConnection dbConnection;
            this.tx.beginRequired();
            if (macro instanceof SQLMacro && (dbConnection = ((SQLMacro)macro).getDBInfo()) != null) {
                this.checkDBPermission(dbConnection);
            }
            this.saveMacroWithoutTx(macro, checkExecutable);
        }
        catch (QingMacroException e) {
            this.tx.markRollback();
            throw e;
        }
        catch (Exception e) {
            this.tx.markRollback();
            throw new QingMacroException(e);
        }
        finally {
            this.tx.end();
        }
        ArrayList<String> params = new ArrayList<String>(1);
        params.add(macro.getName());
        MacroOpLog emptyDir = MacroOpLog.EMPTY_DIR;
        emptyDir.setLogScene("\u5b8f\u5b9a\u4e49");
        OpLogUtil.addLog((OpLogBO)new OpLogBO(OpLogActionType.NEW, (IOpLogConstant)emptyDir, params));
        return macro;
    }

    public boolean isMacroNameExist(String name) throws AbstractQingIntegratedException, SQLException {
        Macro macro = this.getMacroManageDao().loadMacroByName(name);
        return macro != null;
    }

    public Macro updateMacro(Macro macro) throws AbstractQingIntegratedException, SQLException, QingMacroException {
        String fId = macro.getFid();
        String userId = this.qingContext.getUserId();
        Macro oldMacro = this.getMacroManageDao().loadMacro(fId);
        if (oldMacro == null) {
            throw new MacroNotFoundException();
        }
        Macro macroAlreadyExist = this.getMacroManageDao().loadMacroByUid(macro.getUid());
        if (macroAlreadyExist != null && !macroAlreadyExist.getFid().equals(fId)) {
            throw new MacroDuplicateUidException();
        }
        macroAlreadyExist = this.getMacroManageDao().loadMacroByName(macro.getName());
        if (macroAlreadyExist != null && !macroAlreadyExist.getFid().equals(fId)) {
            throw new MacroDuplicateNameException();
        }
        try {
            DBConnection dbConnect;
            if (macro instanceof SQLMacro) {
                dbConnect = ((SQLMacro)macro).getDBInfo();
                this.checkDBPermission(dbConnect);
                if (dbConnect != null) {
                    this.getDBConnectionDomain().getActualPassword(dbConnect.getDbSource(), dbConnect.getId());
                }
            }
            this.tx.beginRequired();
            this.getMacroManageDao().updateMacro(macro, userId);
            macro.setModifierName(IntegratedHelper.getUserName(this.qingContext, this.dbExcuter, userId));
            macro.setModifyTime(System.currentTimeMillis());
            macro.setReference(this.loadMacroReference(fId));
            this.updateWithoutTx(macro, oldMacro);
            if (macro instanceof SQLMacro && (dbConnect = ((SQLMacro)macro).getDBInfo()) != null) {
                this.getDBConnectionDomain().replacePasswordWithUUID(dbConnect.getDbSource());
            }
        }
        catch (MacroDBConnectionNoExistException e) {
            this.tx.markRollback();
            throw e;
        }
        catch (MacroNoAuthorityException e) {
            this.tx.markRollback();
            throw e;
        }
        catch (QingMacroException e) {
            this.tx.markRollback();
            throw e;
        }
        catch (Exception e) {
            this.tx.markRollback();
            throw new QingMacroException(e);
        }
        finally {
            this.tx.end();
        }
        ArrayList<String> params = new ArrayList<String>(2);
        MacroOpLog emptyDir = MacroOpLog.EMPTY_DIR;
        emptyDir.setLogScene("\u5b8f\u5b9a\u4e49");
        if (!oldMacro.getName().equals(macro.getName())) {
            emptyDir.setParamsDesc("\u201c$param\u201d\u540d\u79f0\u4e3a\u201c$param\u201d");
            params.add(oldMacro.getName());
        }
        params.add(macro.getName());
        OpLogUtil.addLog((OpLogBO)new OpLogBO(OpLogActionType.EDIT, (IOpLogConstant)emptyDir, params));
        return macro;
    }

    public void deleteMacros(List<String> fIds) throws AbstractQingIntegratedException, QingMacroException, SQLException {
        if (!this.getCommonDomain().hasManageAuthority()) {
            return;
        }
        try {
            this.tx.beginRequired();
            this.deleteWithoutTx(fIds);
            this.getMacroManageDao().deleteMacro(fIds);
        }
        catch (Exception e) {
            this.tx.markRollback();
            throw new QingMacroException(e);
        }
        finally {
            this.tx.end();
        }
    }

    public void deleteMacro(String fId) throws AbstractQingIntegratedException, QingMacroException {
        try {
            this.tx.beginRequired();
            this.deleteWithoutTx(fId);
            this.getMacroManageDao().deleteMacro(fId);
        }
        catch (Exception e) {
            this.tx.markRollback();
            throw new QingMacroException(e);
        }
        finally {
            this.tx.end();
        }
    }

    public void deleteMacroByUidWithoutTx(String uid) throws AbstractQingIntegratedException, SQLException, QingMacroException {
        if (!this.getCommonDomain().hasManageAuthority()) {
            return;
        }
        Macro macro = this.getMacroManageDao().loadMacroByUid(uid);
        if (macro == null) {
            return;
        }
        this.deleteWithoutTx(macro.getFid());
        this.getMacroManageDao().deleteMacroByUid(uid);
    }

    protected Reference loadMacroReference(String macroId) throws AbstractQingIntegratedException, SQLException {
        List<MacroReference> macroRefs = this.getMacroManageDao().loadMacroReferenceByRefToId(macroId);
        Reference ref = new Reference();
        int totalRefTime = 0;
        for (MacroReference macroRef : macroRefs) {
            int refTime = macroRef.getRefTime();
            totalRefTime += refTime;
        }
        ref.setRefTimeInTotal(totalRefTime);
        return ref;
    }

    public List<String> getMacroFieldsByUid(String macroUid) throws AbstractQingIntegratedException, SQLException, QingMacroException, DBManageException {
        Macro macro = this.getMacroManageDao().loadMacroByUid(macroUid);
        if (macro == null) {
            return new ArrayList<String>(1);
        }
        PreviewData previewData = this.getPreviewDataByID(macro.getFid());
        if (previewData == null) {
            return new ArrayList<String>(1);
        }
        return previewData.getFields();
    }

    public MacroValue loadMacroValuesByUid(String macroUid) throws AbstractQingIntegratedException, SQLException, QingMacroException {
        Macro macro = this.getMacroManageDao().loadMacroByUid(macroUid);
        if (macro == null) {
            return new MacroValue();
        }
        return this.getMacroExecuteResult(macro.getFid());
    }

    public Macro loadMacroByUid(String macroUid) throws AbstractQingIntegratedException, SQLException, QingMacroException {
        Macro macro = this.getMacroManageDao().loadMacroByUid(macroUid);
        if (macro == null) {
            return null;
        }
        return this.getMacroManageDao().loadMacro(macro.getFid());
    }

    public abstract Macro loadMacro(String var1) throws AbstractQingIntegratedException, QingMacroException;

    public abstract boolean checkMacroPermissionByUid(String var1) throws QingMacroException;

    public abstract MacrosPaginationVo loadMacros(Integer var1, Integer var2, String var3) throws AbstractQingIntegratedException, QingMacroException;

    public abstract List<String> loadMacroIds(String var1) throws AbstractQingIntegratedException, QingMacroException;

    public abstract Integer getRefTimeOfDeleteMacros(List<String> var1) throws AbstractQingIntegratedException, QingMacroException;

    public abstract List<? extends Macro> loadAllMacros() throws AbstractQingIntegratedException, QingMacroException;

    protected abstract void saveWithoutTx(Macro var1, boolean var2) throws AbstractQingIntegratedException, SQLException, QingMacroException;

    protected abstract void updateWithoutTx(Macro var1, Macro var2) throws AbstractQingIntegratedException, SQLException, QingMacroException;

    protected abstract void deleteWithoutTx(String var1) throws AbstractQingIntegratedException, SQLException, QingMacroException;

    protected abstract void deleteWithoutTx(List<String> var1) throws AbstractQingIntegratedException, SQLException, QingMacroException;

    public abstract MacroValue getMacroExecuteResult(String var1) throws QingMacroException;

    public abstract PreviewData getPreviewData(Macro var1) throws QingMacroException, DBManageException, SQLException, AbstractQingIntegratedException;

    public abstract PreviewData getPreviewDataByID(String var1) throws QingMacroException, AbstractQingIntegratedException, SQLException, DBManageException;
}

