/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.macro.domain;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.common.exception.IntegratedRuntimeException;
import com.kingdee.bos.qing.common.strategy.CustomStrategyRegistrar;
import com.kingdee.bos.qing.dbmanage.domain.DBConnectionDomain;
import com.kingdee.bos.qing.dbmanage.model.DBConnection;
import com.kingdee.bos.qing.macro.dao.MacroManageDao;
import com.kingdee.bos.qing.macro.exception.MacroNotFoundException;
import com.kingdee.bos.qing.macro.model.MacroType;
import com.kingdee.bos.qing.macro.model.po.MacroPO;
import com.kingdee.bos.qing.macro.model.po.MacroReference;
import com.kingdee.bos.qing.macro.model.po.SQLMacroPO;
import com.kingdee.bos.qing.macro.model.vo.Macro;
import com.kingdee.bos.qing.macro.strategy.IMacroCheckPermission;
import com.kingdee.bos.qing.util.IntegratedHelper;
import com.kingdee.bos.qing.util.MacroCheckPermissionUtil;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MacroCommonDomain {
    private IDBExcuter dbExcuter;
    private QingContext qingContext;
    private MacroManageDao macroManageDao;
    private DBConnectionDomain dbConnectionDomain;

    protected DBConnectionDomain getDBConnectionDomain() {
        if (this.dbConnectionDomain == null) {
            this.dbConnectionDomain = new DBConnectionDomain(this.dbExcuter, null, this.qingContext);
        }
        return this.dbConnectionDomain;
    }

    private MacroManageDao getManageDao() {
        if (this.macroManageDao == null) {
            this.macroManageDao = new MacroManageDao(this.dbExcuter);
        }
        return this.macroManageDao;
    }

    public MacroCommonDomain(IDBExcuter dbExcuter, QingContext qingContext) {
        this.dbExcuter = dbExcuter;
        this.qingContext = qingContext;
    }

    public MacroType getMacroType(String macroId) throws AbstractQingIntegratedException, SQLException, MacroNotFoundException {
        Macro macro = this.getManageDao().loadMacro(macroId);
        if (macro == null) {
            throw new MacroNotFoundException();
        }
        return macro.getType();
    }

    public MacroType getMacroTypeByUid(String macroUid) throws AbstractQingIntegratedException, SQLException, MacroNotFoundException {
        Macro macro = this.getManageDao().loadMacroByUid(macroUid);
        if (macro == null) {
            throw new MacroNotFoundException();
        }
        return macro.getType();
    }

    public Macro loadCommonMacro(String macroId) throws AbstractQingIntegratedException, SQLException {
        return this.getManageDao().loadMacro(macroId);
    }

    public Macro loadCommonMacroByUid(String macroUid) throws AbstractQingIntegratedException, SQLException {
        return this.getManageDao().loadMacroByUid(macroUid);
    }

    public Macro loadCommonMacroByUidInBox(String uidInDM) throws AbstractQingIntegratedException, SQLException, MacroNotFoundException {
        String macroUid = uidInDM;
        Macro macro = this.loadCommonMacroByUid(macroUid);
        if (macro == null) {
            throw new MacroNotFoundException();
        }
        return macro;
    }

    public List<Macro> loadMacroInfoForUserSQL(List<String> uidsInDM) throws AbstractQingIntegratedException, SQLException {
        HashSet<String> uids = new HashSet<String>(uidsInDM);
        ArrayList<SQLMacroPO> macroPOs = new ArrayList<SQLMacroPO>(10);
        if (uids.size() > 0) {
            macroPOs.addAll(this.getManageDao().loadMacrosByMultiUid(uids));
        }
        ArrayList<Macro> macros = new ArrayList<Macro>(10);
        for (MacroPO macroPO : macroPOs) {
            Macro macro = macroPO.toMacro(this.qingContext);
            String userName = IntegratedHelper.getUserName(this.qingContext, this.dbExcuter, macro.getCreatorId());
            macro.setCreatorName(userName);
            macros.add(macro);
        }
        return macros;
    }

    public List<Macro> loadMacroInfoForUserSQLByDisplayName(List<String> displayNames) throws AbstractQingIntegratedException, SQLException {
        HashSet<String> names = new HashSet<String>(displayNames);
        ArrayList<MacroPO> macroPOs = new ArrayList<MacroPO>(10);
        macroPOs.addAll(this.getManageDao().loadMacrosByMultiName(names));
        ArrayList<Macro> macros = new ArrayList<Macro>(10);
        for (MacroPO macroPO : macroPOs) {
            Macro macro = macroPO.toMacro(this.qingContext);
            String userName = IntegratedHelper.getUserName(this.qingContext, this.dbExcuter, macro.getCreatorId());
            macro.setCreatorName(userName);
            macros.add(macro);
        }
        return macros;
    }

    public boolean checkMacroAvailable(Map<String, Boolean> dbCenterSourcePermissionCache, Map<String, Boolean> dbSourcePermissionCache, DBConnection targetDBConnInfo, String modifierId) throws AbstractQingIntegratedException, SQLException {
        IMacroCheckPermission macroCheckPermission = (IMacroCheckPermission)CustomStrategyRegistrar.getStrategy(IMacroCheckPermission.class);
        if (targetDBConnInfo != null) {
            if (targetDBConnInfo.isDBSource()) {
                String cacheKey = modifierId + targetDBConnInfo.getId();
                Boolean isDBConnHasPermission = dbSourcePermissionCache.get(cacheKey);
                if (isDBConnHasPermission == null) {
                    isDBConnHasPermission = this.getDBConnectionDomain().isDBConnHasPermission(modifierId, targetDBConnInfo.getId());
                    dbSourcePermissionCache.put(cacheKey, isDBConnHasPermission);
                }
                if (!isDBConnHasPermission.booleanValue()) {
                    return false;
                }
            }
            Boolean isPermission = dbCenterSourcePermissionCache.get(modifierId);
            if (targetDBConnInfo.isDBCenterSource() && isPermission == null) {
                isPermission = MacroCheckPermissionUtil.checkDBCenterSourcePermission(macroCheckPermission, modifierId);
                dbCenterSourcePermissionCache.put(modifierId, isPermission);
            }
            return !targetDBConnInfo.isDBCenterSource() || isPermission != false;
        }
        return false;
    }

    public void saveDataModelingRef(String refFromId, List<String> macroUids) throws AbstractQingIntegratedException, SQLException {
        this.deleteReferenceByFromId(refFromId);
        this.saveReference(macroUids, refFromId);
    }

    public void deleteReference(String refFromId) throws AbstractQingIntegratedException, SQLException {
        this.deleteReferenceByFromId(refFromId);
    }

    public List<SQLMacroPO> getDataModelDesignTimeMacro(List<String> macroUids) throws AbstractQingIntegratedException, SQLException {
        return this.getManageDao().loadMacrosByMultiUid(new HashSet<String>(macroUids));
    }

    public boolean hasManageAuthority() throws IntegratedRuntimeException {
        return IntegratedHelper.checkMacroPermission(this.qingContext);
    }

    private void deleteReferenceByFromId(String fromId) throws AbstractQingIntegratedException, SQLException {
        this.getManageDao().deleteReferenceByFromId(fromId);
    }

    private void saveReference(List<String> uidsInBox, String referFromId) throws AbstractQingIntegratedException, SQLException {
        HashMap<String, Integer> referTimeMap = new HashMap<String, Integer>();
        int c2 = uidsInBox.size();
        for (int i = 0; i < c2; ++i) {
            String uidInBox = uidsInBox.get(i);
            Integer referTime = (Integer)referTimeMap.get(uidInBox);
            if (referTime == null) {
                referTimeMap.put(uidInBox, 1);
                continue;
            }
            referTimeMap.put(uidInBox, referTime + 1);
        }
        Set entrySet = referTimeMap.entrySet();
        Iterator iterator = entrySet.iterator();
        ArrayList<MacroReference> maroRefs = new ArrayList<MacroReference>(10);
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String uidInBox = (String)entry.getKey();
            Macro macro = this.getManageDao().loadMacroByUid(uidInBox);
            String macroId = "";
            if (macro != null) {
                macroId = macro.getFid();
            }
            MacroReference macroRef = new MacroReference();
            macroRef.setFromId(referFromId);
            macroRef.setToId(macroId);
            macroRef.setToPath(uidInBox);
            macroRef.setCreatorId(this.qingContext.getUserId());
            macroRef.setRefTime((Integer)referTimeMap.get(uidInBox));
            maroRefs.add(macroRef);
        }
        this.getManageDao().batchSaveReference(maroRefs);
    }
}

