/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.message;

import com.kingdee.bos.qing.behavior.impl.BehaviorService;
import com.kingdee.bos.qing.common.context.IQingContextable;
import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.dao.IDBAccessable;
import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ITransactionManagement;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.message.domain.MessageDomain;
import com.kingdee.bos.qing.message.model.MessageLevelTypeEnum;
import com.kingdee.bos.qing.message.model.MessageReadFlagEnum;
import com.kingdee.bos.qing.message.model.ProductLineEnum;
import com.kingdee.bos.qing.message.model.vo.AbstractMessageDetailVO;
import com.kingdee.bos.qing.message.model.vo.BaseMessageDeailVO;
import com.kingdee.bos.qing.message.model.vo.MessageListVO;
import com.kingdee.bos.qing.message.model.vo.ProductLineSyncDataVO;
import com.kingdee.bos.qing.response.IResponseWrap;
import com.kingdee.bos.qing.response.ResponseSuccessWrap;
import com.kingdee.bos.qing.response.ResponseUtil;
import com.kingdee.bos.qing.util.CollectionUtils;
import com.kingdee.bos.qing.util.StringUtils;
import com.kingdee.bos.qing.util.SystemPropertyUtil;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;

public abstract class MessageManageService
extends BehaviorService
implements IDBAccessable,
IQingContextable {
    private static final int DEFAULT_QUERY_LENGTH = 10;
    private static final String PRIVATE_CLOUD = "privateCloud";
    public static final String QING_BEHAVIOR_PRODUCT_NAME = System.getProperty("qing.behavior.product.name");
    private IDBExcuter dbExcuter;
    private ITransactionManagement tx;
    private QingContext context;
    protected MessageDomain messageDomain;

    public final void setQingContext(QingContext context) {
        this.context = context;
    }

    public void setTx(ITransactionManagement tx) {
        this.tx = tx;
    }

    public void setDbExcuter(IDBExcuter dbExcuter) {
        this.dbExcuter = dbExcuter;
    }

    private MessageDomain getMessageDomain() {
        if (this.messageDomain == null) {
            this.messageDomain = new MessageDomain(this.context, this.tx, this.dbExcuter);
        }
        return this.messageDomain;
    }

    public byte[] queryMessageListByPage(Map<String, String> params) {
        String startDateStr = params.get("startDate");
        String endDateStr = params.get("endDate");
        String messageType = params.get("messageType");
        String searchContent = params.get("searchContent");
        String lastOrNextFlag = params.get("lastOrNextFlag");
        String userId = this.context.getUserId();
        try {
            MessageListVO resultVo = new MessageListVO();
            Date minSendDate = this.getMessageDomain().queryMinSendDate(userId);
            if (minSendDate == null) {
                resultVo.setNoData(true);
                resultVo.setMessageDeailVoList(null);
                resultVo.setLastOrNextFlag(lastOrNextFlag);
                return ResponseUtil.output((IResponseWrap)new ResponseSuccessWrap((Object)resultVo));
            }
            Calendar endCalendar = Calendar.getInstance();
            Calendar startCalendar = Calendar.getInstance();
            if (StringUtils.isNotEmpty((CharSequence)startDateStr)) {
                startCalendar.setTimeInMillis(Long.parseLong(startDateStr));
            }
            if (StringUtils.isNotEmpty((CharSequence)endDateStr)) {
                endCalendar.setTimeInMillis(Long.parseLong(endDateStr));
            }
            ArrayList<BaseMessageDeailVO> messageDetailVoList = new ArrayList<BaseMessageDeailVO>();
            boolean isAllData = false;
            while ((CollectionUtils.isEmpty(messageDetailVoList) || messageDetailVoList.size() < 10) && !isAllData) {
                isAllData = this.getBaseMessageDeailVos(userId, minSendDate, endCalendar, startCalendar, messageDetailVoList, messageType, searchContent, resultVo);
            }
            resultVo.setMessageDeailVoList(messageDetailVoList);
            resultVo.setStartDate(Long.toString(startCalendar.getTimeInMillis()));
            resultVo.setEndDate(Long.toString(endCalendar.getTimeInMillis()));
            resultVo.setLastOrNextFlag(lastOrNextFlag);
            return ResponseUtil.output((IResponseWrap)new ResponseSuccessWrap((Object)resultVo));
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    private boolean getBaseMessageDeailVos(String userId, Date minSendDate, Calendar endDate, Calendar startDate, List<BaseMessageDeailVO> messageDetailVoList, String messageType, String searchContent, MessageListVO resultVo) throws AbstractQingIntegratedException, SQLException {
        boolean isAllData = false;
        endDate.setTimeInMillis(startDate.getTimeInMillis());
        startDate.add(2, -1);
        if (minSendDate.getTime() >= startDate.getTimeInMillis()) {
            startDate.setTimeInMillis(minSendDate.getTime());
            isAllData = true;
            resultVo.setQueryAllData(true);
        }
        List<BaseMessageDeailVO> list = this.getMessageDomain().queryMessageListByDateRange(userId, startDate.getTime(), endDate.getTime(), messageType);
        Date currentDate = new Date();
        boolean isSearchContentIsEmpty = StringUtils.isEmpty((CharSequence)searchContent);
        for (BaseMessageDeailVO baseMessageDeailVO : list) {
            if (baseMessageDeailVO.getEffectiveDate() != null && baseMessageDeailVO.getEffectiveDate().getTime() < currentDate.getTime() && !MessageReadFlagEnum.READ.getIsRead().equals(baseMessageDeailVO.getIsRead()) || !isSearchContentIsEmpty && baseMessageDeailVO.getMessageTitle().toLowerCase().indexOf(searchContent.toLowerCase()) == -1) continue;
            messageDetailVoList.add(baseMessageDeailVO);
        }
        return isAllData;
    }

    public byte[] queryUnReadMessageCount(Map<String, String> params) {
        String userId = this.context.getUserId();
        try {
            return ResponseUtil.output((IResponseWrap)new ResponseSuccessWrap((Object)this.getMessageDomain().queryUnReadMessageCount(userId, null)));
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    public byte[] queryImportantUnReadMessage(Map<String, String> params) {
        String userId = this.context.getUserId();
        try {
            return ResponseUtil.output((IResponseWrap)new ResponseSuccessWrap(this.getMessageDomain().queryUnReadMessageDetailList(userId, MessageLevelTypeEnum.MAJOR_LEVEL.getMessageLevel())));
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    public byte[] deleteMessage(Map<String, String> params) {
        String messageReceiverRelId = params.get("messageReceiverRelId");
        String userId = this.context.getUserId();
        try {
            return ResponseUtil.output((IResponseWrap)new ResponseSuccessWrap((Object)this.getMessageDomain().deleteMessage(messageReceiverRelId, userId)));
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    public byte[] readMessage(Map<String, String> params) {
        String messageReceiverRelId = params.get("messageReceiverRelId");
        String messageId = params.get("messageId");
        String userId = this.context.getUserId();
        try {
            this.getMessageDomain().readMessage(messageId, messageReceiverRelId, userId, MessageReadFlagEnum.READ);
            return ResponseUtil.output((IResponseWrap)new ResponseSuccessWrap((Object)Boolean.TRUE));
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    public byte[] messageToUnread(Map<String, String> params) {
        String messageReceiverRelId = params.get("messageReceiverRelId");
        String messageId = params.get("messageId");
        String userId = this.context.getUserId();
        try {
            this.getMessageDomain().readMessage(messageId, messageReceiverRelId, userId, MessageReadFlagEnum.UNREAD);
            return ResponseUtil.output((IResponseWrap)new ResponseSuccessWrap((Object)Boolean.TRUE));
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    public byte[] clearAllMessage(Map<String, String> params) {
        String userId = this.context.getUserId();
        try {
            this.getMessageDomain().clearAllMessage(userId);
            return ResponseUtil.output((IResponseWrap)new ResponseSuccessWrap((Object)Boolean.TRUE));
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    public byte[] queryMessageDetailById(Map<String, String> params) {
        String messageId = params.get("messageId");
        String messageReceiverRelId = params.get("messageReceiverRelId");
        String userId = this.context.getUserId();
        try {
            AbstractMessageDetailVO detailVo = this.getMessageDomain().queryMessageDetailById(messageId, messageReceiverRelId, userId);
            return ResponseUtil.output((IResponseWrap)new ResponseSuccessWrap((Object)detailVo));
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    public byte[] syncMessageData(Map<String, String> params) {
        String accountId = this.context.getAccountId();
        String messageModelList = params.get("messageModelList");
        try {
            this.getMessageDomain().syncMessageData(accountId, messageModelList);
            return ResponseUtil.output((IResponseWrap)new ResponseSuccessWrap((Object)Boolean.TRUE));
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    public byte[] getIsFinishSyncToday(Map<String, String> params) {
        String accountId = this.context.getAccountId();
        Date syncDate = new Date();
        try {
            ProductLineSyncDataVO productLineSyncDataVO = new ProductLineSyncDataVO();
            productLineSyncDataVO.setFinishSyncData(this.getMessageDomain().getIsFinishSyncToday(accountId, syncDate));
            ProductLineEnum productLineEnum = this.getProductLine();
            String clusterName = System.getProperty("clusterName");
            productLineSyncDataVO.setProductLine(productLineEnum.getPublishLine());
            productLineSyncDataVO.setClusterName(StringUtils.isEmpty((CharSequence)clusterName) ? PRIVATE_CLOUD : clusterName);
            String cloudMessageUrl = SystemPropertyUtil.getString((String)"qing.message.serverurl", (String)"https://q.kingdee.com");
            productLineSyncDataVO.setCloudMessageUrl(cloudMessageUrl);
            productLineSyncDataVO.setAccountId(accountId);
            return ResponseUtil.output((IResponseWrap)new ResponseSuccessWrap((Object)productLineSyncDataVO));
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    public byte[] deleteMessageByRule(Map<String, String> params) {
        try {
            this.getMessageDomain().deleteMessageByRule();
            return ResponseUtil.output((IResponseWrap)new ResponseSuccessWrap((Object)Boolean.TRUE));
        }
        catch (Exception e) {
            return ResponseUtil.output((Exception)e);
        }
    }

    protected abstract ProductLineEnum getProductLine();
}

