/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.message.domain;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ITransactionManagement;
import com.kingdee.bos.qing.message.domain.CommonMessageDomain;
import com.kingdee.bos.qing.message.domain.IMessageDomain;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;

public class MessageDomainFactory {
    private static Map<String, Constructor<? extends IMessageDomain>> MESSAGE_DOMAIN_CLASS_MAP = new HashMap<String, Constructor<? extends IMessageDomain>>();

    public static IMessageDomain createMessageDomain(QingContext qingContext, IDBExcuter dbExcuter, ITransactionManagement tx, String bizType) {
        Constructor<? extends IMessageDomain> constructor = MESSAGE_DOMAIN_CLASS_MAP.get(bizType);
        if (constructor == null) {
            return new CommonMessageDomain(qingContext, dbExcuter, tx);
        }
        try {
            return constructor.newInstance(qingContext, dbExcuter, tx);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void regist(String bizType, Class<? extends IMessageDomain> clazz) {
        try {
            Constructor<? extends IMessageDomain> constructor = clazz.getConstructor(QingContext.class, IDBExcuter.class, ITransactionManagement.class);
            MESSAGE_DOMAIN_CLASS_MAP.put(bizType, constructor);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }
}

