/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.publish.dao;

import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ResultHandler;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.publish.model.PubLappSyncRecordPO;
import com.kingdee.bos.qing.util.CollectionUtils;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class PubLappSyncRecordDao {
    private IDBExcuter dbExcuter;

    public PubLappSyncRecordDao(IDBExcuter dbExcuter) {
        this.dbExcuter = dbExcuter;
    }

    public void insertList(List<PubLappSyncRecordPO> pubLappSyncRecordPOS) throws AbstractQingIntegratedException, SQLException {
        if (CollectionUtils.isEmpty(pubLappSyncRecordPOS)) {
            return;
        }
        int count = pubLappSyncRecordPOS.size();
        ArrayList<Object[]> paramsContentList = new ArrayList<Object[]>(count);
        for (int i = 0; i < count; ++i) {
            PubLappSyncRecordPO pubLappSyncRecordPO = pubLappSyncRecordPOS.get(i);
            Object[] paramsContents = new Object[3];
            String fid = this.dbExcuter.genStringId("T_QING_PUB_LAPP_SYNC_RECORD");
            paramsContents[0] = fid;
            paramsContents[1] = pubLappSyncRecordPO.getGroupId();
            paramsContents[2] = pubLappSyncRecordPO.getPublishId();
            paramsContentList.add(paramsContents);
        }
        this.dbExcuter.executeBatch("INSERT INTO T_QING_PUB_LAPP_SYNC_RECORD(FID, FGROUPID, FPUBLISHID) VALUES(?,?,?)", paramsContentList);
    }

    public List<String> queryPublishIdsByGroupId(String bizId) throws AbstractQingIntegratedException, SQLException {
        StringBuilder sql = new StringBuilder("SELECT FPUBLISHID  FROM T_QING_PUB_LAPP_SYNC_RECORD WHERE FGROUPID = ? ");
        return (List)this.dbExcuter.query(sql.toString(), new Object[]{bizId}, (ResultHandler)new ResultHandler<List<String>>(){

            public List<String> handle(ResultSet rs) throws SQLException {
                ArrayList<String> resultList = new ArrayList<String>(10);
                while (rs.next()) {
                    resultList.add(rs.getString("FPUBLISHID"));
                }
                return resultList;
            }
        });
    }

    public void deleteAbolishData() throws AbstractQingIntegratedException, SQLException {
        this.dbExcuter.execute("DELETE FROM T_QING_PUB_LAPP_SYNC_RECORD A WHERE NOT EXISTS (SELECT 1 FROM T_QING_PUB_LAPP_SYNC_GROUP B WHERE A.FGROUPID=B.FID )", new Object[0]);
    }
}

