/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.publish.dao;

import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ResultHandler;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.publish.model.PublishOperPermissionsPO;
import com.kingdee.bos.qing.publish.model.PublishPO;
import com.kingdee.bos.qing.util.CollectionUtils;
import com.kingdee.bos.qing.util.StringUtils;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PublishOperPermissionsDao {
    private IDBExcuter dbExcuter;

    public PublishOperPermissionsDao(IDBExcuter dbExcuter) {
        this.dbExcuter = dbExcuter;
    }

    public void insertList(List<PublishOperPermissionsPO> publishOperPermissionsPOList) throws AbstractQingIntegratedException, SQLException {
        if (CollectionUtils.isEmpty(publishOperPermissionsPOList)) {
            return;
        }
        int count = publishOperPermissionsPOList.size();
        ArrayList<Object[]> paramsContentList = new ArrayList<Object[]>(count);
        for (PublishOperPermissionsPO publishOperPermissionsPO : publishOperPermissionsPOList) {
            Object[] paramsContents = new Object[4];
            String fid = this.dbExcuter.genStringId("T_QING_PUB_OPER_PERMISSIONS");
            paramsContents[0] = fid;
            paramsContents[1] = publishOperPermissionsPO.getPublishId();
            paramsContents[2] = publishOperPermissionsPO.getType();
            paramsContents[3] = publishOperPermissionsPO.getNoOperAuthValue();
            paramsContentList.add(paramsContents);
        }
        this.dbExcuter.executeBatch("INSERT INTO T_QING_PUB_OPER_PERMISSIONS(FID,FPUBLISHID,FTYPE,FNOOPERAUTHVALUE) VALUES(?,?,?,?)", paramsContentList);
    }

    public void deleteByPublishId(String publishId) throws AbstractQingIntegratedException, SQLException {
        this.dbExcuter.execute("DELETE FROM T_QING_PUB_OPER_PERMISSIONS WHERE FPUBLISHID=?", new Object[]{publishId});
    }

    public List<PublishOperPermissionsPO> loadPubOperByPubId(String publishId) throws AbstractQingIntegratedException, SQLException {
        return (List)this.dbExcuter.query("SELECT FPUBLISHID,FTYPE,FNOOPERAUTHVALUE FROM T_QING_PUB_OPER_PERMISSIONS WHERE FPUBLISHID = ? ", new Object[]{publishId}, (ResultHandler)new ResultHandler<List<PublishOperPermissionsPO>>(){

            public List<PublishOperPermissionsPO> handle(ResultSet rs) throws SQLException {
                ArrayList<PublishOperPermissionsPO> resultList = new ArrayList<PublishOperPermissionsPO>(16);
                while (rs.next()) {
                    PublishOperPermissionsPO publishOperPermissionsPO = new PublishOperPermissionsPO();
                    publishOperPermissionsPO.setPublishId(rs.getString("FPUBLISHID"));
                    publishOperPermissionsPO.setType(rs.getString("FTYPE"));
                    publishOperPermissionsPO.setNoOperAuthValue(rs.getInt("FNOOPERAUTHVALUE"));
                    resultList.add(publishOperPermissionsPO);
                }
                return resultList;
            }
        });
    }

    public List<PublishOperPermissionsPO> loadAllParentNoOperAuthValueUnion(PublishPO publishPO, boolean isContainSelf) throws AbstractQingIntegratedException, SQLException {
        ArrayList<String> publishIdList = new ArrayList<String>(16);
        if (isContainSelf) {
            publishIdList.add(publishPO.getId());
        }
        if (StringUtils.isNotEmpty((CharSequence)publishPO.getParentPublishIdFullPath())) {
            String[] parentPublishIds;
            for (String parentPublishId : parentPublishIds = publishPO.getParentPublishIdFullPath().split(",")) {
                publishIdList.add(parentPublishId);
            }
        }
        if (CollectionUtils.isEmpty(publishIdList)) {
            return new ArrayList<PublishOperPermissionsPO>(16);
        }
        StringBuilder sql = new StringBuilder("SELECT  FPUBLISHID,FTYPE,FNOOPERAUTHVALUE FROM ");
        sql.append("T_QING_PUB_OPER_PERMISSIONS");
        sql.append(" WHERE FPUBLISHID IN(?");
        for (int i = 1; i < publishIdList.size(); ++i) {
            sql.append(",?");
        }
        sql.append(" )");
        return (List)this.dbExcuter.query(sql.toString(), publishIdList.toArray(), (ResultHandler)new ResultHandler<List<PublishOperPermissionsPO>>(){

            public List<PublishOperPermissionsPO> handle(ResultSet rs) throws SQLException {
                ArrayList<PublishOperPermissionsPO> resultList = new ArrayList<PublishOperPermissionsPO>(16);
                while (rs.next()) {
                    PublishOperPermissionsPO publishOperPermissionsPO = new PublishOperPermissionsPO();
                    publishOperPermissionsPO.setPublishId(rs.getString("FPUBLISHID"));
                    publishOperPermissionsPO.setType(rs.getString("FTYPE"));
                    publishOperPermissionsPO.setNoOperAuthValue(rs.getInt("FNOOPERAUTHVALUE"));
                    resultList.add(publishOperPermissionsPO);
                }
                return resultList;
            }
        });
    }

    public Map<String, Map<String, Integer>> loadPublishOperPermissionInfo(List<String> ids) throws AbstractQingIntegratedException, SQLException {
        StringBuilder sql = new StringBuilder("SELECT FPUBLISHID,FTYPE,FNOOPERAUTHVALUE FROM T_QING_PUB_OPER_PERMISSIONS WHERE FPUBLISHID IN ( ?");
        for (int i = 1; i < ids.size(); ++i) {
            sql.append(",?");
        }
        sql.append(")");
        return (Map)this.dbExcuter.query(sql.toString(), ids.toArray(), (ResultHandler)new ResultHandler<Map<String, Map<String, Integer>>>(){

            public Map<String, Map<String, Integer>> handle(ResultSet rs) throws SQLException {
                HashMap<String, Map<String, Integer>> resultMap = new HashMap<String, Map<String, Integer>>();
                while (rs.next()) {
                    String publishId = rs.getString("FPUBLISHID");
                    String type = rs.getString("FTYPE");
                    int noOperAuthValue = rs.getInt("FNOOPERAUTHVALUE");
                    if (resultMap.get(publishId) == null) {
                        resultMap.put(publishId, new HashMap());
                    }
                    ((Map)resultMap.get(publishId)).put(type, noOperAuthValue);
                }
                return resultMap;
            }
        });
    }

    public List<PublishOperPermissionsPO> loadTimedPushPermissionInfo(final String publishId) throws AbstractQingIntegratedException, SQLException {
        String sql = "select TP.ftype, TP.fnooperauthvalue from t_qing_pub_email_conf TC right join t_qing_pub_oper_permissions TP on TC.fid = TP.fpublishid join T_QING_PUB_EMAIL_SEND_LOG TL on TC.fid = TL.fconfigid where TL.fpublishid = ?";
        Object[] param = new Object[]{publishId};
        return (List)this.dbExcuter.query(sql, param, (ResultHandler)new ResultHandler<List<PublishOperPermissionsPO>>(){

            public List<PublishOperPermissionsPO> handle(ResultSet rs) throws SQLException {
                ArrayList<PublishOperPermissionsPO> publishOperPermissionsPOS = new ArrayList<PublishOperPermissionsPO>(1);
                while (rs.next()) {
                    String fType = rs.getString("ftype");
                    int fNooperAuthValue = Integer.parseInt(rs.getString("fnooperauthvalue"));
                    PublishOperPermissionsPO publishOperPermissionsPO = new PublishOperPermissionsPO();
                    publishOperPermissionsPO.setNoOperAuthValue(fNooperAuthValue);
                    publishOperPermissionsPO.setPublishId(publishId);
                    publishOperPermissionsPO.setType(fType);
                    publishOperPermissionsPOS.add(publishOperPermissionsPO);
                }
                return publishOperPermissionsPOS;
            }
        });
    }
}

