/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.publish.target.analysiscenter.domain;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ITransactionManagement;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.common.namespace.NameSpace;
import com.kingdee.bos.qing.common.ref.ISwitchPathAndIdHandler;
import com.kingdee.bos.qing.oplog.IOpLogConstant;
import com.kingdee.bos.qing.oplog.model.OpLogActionType;
import com.kingdee.bos.qing.oplog.model.OpLogBO;
import com.kingdee.bos.qing.publish.domain.AbstractPublishManageDomain;
import com.kingdee.bos.qing.publish.exception.PublishException;
import com.kingdee.bos.qing.publish.exception.PublishSameSourceNameDuplicateException;
import com.kingdee.bos.qing.publish.model.PublishPO;
import com.kingdee.bos.qing.publish.model.PublishSourceEnum;
import com.kingdee.bos.qing.publish.model.PublishVO;
import com.kingdee.bos.qing.publish.oplog.PublishOpLog;
import com.kingdee.bos.qing.publish.target.analysiscenter.dao.AnalysisCenterDAO;
import com.kingdee.bos.qing.publish.target.analysiscenter.exception.ACFolderNameDuplicateException;
import com.kingdee.bos.qing.publish.target.analysiscenter.exception.ACFolderNotEmptyException;
import com.kingdee.bos.qing.publish.target.analysiscenter.exception.AnalysisCenterException;
import com.kingdee.bos.qing.publish.target.analysiscenter.handler.AnalysisCenterSwitchPathAndIdHandler;
import com.kingdee.bos.qing.publish.target.analysiscenter.model.AbstractQingCenterVO;
import com.kingdee.bos.qing.publish.target.analysiscenter.model.QingCenterGroupVO;
import com.kingdee.bos.qing.publish.target.analysiscenter.model.QingCenterPathModel;
import com.kingdee.bos.qing.schedule.IScheduleEngine;
import com.kingdee.bos.qing.util.IntegratedHelper;
import com.kingdee.bos.qing.util.JsonUtil;
import com.kingdee.bos.qing.util.LogUtil;
import com.kingdee.bos.qing.util.OpLogUtil;
import com.kingdee.bos.qing.util.StringUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class AnalysisCenterManageDomain
extends AbstractPublishManageDomain {
    private AnalysisCenterDAO analysisCenterDAO;
    private ISwitchPathAndIdHandler switchPathAndIdHandler;

    public AnalysisCenterManageDomain(QingContext qingContext, ITransactionManagement tx, IDBExcuter dbExcuter, IScheduleEngine scheduleEngine) {
        super(qingContext, tx, dbExcuter, scheduleEngine);
    }

    private AnalysisCenterDAO getAnalysisCenterDAO() {
        if (this.analysisCenterDAO == null) {
            this.analysisCenterDAO = new AnalysisCenterDAO(this.qingContext, this.dbExcuter);
        }
        return this.analysisCenterDAO;
    }

    private ISwitchPathAndIdHandler getSwitchPathAndIdHandler() {
        if (this.switchPathAndIdHandler == null) {
            this.switchPathAndIdHandler = new AnalysisCenterSwitchPathAndIdHandler(this.qingContext, this.tx, this.dbExcuter);
        }
        return this.switchPathAndIdHandler;
    }

    public List<QingCenterGroupVO> loadCenterGroup() throws AbstractQingIntegratedException, AnalysisCenterException {
        try {
            this.tx.beginRequired();
            this.getAnalysisCenterDAO().initDefaultGroup(this.qingContext.getUserId());
        }
        catch (AbstractQingIntegratedException e) {
            this.tx.markRollback();
            throw e;
        }
        catch (SQLException e) {
            this.tx.markRollback();
            throw new AnalysisCenterException(e);
        }
        finally {
            this.tx.end();
        }
        try {
            List<QingCenterGroupVO> groups = this.getAnalysisCenterDAO().loadCenterGroups(this.qingContext.getUserId());
            List<QingCenterGroupVO> treeGroup = this.changeGroupDataFormToTree(groups);
            boolean isCurrentUserInQingAdminRole = IntegratedHelper.isCurrentUserInQingAdminRole(this.qingContext, this.dbExcuter);
            if (isCurrentUserInQingAdminRole) {
                List<QingCenterGroupVO> presetGroups = this.getAnalysisCenterDAO().loadCenterPresetGroups();
                List<QingCenterGroupVO> treePresetGroup = this.changeGroupDataFormToTree(presetGroups);
                treeGroup.addAll(0, treePresetGroup);
            }
            return treeGroup;
        }
        catch (SQLException e) {
            throw new AnalysisCenterException(e);
        }
    }

    private List<QingCenterGroupVO> changeGroupDataFormToTree(List<QingCenterGroupVO> groups) {
        ArrayList<QingCenterGroupVO> treeGroup = new ArrayList<QingCenterGroupVO>(groups.size());
        for (int i = 0; i < groups.size(); ++i) {
            QingCenterGroupVO parentGroup = groups.get(i);
            if (StringUtils.isBlank((CharSequence)parentGroup.getLevelId2())) {
                treeGroup.add(parentGroup);
            }
            for (int j = 0; j < groups.size(); ++j) {
                QingCenterGroupVO childGroup = groups.get(j);
                String centerId1 = childGroup.getLevelId1();
                String centerId2 = childGroup.getLevelId2();
                String centerId3 = childGroup.getLevelId3();
                String centerId4 = childGroup.getLevelId4();
                boolean flag = false;
                if (childGroup.getRelationId() == parentGroup.getRelationId()) continue;
                if (StringUtils.isNotBlank((CharSequence)centerId4) && centerId1.equals(parentGroup.getLevelId1()) && centerId2.equals(parentGroup.getLevelId2()) && centerId3.equals(parentGroup.getLevelId3()) && StringUtils.isBlank((CharSequence)parentGroup.getLevelId4())) {
                    childGroup.setParentId(centerId3);
                    flag = true;
                } else if (StringUtils.isNotBlank((CharSequence)centerId3) && centerId1.equals(parentGroup.getLevelId1()) && centerId2.equals(parentGroup.getLevelId2()) && StringUtils.isBlank((CharSequence)parentGroup.getLevelId3()) && StringUtils.isBlank((CharSequence)parentGroup.getLevelId4()) && StringUtils.isBlank((CharSequence)centerId4)) {
                    childGroup.setParentId(centerId2);
                    flag = true;
                } else if (StringUtils.isNotBlank((CharSequence)centerId2) && centerId1.equals(parentGroup.getLevelId1()) && StringUtils.isBlank((CharSequence)parentGroup.getLevelId2()) && StringUtils.isBlank((CharSequence)parentGroup.getLevelId3()) && StringUtils.isBlank((CharSequence)parentGroup.getLevelId4()) && StringUtils.isBlank((CharSequence)centerId3) && StringUtils.isBlank((CharSequence)centerId4)) {
                    childGroup.setParentId(centerId1);
                    flag = true;
                }
                if (!flag) continue;
                if (parentGroup.getChildren() == null) {
                    ArrayList<AbstractQingCenterVO> childrenGroups = new ArrayList<AbstractQingCenterVO>(groups.size());
                    childrenGroups.add(childGroup);
                    parentGroup.setChildren(childrenGroups);
                    continue;
                }
                parentGroup.getChildren().add(childGroup);
            }
        }
        return treeGroup;
    }

    public QingCenterGroupVO saveCenterGroup(QingCenterGroupVO centerVO, String addType) throws AbstractQingIntegratedException, AnalysisCenterException {
        QingCenterGroupVO centerGroupVO;
        try {
            this.tx.beginRequired();
            centerGroupVO = this.getAnalysisCenterDAO().saveCenterGroup(centerVO, addType, this.qingContext.getUserId());
        }
        catch (ACFolderNameDuplicateException e) {
            this.tx.markRollback();
            throw e;
        }
        catch (AbstractQingIntegratedException e) {
            this.tx.markRollback();
            throw e;
        }
        catch (SQLException e) {
            this.tx.markRollback();
            throw new AnalysisCenterException(e);
        }
        finally {
            this.tx.end();
        }
        this.addPubDirOpLog(centerGroupVO, OpLogActionType.NEW, null);
        return centerGroupVO;
    }

    private void addPubDirOpLog(QingCenterGroupVO centerGroupVO, OpLogActionType opLogActionType, String newName) {
        ArrayList<String> dirNames = new ArrayList<String>(4);
        PublishOpLog qingAnalysisCenter = PublishOpLog.DATA_ANALYSIS_CENTER;
        qingAnalysisCenter.setLogScene("\u53d1\u5e03\u7ba1\u7406\u76ee\u5f55");
        qingAnalysisCenter.setParamsDesc("\u201c$param\u201d");
        if (StringUtils.isNotBlank((CharSequence)centerGroupVO.getLevelName1())) {
            dirNames.add(centerGroupVO.getLevelName1());
        }
        if (StringUtils.isNotBlank((CharSequence)centerGroupVO.getLevelName2())) {
            dirNames.add(centerGroupVO.getLevelName2());
        }
        if (StringUtils.isNotBlank((CharSequence)centerGroupVO.getLevelName3())) {
            dirNames.add(centerGroupVO.getLevelName3());
        }
        if (StringUtils.isNotBlank((CharSequence)centerGroupVO.getLevelName4())) {
            dirNames.add(centerGroupVO.getLevelName4());
        }
        ArrayList<String> params = new ArrayList<String>(2);
        params.add(StringUtils.join((char)'-', dirNames));
        if (OpLogActionType.EDIT.equals((Object)opLogActionType)) {
            qingAnalysisCenter.setParamsDesc("\u201c$param\u201d\u7684\u540d\u79f0\u4e3a\u201c$param\u201d");
            dirNames.set(dirNames.size() - 1, newName);
            params.add(StringUtils.join((char)'-', dirNames));
        }
        OpLogUtil.addLog((OpLogBO)new OpLogBO(opLogActionType, (IOpLogConstant)qingAnalysisCenter, params));
    }

    @Override
    public void addPublishOpLog(OpLogActionType opLogActionType, List<String> params, String opLogParam) {
        try {
            PublishOpLog qingAnalysisCenterDir = PublishOpLog.QING_ANALYSIS_CENTER_DIR;
            qingAnalysisCenterDir.setLogScene("\u53d1\u5e03\u8bb0\u5f55");
            qingAnalysisCenterDir.setParamsDesc(opLogParam);
            OpLogUtil.addLog((OpLogBO)new OpLogBO(opLogActionType, (IOpLogConstant)qingAnalysisCenterDir, params));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void addPublishOpLogWithPath(OpLogActionType opLogActionType, List<String> params, String opLogParam) {
        try {
            PublishOpLog qingAnalysisCenterDir = PublishOpLog.DATA_ANALYSIS_CENTER;
            qingAnalysisCenterDir.setLogScene("\u53d1\u5e03\u8bb0\u5f55");
            qingAnalysisCenterDir.setParamsDesc(opLogParam);
            OpLogUtil.addLog((OpLogBO)new OpLogBO(opLogActionType, (IOpLogConstant)qingAnalysisCenterDir, params));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public PublishVO getPublishVO(String fid) throws AbstractQingIntegratedException, SQLException {
        return this.getAnalysisCenterDAO().loadPublishInfo(this.qingContext.getUserId(), fid);
    }

    public String updateCenterGroup(QingCenterGroupVO centerVO, Integer iLevel) throws AnalysisCenterException, AbstractQingIntegratedException {
        List updateGroupList = new ArrayList(4);
        String newMenuID = "";
        try {
            this.tx.beginRequired();
            Map<String, Object> updateGroupMap = this.getAnalysisCenterDAO().updateCenterGroup(centerVO, iLevel);
            if (updateGroupMap != null) {
                newMenuID = (String)updateGroupMap.get("newCenterID");
                updateGroupList = (List)updateGroupMap.get("updateGroups");
                for (QingCenterGroupVO centerGroupVO : updateGroupList) {
                    this.updateRefToId(centerGroupVO, centerGroupVO.getRelationId());
                }
            }
        }
        catch (ACFolderNameDuplicateException e) {
            this.tx.markRollback();
            throw e;
        }
        catch (AbstractQingIntegratedException e) {
            this.tx.markRollback();
            throw e;
        }
        catch (SQLException e) {
            this.tx.markRollback();
            throw new AnalysisCenterException(e);
        }
        finally {
            this.tx.end();
        }
        if (updateGroupList.size() > 0) {
            QingCenterGroupVO centerGroupVO = (QingCenterGroupVO)updateGroupList.get(updateGroupList.size() - 1);
            this.addPubDirOpLog(centerGroupVO, OpLogActionType.EDIT, centerVO.getName());
        }
        return newMenuID;
    }

    private void updateRefToId(QingCenterGroupVO qingCenterGroupVO, String path) throws AbstractQingIntegratedException {
        try {
            int type = 1;
            String publishSourceType = PublishSourceEnum.subject.toString();
            String userId = this.qingContext.getUserId();
            List<PublishPO> publishPOs = this.getPublishInfoDao().loadPublishInfo(type, path, userId, publishSourceType);
            for (int i = 0; i < publishPOs.size(); ++i) {
                PublishPO publishInfo = publishPOs.get(i);
                String publishId = publishInfo.getId();
                String fullPath = qingCenterGroupVO.getLevelName1() + "/" + publishInfo.getName();
                String fullPathWithNameSpace = NameSpace.user.toPersistance() + "/" + fullPath;
                QingCenterPathModel qingCenterPathModel = new QingCenterPathModel();
                qingCenterPathModel.setNameSpace(NameSpace.user.toPersistance());
                qingCenterPathModel.setCenterName1(qingCenterGroupVO.getLevelName1());
                qingCenterPathModel.setCenterName2(qingCenterGroupVO.getLevelName2());
                qingCenterPathModel.setCenterName3(qingCenterGroupVO.getLevelName3());
                qingCenterPathModel.setCenterName4(qingCenterGroupVO.getLevelName4());
                qingCenterPathModel.setName(publishInfo.getName());
                ISwitchPathAndIdHandler switchPathAndIdHandler = this.getSwitchPathAndIdHandler();
                switchPathAndIdHandler.replacePersistentPathToId(fullPath, publishId, userId);
                switchPathAndIdHandler.replacePersistentPathToId(fullPathWithNameSpace, publishId, userId);
                switchPathAndIdHandler.replacePersistentPathToId(JsonUtil.encodeToString((Object)qingCenterPathModel), publishId, userId);
            }
        }
        catch (SQLException e) {
            LogUtil.error((String)"update ref error");
        }
    }

    public void deleteCenterGroup(List<String> deleteDirRelationIdList) throws AbstractQingIntegratedException, AnalysisCenterException {
        String group;
        try {
            boolean hasPublishInfo = this.getPublishInfoDao().hasPublishInfo(this.qingContext.getUserId(), 1, deleteDirRelationIdList);
            if (hasPublishInfo) {
                throw new ACFolderNotEmptyException();
            }
        }
        catch (SQLException e) {
            throw new AnalysisCenterException(e);
        }
        try {
            this.tx.beginRequired();
            group = this.getAnalysisCenterDAO().findPublishNameByPath(deleteDirRelationIdList.get(0));
            this.getAnalysisCenterDAO().deleteCenterGroup(deleteDirRelationIdList);
        }
        catch (AbstractQingIntegratedException e) {
            this.tx.markRollback();
            throw e;
        }
        catch (SQLException e) {
            this.tx.markRollback();
            throw new AnalysisCenterException(e);
        }
        finally {
            this.tx.end();
        }
        ArrayList<String> params = new ArrayList<String>(1);
        params.add(group);
        PublishOpLog dataAnalysisCenter = PublishOpLog.DATA_ANALYSIS_CENTER;
        dataAnalysisCenter.setLogScene("\u53d1\u5e03\u7ba1\u7406\u76ee\u5f55");
        dataAnalysisCenter.setParamsDesc("\u201c$param\u201d");
        OpLogUtil.addLog((OpLogBO)new OpLogBO(OpLogActionType.DELETE, (IOpLogConstant)dataAnalysisCenter, params));
    }

    public List<PublishVO> loadPublishInfos(String pathId, boolean isPreset) throws AbstractQingIntegratedException, AnalysisCenterException {
        try {
            List<Object> publishInfos = new ArrayList();
            publishInfos = isPreset ? this.getAnalysisCenterDAO().loadPresetPublishInfos(pathId) : this.getAnalysisCenterDAO().loadPublishInfos(pathId);
            String pathText = this.getAnalysisCenterDAO().findPublishNameByPath(pathId);
            int len = publishInfos.size();
            for (int i = 0; i < len; ++i) {
                ((PublishVO)publishInfos.get(i)).setPathText(pathText);
            }
            this.setPublishPermissionInfo(publishInfos);
            return publishInfos;
        }
        catch (PublishException e) {
            throw new AnalysisCenterException((Throwable)((Object)e));
        }
        catch (SQLException e) {
            throw new AnalysisCenterException(e);
        }
    }

    public List<PublishVO> loadAllPublishInfos(boolean isPresetPublish) throws AbstractQingIntegratedException, AnalysisCenterException {
        try {
            ArrayList<PublishVO> publishInfosTotal = new ArrayList<PublishVO>(10);
            String userId = this.qingContext.getUserId();
            if (IntegratedHelper.isCurrentUserInQingAdminRole(this.qingContext, this.dbExcuter) && isPresetPublish) {
                String presetUserId = IntegratedHelper.getPresetUserId();
                List<PublishVO> publishInfosPresent = this.getAnalysisCenterDAO().loadAllPresetPublishInfos(presetUserId);
                publishInfosTotal.addAll(publishInfosPresent);
            } else {
                List<PublishVO> publishInfos = this.getAnalysisCenterDAO().loadAllPublishInfos(userId);
                publishInfosTotal.addAll(publishInfos);
            }
            int len = publishInfosTotal.size();
            for (int i = 0; i < len; ++i) {
                String pathText = this.getAnalysisCenterDAO().findPublishNameByPath(((PublishVO)publishInfosTotal.get(i)).getPath());
                ((PublishVO)publishInfosTotal.get(i)).setPathText(pathText);
            }
            this.setPublishPermissionInfo(publishInfosTotal);
            return publishInfosTotal;
        }
        catch (PublishException e) {
            throw new AnalysisCenterException((Throwable)((Object)e));
        }
        catch (SQLException e) {
            throw new AnalysisCenterException(e);
        }
    }

    public void deleteEmptyCenterGroupByUserId(String userId) throws AbstractQingIntegratedException, AnalysisCenterException {
        try {
            this.tx.beginRequired();
            this.getAnalysisCenterDAO().deleteEmptyCenterGroupByUserId(userId);
        }
        catch (AbstractQingIntegratedException e) {
            this.tx.markRollback();
            throw e;
        }
        catch (SQLException e) {
            this.tx.markRollback();
            throw new AnalysisCenterException(e);
        }
        finally {
            this.tx.end();
        }
    }

    @Override
    protected void verifyPublishInfoWhenUpdate(PublishPO publishPO, String bizTag) throws PublishException, AbstractQingIntegratedException, SQLException {
        String fId;
        boolean isSameSourceNameExist = this.getPublishInfoDao().checkSameSourceNameExist(publishPO, bizTag, false);
        if (!isSameSourceNameExist && ((fId = this.getPublishInfoDao().loadPublishId(publishPO.getPublishTargetType(), publishPO.getName(), publishPO.getPath(), this.qingContext.getUserId())) == null || publishPO.getId().equals(fId))) {
            return;
        }
        throw new PublishSameSourceNameDuplicateException();
    }
}

