/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.sourcemanage.dao;

import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ResultHandler;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.dbmanage.model.DBConnectionPO;
import com.kingdee.bos.qing.sourcemanage.model.SourceRefPO;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class SourceRefDao {
    private IDBExcuter dbExcuter;

    public SourceRefDao(IDBExcuter dbExcuter) {
        this.dbExcuter = dbExcuter;
    }

    public String saveSourceRef(SourceRefPO sourceRefPO) throws AbstractQingIntegratedException, SQLException {
        String sql = "INSERT INTO T_QING_M_EXISTING_SRC_REF (FID, FSOURCEID, FREFID, FTYPE, FHASHCODE, FCREATORID, FCREATETIME,FMODIFIERID, FMODIFYTIME) VALUES (?,?,?,?,?,?,?,?,?)";
        Object[] params = new Object[9];
        int i = 0;
        params[i++] = sourceRefPO.getId();
        params[i++] = sourceRefPO.getSourceId();
        params[i++] = sourceRefPO.getRefId();
        params[i++] = sourceRefPO.getType();
        params[i++] = sourceRefPO.getHashCode();
        params[i++] = sourceRefPO.getCreatorId();
        params[i++] = sourceRefPO.getCreateTime();
        params[i++] = sourceRefPO.getModifierId();
        params[i++] = sourceRefPO.getModifyTime();
        this.dbExcuter.execute(sql, params);
        return sourceRefPO.getId();
    }

    public SourceRefPO loadSourceRefById(String id) throws AbstractQingIntegratedException, SQLException {
        String sql = "SELECT FID, FSOURCEID, FREFID, FTYPE, FPATH, FHASHCODE, FCREATORID, FCREATETIME,FMODIFIERID, FMODIFYTIME FROM T_QING_M_EXISTING_SRC_REF WHERE FID = ?";
        return (SourceRefPO)this.dbExcuter.query(sql, new Object[]{id}, (ResultHandler)new ResultHandler<SourceRefPO>(){

            public SourceRefPO handle(ResultSet rs) throws SQLException {
                if (rs.next()) {
                    SourceRefPO sourceRefPO = new SourceRefPO();
                    sourceRefPO.setId(rs.getString("FID"));
                    sourceRefPO.setSourceId(rs.getString("FSOURCEID"));
                    sourceRefPO.setRefId(rs.getString("FREFID"));
                    sourceRefPO.setType(rs.getInt("FTYPE"));
                    sourceRefPO.setPath(rs.getString("FPATH"));
                    sourceRefPO.setHashCode(rs.getString("FHASHCODE"));
                    sourceRefPO.setCreateTime(rs.getTimestamp("FCREATETIME"));
                    sourceRefPO.setCreatorId(rs.getString("FCREATORID"));
                    sourceRefPO.setModifyTime(rs.getTimestamp("FMODIFYTIME"));
                    sourceRefPO.setModifierId(rs.getString("FMODIFIERID"));
                    return sourceRefPO;
                }
                return null;
            }
        });
    }

    public List<SourceRefPO> loadSourceRefByHashCode(String hashCode) throws AbstractQingIntegratedException, SQLException {
        String sql = "SELECT FID, FSOURCEID, FREFID, FTYPE, FPATH, FHASHCODE, FCREATORID, FCREATETIME,FMODIFIERID, FMODIFYTIME FROM T_QING_M_EXISTING_SRC_REF WHERE FHASHCODE = ?";
        return (List)this.dbExcuter.query(sql, new Object[]{hashCode}, (ResultHandler)new ResultHandler<List<SourceRefPO>>(){

            public List<SourceRefPO> handle(ResultSet rs) throws SQLException {
                ArrayList<SourceRefPO> sourceRefPOS = new ArrayList<SourceRefPO>(10);
                if (rs.next()) {
                    SourceRefPO sourceRefPO = new SourceRefPO();
                    sourceRefPO.setId(rs.getString("FID"));
                    sourceRefPO.setSourceId(rs.getString("FSOURCEID"));
                    sourceRefPO.setRefId(rs.getString("FREFID"));
                    sourceRefPO.setType(rs.getInt("FTYPE"));
                    sourceRefPO.setPath(rs.getString("FPATH"));
                    sourceRefPO.setHashCode(rs.getString("FHASHCODE"));
                    sourceRefPO.setCreateTime(rs.getTimestamp("FCREATETIME"));
                    sourceRefPO.setCreatorId(rs.getString("FCREATORID"));
                    sourceRefPO.setModifyTime(rs.getTimestamp("FMODIFYTIME"));
                    sourceRefPO.setModifierId(rs.getString("FMODIFIERID"));
                    sourceRefPOS.add(sourceRefPO);
                }
                return sourceRefPOS;
            }
        });
    }

    public void deleteModelSetSource(String id) throws AbstractQingIntegratedException, SQLException {
        String sql = "DELETE FROM T_QING_M_EXISTING_SRC_REF WHERE FID = ?";
        this.dbExcuter.execute(sql, new Object[]{id});
    }

    public void updateRefToIdByHashCode(String refId, String hashCode, String userId) throws AbstractQingIntegratedException, SQLException {
        Object[] params = new Object[]{refId, userId, new Date(), hashCode};
        this.dbExcuter.execute("UPDATE T_QING_M_EXISTING_SRC_REF SET FREFID=?,FMODIFIERID=?,FMODIFYTIME=?  WHERE FHASHCODE=?", params);
    }

    public void updatePathByRefId(String refId, String path, String userId) throws AbstractQingIntegratedException, SQLException {
        Object[] params = new Object[]{path, userId, new Date(), refId};
        this.dbExcuter.execute("UPDATE T_QING_M_EXISTING_SRC_REF SET FPATH=?,FMODIFIERID=?,FMODIFYTIME=?  WHERE FREFID=?", params);
    }

    public void batchUpdatePathByRefId(List<DBConnectionPO> updateRefList, String userId) throws AbstractQingIntegratedException, SQLException {
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>(updateRefList.size());
        Date now = new Date();
        for (DBConnectionPO po : updateRefList) {
            Object[] params = new Object[]{po.getName(), userId, now, po.getId()};
            paramsList.add(params);
        }
        this.dbExcuter.executeBatch("UPDATE T_QING_M_EXISTING_SRC_REF SET FPATH=?,FMODIFIERID=?,FMODIFYTIME=?  WHERE FREFID=?", paramsList);
    }

    public void updateHashCodeByRefId(String refId, String hashCode, String userId) throws AbstractQingIntegratedException, SQLException {
        Object[] params = new Object[]{hashCode, userId, new Date(), refId};
        this.dbExcuter.execute("UPDATE T_QING_M_EXISTING_SRC_REF SET FHASHCODE=?,FMODIFIERID=?,FMODIFYTIME=?  WHERE FREFID=?", params);
    }
}

