/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.common.format;

import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.Format;

public class NumberFormater {
    private RichFormatString[] _conditionFormatStrings;
    private IConditionChecker[] _conditionChecker;

    public NumberFormater() {
    }

    public NumberFormater(String formatString) {
        this.setFormatString(formatString);
    }

    public void setFormatString(String formatString) {
        if (formatString == null || formatString.length() == 0) {
            this._conditionChecker = new IConditionChecker[1];
            this._conditionChecker[0] = null;
            this._conditionFormatStrings = new RichFormatString[1];
            this._conditionFormatStrings[0] = null;
        } else {
            this.seperateCondition(formatString);
        }
    }

    public String format(BigDecimal value) {
        String result;
        Format formater = null;
        RichFormatString rich = null;
        for (int i = 0; i < this._conditionFormatStrings.length; ++i) {
            if (this._conditionChecker[i] != null && !this._conditionChecker[i].isMatch(value)) continue;
            rich = this._conditionFormatStrings[i];
            if (rich == null) break;
            try {
                formater = new DecimalFormat(rich.getPure());
                ((DecimalFormat)formater).setRoundingMode(RoundingMode.HALF_UP);
            }
            catch (IllegalArgumentException ex) {
                formater = null;
            }
            if (this._conditionChecker[i] == null) break;
            this._conditionChecker[i].initFormater((DecimalFormat)formater);
            break;
        }
        if (formater != null && rich != null && (rich.getGroupingSymbol() > '\u0000' || rich.getDecimalSymbol() > '\u0000')) {
            DecimalFormatSymbols symbols = new DecimalFormatSymbols();
            if (rich.getGroupingSymbol() > '\u0000') {
                symbols.setGroupingSeparator(rich.getGroupingSymbol());
            }
            if (rich.getDecimalSymbol() > '\u0000') {
                symbols.setDecimalSeparator(rich.getDecimalSymbol());
            }
            ((DecimalFormat)formater).setDecimalFormatSymbols(symbols);
        }
        if (rich != null && rich.getUnitPower() != 0) {
            int oriScale = value.scale();
            value = value.multiply(BigDecimal.TEN.pow(-rich.getUnitPower(), new MathContext(2, RoundingMode.HALF_UP)));
            if (formater == null && rich.getUnitPower() < 0) {
                value = value.setScale(Math.max(0, oriScale + rich.getUnitPower()), RoundingMode.HALF_UP);
            }
        }
        if (formater == null || rich == null) {
            result = value.toString();
        } else if (rich.getPure().length() > 0) {
            result = formater.format(value);
            result = result.replaceAll("^-(?=0(\\.0*)?$)", "");
        } else {
            result = "";
        }
        if (rich != null && rich.getPrefix() != null) {
            result = rich.getPrefix() + result;
        }
        if (rich != null && rich.getSuffix() != null) {
            result = result + rich.getSuffix();
        }
        return result;
    }

    private void seperateCondition(String formatString) {
        String[] strs = formatString.split(";", 3);
        if (strs.length >= 3) {
            this._conditionChecker = new IConditionChecker[3];
            this._conditionChecker[0] = new ZeroChecker();
            this._conditionChecker[1] = new NegativeChecker();
            this._conditionChecker[2] = null;
            this._conditionFormatStrings = new RichFormatString[3];
            this._conditionFormatStrings[0] = new RichFormatString(strs[2]);
            this._conditionFormatStrings[1] = new RichFormatString(strs[1]);
            this._conditionFormatStrings[2] = new RichFormatString(strs[0]);
        } else if (strs.length == 2) {
            this._conditionChecker = new IConditionChecker[2];
            this._conditionChecker[0] = new NegativeChecker();
            this._conditionChecker[1] = null;
            this._conditionFormatStrings = new RichFormatString[2];
            this._conditionFormatStrings[0] = new RichFormatString(strs[1]);
            this._conditionFormatStrings[1] = new RichFormatString(strs[0]);
        } else {
            this._conditionChecker = new IConditionChecker[1];
            this._conditionChecker[0] = null;
            this._conditionFormatStrings = new RichFormatString[1];
            this._conditionFormatStrings[0] = new RichFormatString(formatString);
        }
    }

    private static class NegativeChecker
    implements IConditionChecker {
        private NegativeChecker() {
        }

        @Override
        public boolean isMatch(BigDecimal value) {
            return BigDecimal.ZERO.compareTo(value) > 0;
        }

        @Override
        public void initFormater(DecimalFormat formater) {
            formater.setNegativePrefix("");
        }
    }

    private static class ZeroChecker
    implements IConditionChecker {
        private ZeroChecker() {
        }

        @Override
        public boolean isMatch(BigDecimal value) {
            return BigDecimal.ZERO.compareTo(value) == 0;
        }

        @Override
        public void initFormater(DecimalFormat formater) {
        }
    }

    public static interface IConditionChecker {
        public boolean isMatch(BigDecimal var1);

        public void initFormater(DecimalFormat var1);
    }

    private static class RichFormatString {
        private String _pure;
        private String _prefix;
        private String _suffix;
        private int _unitPower;
        private char _groupingSymbol;
        private char _decimalSymbol;

        public RichFormatString(String customString) {
            this.parse(customString);
        }

        public String getPure() {
            return this._pure;
        }

        public String getPrefix() {
            return this._prefix;
        }

        public String getSuffix() {
            return this._suffix;
        }

        public int getUnitPower() {
            return this._unitPower;
        }

        public char getGroupingSymbol() {
            return this._groupingSymbol;
        }

        public char getDecimalSymbol() {
            return this._decimalSymbol;
        }

        private void parse(String customString) {
            int zeroIdx;
            int rightBraceIdx;
            int leftBraceIdx = customString.indexOf(123);
            if (leftBraceIdx >= 0 && (rightBraceIdx = customString.indexOf(125)) > leftBraceIdx + 1) {
                String sacle = customString.substring(leftBraceIdx + 1, rightBraceIdx);
                try {
                    this._unitPower = Integer.parseInt(sacle);
                    customString = customString.substring(0, leftBraceIdx) + customString.substring(rightBraceIdx + 1);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            int pureStart = -1;
            int pureEnd = -1;
            int sharpIdx = customString.indexOf(35);
            if (sharpIdx >= 0) {
                int lastSharpIdx = customString.lastIndexOf(35);
                int groupingSymbol = 0;
                int symbolIdx = -1;
                for (int i = sharpIdx + 1; i < lastSharpIdx; ++i) {
                    char chr = customString.charAt(i);
                    if (groupingSymbol > 0 && chr != '#') {
                        groupingSymbol = 0;
                        break;
                    }
                    if (chr == '#') continue;
                    groupingSymbol = chr;
                    symbolIdx = i;
                }
                if (groupingSymbol > 0 && groupingSymbol != 44) {
                    this._groupingSymbol = (char)groupingSymbol;
                    customString = customString.substring(0, symbolIdx) + "," + customString.substring(symbolIdx + 1);
                }
                pureStart = sharpIdx;
                pureEnd = lastSharpIdx + 1;
            }
            if ((zeroIdx = customString.indexOf(48)) >= 0) {
                int lastZeroIdx = customString.lastIndexOf(48);
                int decimalSymbol = 0;
                int symbolIdx = -1;
                for (int i = zeroIdx + 1; i < lastZeroIdx; ++i) {
                    char chr = customString.charAt(i);
                    if (decimalSymbol > 0 && chr != '0') {
                        decimalSymbol = 0;
                        break;
                    }
                    if (chr == '0') continue;
                    decimalSymbol = chr;
                    symbolIdx = i;
                }
                if (decimalSymbol > 0 && decimalSymbol != 46) {
                    this._decimalSymbol = (char)decimalSymbol;
                    customString = customString.substring(0, symbolIdx) + "." + customString.substring(symbolIdx + 1);
                }
                pureStart = pureStart < 0 ? zeroIdx : Math.min(pureStart, zeroIdx);
                pureEnd = Math.max(pureEnd, lastZeroIdx + 1);
            }
            if (pureStart == 0) {
                this._prefix = null;
                this._pure = customString.substring(pureStart, pureEnd);
            } else if (pureStart > 0) {
                this._prefix = customString.substring(0, pureStart);
                this._pure = customString.substring(pureStart, pureEnd);
            } else {
                this._prefix = customString;
                this._pure = "";
            }
            this._suffix = pureEnd >= 0 && pureEnd < customString.length() ? customString.substring(pureEnd) : null;
        }
    }
}

