/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.common.framework.web.dependency;

import com.kingdee.bos.qing.common.context.IQingContextable;
import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.exception.AbstractQingException;
import com.kingdee.bos.qing.common.framework.model.QingServiceAsynDispatcherModel;
import com.kingdee.bos.qing.common.framework.model.QingServiceSynDispatcherModel;
import com.kingdee.bos.qing.common.framework.server.AbstractQingServerRequestDispatcher;
import com.kingdee.bos.qing.util.MethodInvokeUtil;

public abstract class QingWebRequestDispatcher {
    private static QingWebRequestDispatcher _impl = new JvmLocalWebRequestDispatcher();

    public static void setImpl(QingWebRequestDispatcher impl) {
        _impl = impl;
    }

    public static QingWebRequestDispatcher getImpl() {
        return _impl;
    }

    protected abstract Object dispatch(QingContext var1, String var2, String var3, Object ... var4) throws AbstractQingException;

    public static Object synDispatcher(QingContext qingContext, String appID, QingServiceSynDispatcherModel model) throws AbstractQingException {
        return QingWebRequestDispatcher.getImpl().dispatch(qingContext, appID, "synDispatcher", model);
    }

    public static Object synDispatcher(QingContext qingContext, String appID, String serviceType, String methodName, Object ... params) throws AbstractQingException {
        QingServiceSynDispatcherModel model = new QingServiceSynDispatcherModel();
        model.setServiceType(serviceType);
        model.setMethodName(methodName);
        model.setParameters(params);
        return QingWebRequestDispatcher.synDispatcher(qingContext, appID, model);
    }

    public static Object asynDispatcher(QingContext qingContext, String appID, QingServiceAsynDispatcherModel model) throws AbstractQingException {
        return QingWebRequestDispatcher.getImpl().dispatch(qingContext, appID, "asynDispatcher", model);
    }

    public static byte[] asynDispatcher(QingContext qingContext, String appID, String serviceType, String clientID, String callID, String methodName, Object ... params) throws AbstractQingException {
        QingServiceAsynDispatcherModel model = new QingServiceAsynDispatcherModel();
        model.setServiceType(serviceType);
        model.setClientID(clientID);
        model.setCallID(callID);
        model.setAppID(appID);
        model.setMethodName(methodName);
        model.setParameters(params);
        return (byte[])QingWebRequestDispatcher.asynDispatcher(qingContext, appID, model);
    }

    private static class JvmLocalQingServerRequestDispatcher
    extends AbstractQingServerRequestDispatcher
    implements IQingContextable {
        private static ThreadLocal<QingContext> current = new ThreadLocal();

        private JvmLocalQingServerRequestDispatcher() {
        }

        @Override
        protected QingContext getContext() {
            return current.get();
        }

        @Override
        public void setQingContext(QingContext qingContext) {
            current.set(qingContext);
        }
    }

    private static class JvmLocalWebRequestDispatcher
    extends QingWebRequestDispatcher {
        private static final JvmLocalQingServerRequestDispatcher serviceImpl = new JvmLocalQingServerRequestDispatcher();

        private JvmLocalWebRequestDispatcher() {
        }

        @Override
        public Object dispatch(QingContext qingContext, String appID, String methodName, Object ... paras) throws AbstractQingException {
            return MethodInvokeUtil.invoke(qingContext, serviceImpl, methodName, paras);
        }
    }
}

