/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.common.grammar.expr;

import com.kingdee.bos.qing.common.grammar.IExecuteContext;
import com.kingdee.bos.qing.common.grammar.exception.ExecuteException;
import com.kingdee.bos.qing.common.grammar.expr.AbstractExpr;

public class ConstanceExpr
extends AbstractExpr {
    public static final ConstanceExpr TRUE = new ConstanceExpr(Boolean.toString(Boolean.TRUE), Boolean.TRUE, 6);
    public static final ConstanceExpr FALSE = new ConstanceExpr(Boolean.toString(Boolean.FALSE), Boolean.FALSE, 6);
    public static final ConstanceExpr NULL = new ConstanceExpr("NULL", null, 0);
    private String name;
    private int dataType;
    private Object value;

    public ConstanceExpr(String name, Object value, int dataType) {
        this.name = name;
        this.dataType = dataType;
        this.value = value;
    }

    public static ConstanceExpr acceptAndCreate(String name) {
        if ("TRUE".equals(name) || "true".equals(name)) {
            return TRUE;
        }
        if ("FALSE".equals(name) || "false".equals(name)) {
            return FALSE;
        }
        if ("NULL".equals(name) || "null".equals(name)) {
            return NULL;
        }
        return null;
    }

    @Override
    public int getPriority() {
        return 99;
    }

    @Override
    public String encode() {
        return this.name;
    }

    @Override
    public int getReturnDataType() {
        return this.dataType;
    }

    @Override
    public Object execute(IExecuteContext ctx) throws ExecuteException {
        return this.value;
    }
}

