/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.common.grammar.funcimpl;

import com.kingdee.bos.qing.common.grammar.IExecuteContext;
import com.kingdee.bos.qing.common.grammar.exception.ExecuteException;
import com.kingdee.bos.qing.common.grammar.exception.ParserException;
import com.kingdee.bos.qing.common.grammar.expr.AbstractFunctionExpr;
import com.kingdee.bos.qing.common.grammar.expr.IExpr;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;

public class MathematicFunctions {
    private static final int[] PARAMS_NUMBER = new int[]{2};
    private static final int[] PARAMS_NUMBER_NUMBER = new int[]{2, 2};
    private static final int[] PARAMS_NUMBER_STRING = new int[]{2, 1};

    public static BigDecimal generateBigDecimalSafety(Double value, IExpr expr) throws ExecuteException {
        if (value.isInfinite() || value.isNaN()) {
            throw ExecuteException.returnDataOutOfScope(expr);
        }
        return BigDecimal.valueOf(value);
    }

    public static class MINIMUM
    extends AbstractFunctionExpr {
        public MINIMUM() {
            super("MINIMUM");
        }

        @Override
        protected void checkSubExprsDataType(IExpr[] subExprs) throws ParserException {
            if (subExprs.length == 0) {
                throw MINIMUM.exUnmatchedParamCount(this);
            }
            int expectDataType = subExprs[0].getReturnDataType();
            if (expectDataType != 2 && expectDataType != 3 && expectDataType != 4 && expectDataType != 5) {
                throw MINIMUM.exUnmatchedDataType(subExprs[0]);
            }
            for (IExpr expr : subExprs) {
                if (expr.getReturnDataType() == expectDataType) continue;
                throw MINIMUM.exUnmatchedDataType(expr);
            }
        }

        @Override
        public int getReturnDataType() {
            return this.getSubExprs()[0].getReturnDataType();
        }

        @Override
        public Object execute(IExecuteContext ctx) throws ExecuteException {
            IExpr[] subExprs = this.getSubExprs();
            IExpr expr = subExprs[0];
            Comparable minData = (Comparable)expr.execute(ctx);
            for (int i = 1; i < subExprs.length; ++i) {
                Comparable currentData = (Comparable)subExprs[i].execute(ctx);
                if (minData == null) {
                    minData = currentData;
                    continue;
                }
                if (currentData == null) continue;
                minData = currentData.compareTo(minData) < 0 ? currentData : minData;
            }
            return minData;
        }
    }

    public static class MAXIMUM
    extends AbstractFunctionExpr {
        public MAXIMUM() {
            super("MAXIMUM");
        }

        @Override
        protected void checkSubExprsDataType(IExpr[] subExprs) throws ParserException {
            if (subExprs.length == 0) {
                throw MAXIMUM.exUnmatchedParamCount(this);
            }
            int expectDataType = subExprs[0].getReturnDataType();
            if (expectDataType != 2 && expectDataType != 3 && expectDataType != 4 && expectDataType != 5) {
                throw MAXIMUM.exUnmatchedDataType(subExprs[0]);
            }
            for (IExpr expr : subExprs) {
                if (expr.getReturnDataType() == expectDataType) continue;
                throw MAXIMUM.exUnmatchedDataType(expr);
            }
        }

        @Override
        public int getReturnDataType() {
            return this.getSubExprs()[0].getReturnDataType();
        }

        @Override
        public Object execute(IExecuteContext ctx) throws ExecuteException {
            IExpr[] subExprs = this.getSubExprs();
            IExpr expr = subExprs[0];
            Comparable maxData = (Comparable)expr.execute(ctx);
            for (int i = 1; i < subExprs.length; ++i) {
                Comparable currentData = (Comparable)subExprs[i].execute(ctx);
                if (maxData == null) {
                    maxData = currentData;
                    continue;
                }
                if (currentData == null) continue;
                maxData = currentData.compareTo(maxData) > 0 ? currentData : maxData;
            }
            return maxData;
        }
    }

    public static class ZN
    extends AbstractFunctionExpr {
        public ZN() {
            super("ZN");
        }

        @Override
        protected void checkSubExprsDataType(IExpr[] subExprs) throws ParserException {
            this.checkSubExprsStrictlyMatch(subExprs, new int[][]{PARAMS_NUMBER});
        }

        @Override
        public int getReturnDataType() {
            return 2;
        }

        @Override
        public Object execute(IExecuteContext ctx) throws ExecuteException {
            Object value = this.getSubExprs()[0].execute(ctx);
            return value == null ? BigDecimal.ZERO : value;
        }
    }

    public static class ATAN2
    extends AbstractMathematicFunctionExpr {
        public ATAN2() {
            super("ATAN2");
        }

        @Override
        protected void checkSubExprsDataType(IExpr[] subExprs) throws ParserException {
            this.checkSubExprsStrictlyMatch(subExprs, new int[][]{PARAMS_NUMBER_NUMBER});
        }

        @Override
        public Object execute(IExecuteContext ctx) throws ExecuteException {
            BigDecimal x = ATAN2.getNumber(this.getSubExprs()[0], ctx);
            BigDecimal y = ATAN2.getNumber(this.getSubExprs()[1], ctx);
            return MathematicFunctions.generateBigDecimalSafety(StrictMath.atan2(y.doubleValue(), x.doubleValue()), this);
        }
    }

    public static class ATAN
    extends AbstractMathematicFunctionExpr {
        public ATAN() {
            super("ATAN");
        }

        @Override
        protected void checkSubExprsDataType(IExpr[] subExprs) throws ParserException {
            this.checkSubExprsStrictlyMatch(subExprs, new int[][]{PARAMS_NUMBER});
        }

        @Override
        public Object execute(IExecuteContext ctx) throws ExecuteException {
            BigDecimal number = ATAN.getNumber(this.getSubExprs()[0], ctx);
            return MathematicFunctions.generateBigDecimalSafety(StrictMath.atan(number.doubleValue()), this);
        }
    }

    public static class TAN
    extends AbstractMathematicFunctionExpr {
        public TAN() {
            super("TAN");
        }

        @Override
        protected void checkSubExprsDataType(IExpr[] subExprs) throws ParserException {
            this.checkSubExprsStrictlyMatch(subExprs, new int[][]{PARAMS_NUMBER});
        }

        @Override
        public Object execute(IExecuteContext ctx) throws ExecuteException {
            BigDecimal number = TAN.getNumber(this.getSubExprs()[0], ctx);
            return MathematicFunctions.generateBigDecimalSafety(StrictMath.tan(number.doubleValue()), this);
        }
    }

    public static class ACOS
    extends AbstractMathematicFunctionExpr {
        public ACOS() {
            super("ACOS");
        }

        @Override
        protected void checkSubExprsDataType(IExpr[] subExprs) throws ParserException {
            this.checkSubExprsStrictlyMatch(subExprs, new int[][]{PARAMS_NUMBER});
        }

        @Override
        public Object execute(IExecuteContext ctx) throws ExecuteException {
            BigDecimal number = ACOS.getNumber(this.getSubExprs()[0], ctx);
            if (number.abs().doubleValue() > 1.0) {
                throw ExecuteException.unexpectedParamValue(this);
            }
            return BigDecimal.valueOf(StrictMath.acos(number.doubleValue()));
        }
    }

    public static class COS
    extends AbstractMathematicFunctionExpr {
        public COS() {
            super("COS");
        }

        @Override
        protected void checkSubExprsDataType(IExpr[] subExprs) throws ParserException {
            this.checkSubExprsStrictlyMatch(subExprs, new int[][]{PARAMS_NUMBER});
        }

        @Override
        public Object execute(IExecuteContext ctx) throws ExecuteException {
            BigDecimal number = COS.getNumber(this.getSubExprs()[0], ctx);
            return BigDecimal.valueOf(StrictMath.cos(number.doubleValue()));
        }
    }

    public static class ASIN
    extends AbstractMathematicFunctionExpr {
        public ASIN() {
            super("ASIN");
        }

        @Override
        protected void checkSubExprsDataType(IExpr[] subExprs) throws ParserException {
            this.checkSubExprsStrictlyMatch(subExprs, new int[][]{PARAMS_NUMBER});
        }

        @Override
        public Object execute(IExecuteContext ctx) throws ExecuteException {
            BigDecimal number = ASIN.getNumber(this.getSubExprs()[0], ctx);
            if (number.abs().doubleValue() > 1.0) {
                throw ExecuteException.unexpectedParamValue(this);
            }
            return BigDecimal.valueOf(StrictMath.asin(number.doubleValue()));
        }
    }

    public static class SIN
    extends AbstractMathematicFunctionExpr {
        public SIN() {
            super("SIN");
        }

        @Override
        protected void checkSubExprsDataType(IExpr[] subExprs) throws ParserException {
            this.checkSubExprsStrictlyMatch(subExprs, new int[][]{PARAMS_NUMBER});
        }

        @Override
        public Object execute(IExecuteContext ctx) throws ExecuteException {
            BigDecimal number = SIN.getNumber(this.getSubExprs()[0], ctx);
            return BigDecimal.valueOf(StrictMath.sin(number.doubleValue()));
        }
    }

    public static class DEGREES
    extends AbstractMathematicFunctionExpr {
        public DEGREES() {
            super("DEGREES");
        }

        @Override
        protected void checkSubExprsDataType(IExpr[] subExprs) throws ParserException {
            this.checkSubExprsStrictlyMatch(subExprs, new int[][]{PARAMS_NUMBER});
        }

        @Override
        public Object execute(IExecuteContext ctx) throws ExecuteException {
            BigDecimal number = DEGREES.getNumber(this.getSubExprs()[0], ctx);
            return BigDecimal.valueOf(number.doubleValue() * 180.0 / Math.PI);
        }
    }

    public static class RADIANS
    extends AbstractMathematicFunctionExpr {
        public RADIANS() {
            super("RADIANS");
        }

        @Override
        protected void checkSubExprsDataType(IExpr[] subExprs) throws ParserException {
            this.checkSubExprsStrictlyMatch(subExprs, new int[][]{PARAMS_NUMBER});
        }

        @Override
        public Object execute(IExecuteContext ctx) throws ExecuteException {
            BigDecimal number = RADIANS.getNumber(this.getSubExprs()[0], ctx);
            return BigDecimal.valueOf(number.doubleValue() * Math.PI / 180.0);
        }
    }

    public static class PI
    extends AbstractMathematicFunctionExpr {
        public PI() {
            super("PI");
        }

        @Override
        protected void checkSubExprsDataType(IExpr[] subExprs) throws ParserException {
            if (subExprs.length != 0) {
                throw PI.exUnmatchedParamCount(this);
            }
        }

        @Override
        public Object execute(IExecuteContext ctx) throws ExecuteException {
            return BigDecimal.valueOf(Math.PI);
        }
    }

    public static class POWER
    extends AbstractMathematicFunctionExpr {
        public POWER() {
            super("POWER");
        }

        @Override
        protected void checkSubExprsDataType(IExpr[] subExprs) throws ParserException {
            this.checkSubExprsStrictlyMatch(subExprs, new int[][]{PARAMS_NUMBER_NUMBER});
        }

        @Override
        public Object execute(IExecuteContext ctx) throws ExecuteException {
            BigDecimal number = POWER.getNumber(this.getSubExprs()[0], ctx);
            BigDecimal power = POWER.getNumber(this.getSubExprs()[1], ctx);
            double d = StrictMath.pow(number.doubleValue(), power.doubleValue());
            return MathematicFunctions.generateBigDecimalSafety(d, this);
        }
    }

    public static class EXP
    extends AbstractMathematicFunctionExpr {
        public EXP() {
            super("EXP");
        }

        @Override
        protected void checkSubExprsDataType(IExpr[] subExprs) throws ParserException {
            this.checkSubExprsStrictlyMatch(subExprs, new int[][]{PARAMS_NUMBER});
        }

        @Override
        public Object execute(IExecuteContext ctx) throws ExecuteException {
            BigDecimal number = EXP.getNumber(this.getSubExprs()[0], ctx);
            Double value = StrictMath.exp(number.doubleValue());
            return MathematicFunctions.generateBigDecimalSafety(value, this);
        }
    }

    public static class LOG
    extends AbstractMathematicFunctionExpr {
        public LOG() {
            super("LOG");
        }

        @Override
        protected void checkSubExprsDataType(IExpr[] subExprs) throws ParserException {
            this.checkSubExprsStrictlyMatch(subExprs, PARAMS_NUMBER_NUMBER, PARAMS_NUMBER);
        }

        @Override
        public Object execute(IExecuteContext ctx) throws ExecuteException {
            BigDecimal number = LOG.getNumber(this.getSubExprs()[0], ctx);
            BigDecimal base = BigDecimal.TEN;
            if (this.getSubExprs().length == 2) {
                base = LOG.getNumber(this.getSubExprs()[1], ctx);
            }
            return MathematicFunctions.generateBigDecimalSafety(StrictMath.log(number.doubleValue()) / StrictMath.log(base.doubleValue()), this);
        }
    }

    public static class LN
    extends AbstractMathematicFunctionExpr {
        public LN() {
            super("LN");
        }

        @Override
        protected void checkSubExprsDataType(IExpr[] subExprs) throws ParserException {
            this.checkSubExprsStrictlyMatch(subExprs, new int[][]{PARAMS_NUMBER});
        }

        @Override
        public Object execute(IExecuteContext ctx) throws ExecuteException {
            BigDecimal bd = LN.getNumber(this.getSubExprs()[0], ctx);
            return MathematicFunctions.generateBigDecimalSafety(StrictMath.log(bd.doubleValue()), this);
        }
    }

    public static class INT
    extends AbstractMathematicFunctionExpr {
        private static Map<String, Integer> MODE = new HashMap<String, Integer>();

        public INT() {
            super("INT");
        }

        @Override
        protected void checkSubExprsDataType(IExpr[] subExprs) throws ParserException {
            this.checkSubExprsCommonImpl(subExprs, PARAMS_NUMBER, PARAMS_NUMBER_STRING);
        }

        @Override
        public Object execute(IExecuteContext ctx) throws ExecuteException {
            IExpr[] subExprs = this.getSubExprs();
            BigDecimal number = INT.getNumber(subExprs[0], ctx);
            int roundingMode = 3;
            if (subExprs.length > 1) {
                Integer mode;
                String type = this.getStringValue(subExprs[1], ctx);
                Integer n = mode = type == null ? null : MODE.get(type.toLowerCase());
                if (mode == null) {
                    return number;
                }
                roundingMode = mode;
            }
            number = number.setScale(0, roundingMode);
            return number;
        }

        static {
            MODE.put("half_up", 4);
            MODE.put("half_down", 5);
            MODE.put("up", 0);
            MODE.put("down", 1);
            MODE.put("ceiling", 2);
            MODE.put("floor", 3);
        }
    }

    public static class ROUND
    extends AbstractMathematicFunctionExpr {
        public ROUND() {
            super("ROUND");
        }

        @Override
        protected void checkSubExprsDataType(IExpr[] subExprs) throws ParserException {
            this.checkSubExprsStrictlyMatch(subExprs, new int[][]{PARAMS_NUMBER_NUMBER});
        }

        @Override
        public Object execute(IExecuteContext ctx) throws ExecuteException {
            BigDecimal bd = ROUND.getNumber(this.getSubExprs()[0], ctx);
            int iDigit = this.getIntValue(this.getSubExprs()[1], ctx);
            if (iDigit >= 0) {
                return bd.setScale(iDigit, 4);
            }
            BigDecimal pow = BigDecimal.valueOf(StrictMath.pow(10.0, -iDigit));
            bd = bd.divide(pow, 0, 4);
            bd = bd.multiply(pow);
            bd = bd.setScale(0);
            return bd;
        }
    }

    public static class SQRT
    extends AbstractMathematicFunctionExpr {
        public SQRT() {
            super("SQRT");
        }

        @Override
        protected void checkSubExprsDataType(IExpr[] subExprs) throws ParserException {
            this.checkSubExprsStrictlyMatch(subExprs, new int[][]{PARAMS_NUMBER});
        }

        @Override
        public Object execute(IExecuteContext ctx) throws ExecuteException {
            BigDecimal dfValue = SQRT.getNumber(this.getSubExprs()[0], ctx);
            if (dfValue.compareTo(BigDecimal.ZERO) < 0) {
                throw ExecuteException.unmatchedParamValTypeException(this.getSubExprs()[0]);
            }
            return BigDecimal.valueOf(StrictMath.sqrt(dfValue.doubleValue()));
        }
    }

    public static class MOD
    extends AbstractMathematicFunctionExpr {
        public MOD() {
            super("MOD");
        }

        @Override
        protected void checkSubExprsDataType(IExpr[] subExprs) throws ParserException {
            this.checkSubExprsStrictlyMatch(subExprs, new int[][]{PARAMS_NUMBER_NUMBER});
        }

        @Override
        public Object execute(IExecuteContext ctx) throws ExecuteException {
            BigDecimal numberDecimal = MOD.getNumber(this.getSubExprs()[0], ctx);
            BigDecimal divisorDecimal = MOD.getNumber(this.getSubExprs()[1], ctx);
            if (divisorDecimal.compareTo(BigDecimal.ZERO) == 0) {
                throw ExecuteException.zeroNumberException(this.getSubExprs()[1]);
            }
            BigDecimal sign = new BigDecimal(divisorDecimal.compareTo(BigDecimal.ZERO));
            numberDecimal = numberDecimal.abs();
            divisorDecimal = divisorDecimal.abs();
            BigDecimal quotientDecimal = numberDecimal.divideToIntegralValue(divisorDecimal);
            BigDecimal result = numberDecimal.subtract(quotientDecimal.multiply(divisorDecimal));
            return result.multiply(sign);
        }
    }

    public static class SIGN
    extends AbstractMathematicFunctionExpr {
        public SIGN() {
            super("SIGN");
        }

        @Override
        protected void checkSubExprsDataType(IExpr[] subExprs) throws ParserException {
            this.checkSubExprsStrictlyMatch(subExprs, new int[][]{PARAMS_NUMBER});
        }

        @Override
        public Object execute(IExecuteContext ctx) throws ExecuteException {
            BigDecimal decimal = SIGN.getNumber(this.getSubExprs()[0], ctx);
            int sign = decimal.compareTo(BigDecimal.ZERO);
            return new BigDecimal(sign);
        }
    }

    public static class ABS
    extends AbstractMathematicFunctionExpr {
        public ABS() {
            super("ABS");
        }

        @Override
        protected void checkSubExprsDataType(IExpr[] subExprs) throws ParserException {
            this.checkSubExprsStrictlyMatch(subExprs, new int[][]{PARAMS_NUMBER});
        }

        @Override
        public Object execute(IExecuteContext ctx) throws ExecuteException {
            BigDecimal decimal = ABS.getNumber(this.getSubExprs()[0], ctx);
            return decimal.abs();
        }
    }

    public static abstract class AbstractMathematicFunctionExpr
    extends AbstractFunctionExpr {
        public AbstractMathematicFunctionExpr(String name) {
            super(name);
        }

        @Override
        public int getReturnDataType() {
            return 2;
        }
    }
}

