/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.common.network;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CIDRAddress {
    private static final String IP_ADDRESS = "(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})";
    private static final String SLASH_FORMAT = "(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})/(\\d{1,2})";
    private static final Pattern addressPattern = Pattern.compile("(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})");
    private static final Pattern cidrPattern = Pattern.compile("(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})/(\\d{1,2})");
    private static final int NBITS = 32;
    private int netmask = 0;
    private int address = 0;
    private int network = 0;
    private int broadcast = 0;

    public CIDRAddress(String cidrNotation) {
        this.calculate(cidrNotation);
    }

    public final SubnetInfo getSubnetInfo() {
        return new SubnetInfo();
    }

    private void calculate(String mask) {
        Matcher matcher = cidrPattern.matcher(mask);
        if (matcher.matches()) {
            this.address = this.matchAddress(matcher);
            int cidrPart = this.rangeCheck(Integer.parseInt(matcher.group(5)), 0, 32);
            for (int j = 0; j < cidrPart; ++j) {
                this.netmask |= 1 << 31 - j;
            }
        } else {
            throw new IllegalArgumentException("Could not parse [" + mask + "]");
        }
        this.network = this.address & this.netmask;
        this.broadcast = this.network | ~this.netmask;
    }

    private int toInteger(String address) {
        Matcher matcher = addressPattern.matcher(address);
        if (matcher.matches()) {
            return this.matchAddress(matcher);
        }
        throw new IllegalArgumentException("Could not parse [" + address + "]");
    }

    private int matchAddress(Matcher matcher) {
        int addr = 0;
        for (int i = 1; i <= 4; ++i) {
            int n = this.rangeCheck(Integer.parseInt(matcher.group(i)), 0, 255);
            addr |= (n & 0xFF) << 8 * (4 - i);
        }
        return addr;
    }

    public boolean matchIpAddress(String address) {
        Matcher matcher = addressPattern.matcher(address);
        if (matcher.matches()) {
            for (int i = 1; i <= 4; ++i) {
                int value = Integer.parseInt(matcher.group(i));
                if (value >= 0 && value <= 255) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private int[] toArray(int val) {
        int[] ret = new int[4];
        for (int j = 3; j >= 0; --j) {
            int n = j;
            ret[n] = ret[n] | val >>> 8 * (3 - j) & 0xFF;
        }
        return ret;
    }

    private String format(int[] octets) {
        StringBuilder str = new StringBuilder();
        for (int i = 0; i < octets.length; ++i) {
            str.append(octets[i]);
            if (i == octets.length - 1) continue;
            str.append(".");
        }
        return str.toString();
    }

    private int rangeCheck(int value, int begin, int end) {
        if (value >= begin && value <= end) {
            return value;
        }
        throw new IllegalArgumentException("Value [" + value + "] not in range [" + begin + "," + end + "]");
    }

    public final class SubnetInfo {
        private static final long UNSIGNED_INT_MASK = 0xFFFFFFFFL;

        private SubnetInfo() {
        }

        private int network() {
            return CIDRAddress.this.network;
        }

        private int broadcast() {
            return CIDRAddress.this.broadcast;
        }

        private long networkLong() {
            return (long)CIDRAddress.this.network & 0xFFFFFFFFL;
        }

        private long broadcastLong() {
            return (long)CIDRAddress.this.broadcast & 0xFFFFFFFFL;
        }

        private int low() {
            return this.broadcastLong() - this.networkLong() > 1L ? this.network() + 1 : 0;
        }

        private int high() {
            return this.broadcastLong() - this.networkLong() > 1L ? this.broadcast() - 1 : 0;
        }

        public boolean isInRange(String address) {
            return this.isInRange(CIDRAddress.this.toInteger(address));
        }

        public boolean isInRange(int address) {
            long addLong = (long)address & 0xFFFFFFFFL;
            long lowLong = (long)this.low() & 0xFFFFFFFFL;
            long highLong = (long)this.high() & 0xFFFFFFFFL;
            return addLong >= lowLong && addLong <= highLong;
        }
    }
}

