/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.common.thread;

import com.kingdee.bos.qing.common.thread.ThreadPoolExecutor;
import java.util.Collection;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;

public class TaskQueue
extends LinkedBlockingQueue<Runnable> {
    private static final String taskQueue_notRunning = "Executor not running, can't force a command into the queue";
    private static final long serialVersionUID = 1L;
    private volatile transient ThreadPoolExecutor parent = null;
    private Integer forcedRemainingCapacity = null;

    public TaskQueue() {
    }

    public TaskQueue(int capacity) {
        super(capacity);
    }

    public TaskQueue(Collection<? extends Runnable> c) {
        super(c);
    }

    public void setParent(ThreadPoolExecutor tp) {
        this.parent = tp;
    }

    public boolean force(Runnable o) {
        if (this.parent == null || this.parent.isShutdown()) {
            throw new RejectedExecutionException(taskQueue_notRunning);
        }
        return super.offer(o);
    }

    public boolean force(Runnable o, long timeout, TimeUnit unit) throws InterruptedException {
        if (this.parent == null || this.parent.isShutdown()) {
            throw new RejectedExecutionException(taskQueue_notRunning);
        }
        return super.offer(o, timeout, unit);
    }

    @Override
    public boolean offer(Runnable o) {
        if (this.parent == null) {
            return super.offer(o);
        }
        if (this.parent.getPoolSize() == this.parent.getMaximumPoolSize()) {
            return super.offer(o);
        }
        if (this.parent.getSubmittedCount() <= this.parent.getPoolSize()) {
            return super.offer(o);
        }
        if (this.parent.getPoolSize() < this.parent.getMaximumPoolSize()) {
            return false;
        }
        return super.offer(o);
    }

    @Override
    public Runnable poll(long timeout, TimeUnit unit) throws InterruptedException {
        Runnable runnable = (Runnable)super.poll(timeout, unit);
        if (runnable == null && this.parent != null) {
            this.parent.stopCurrentThreadIfNeeded();
        }
        return runnable;
    }

    @Override
    public Runnable take() throws InterruptedException {
        if (this.parent != null && this.parent.currentThreadShouldBeStopped()) {
            return this.poll(this.parent.getKeepAliveTime(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS);
        }
        return (Runnable)super.take();
    }

    @Override
    public int remainingCapacity() {
        if (this.forcedRemainingCapacity != null) {
            return this.forcedRemainingCapacity;
        }
        return super.remainingCapacity();
    }

    public void setForcedRemainingCapacity(Integer forcedRemainingCapacity) {
        this.forcedRemainingCapacity = forcedRemainingCapacity;
    }
}

