/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.common.trace;

import com.kingdee.bos.qing.util.StringUtils;
import com.kingdee.bos.qing.util.XmlUtil;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jdom2.Content;
import org.jdom2.Element;

public class TraceSpan {
    public static final String ATTRIBUTE_KEY_CLASS_METHOD = "\u7c7b\u65b9\u6cd5";
    private final transient long startTimestap;
    private List<TraceSpan> children = new ArrayList<TraceSpan>(10);
    private long cost;
    private String description;
    private Integer seriesNum;
    private Map<String, String> attributeMap = new LinkedHashMap<String, String>(16);

    public static TraceSpan createEmpty(String description) {
        TraceSpan traceSpan = new TraceSpan();
        traceSpan.description = description;
        return traceSpan;
    }

    private TraceSpan() {
        this.startTimestap = System.currentTimeMillis();
    }

    public void addAttribute(String key, String value) {
        this.attributeMap.put(key, value);
    }

    public void addClassMethodAttribute(String value) {
        this.attributeMap.put(ATTRIBUTE_KEY_CLASS_METHOD, value);
    }

    public String getDescription() {
        return this.description;
    }

    public List<TraceSpan> getChildren() {
        return this.children;
    }

    public Map<String, String> getAttributeMap() {
        return this.attributeMap;
    }

    public long getCost() {
        return this.cost;
    }

    public void close() {
        this.cost = System.currentTimeMillis() - this.startTimestap;
    }

    public Integer getSeriesNum() {
        return this.seriesNum;
    }

    public void setSeriesNum(Integer seriesNum) {
        this.seriesNum = seriesNum;
    }

    public void close(long customCost) {
        this.cost = customCost;
    }

    public Element toXml() {
        Element traceElement = new Element("Trace");
        traceElement.setAttribute("description", this.description);
        traceElement.setAttribute("cost", String.valueOf(this.cost));
        if (this.seriesNum != null) {
            traceElement.setAttribute("seriesNum", String.valueOf(this.seriesNum));
        }
        if (this.attributeMap != null && !this.attributeMap.isEmpty()) {
            for (Map.Entry<String, String> entry : this.attributeMap.entrySet()) {
                Element attributeElement = new Element("Attribute");
                attributeElement.setAttribute("key", entry.getKey());
                XmlUtil.addCDATA(attributeElement, entry.getValue());
                traceElement.addContent((Content)attributeElement);
            }
        }
        if (this.children != null && !this.children.isEmpty()) {
            for (TraceSpan child : this.children) {
                traceElement.addContent((Content)child.toXml());
            }
        }
        return traceElement;
    }

    public static TraceSpan fromXml(Element traceElement) {
        List traceChildElements;
        List attributeElements;
        TraceSpan traceSpan = new TraceSpan();
        traceSpan.description = traceElement.getAttributeValue("description");
        traceSpan.cost = Long.parseLong(traceElement.getAttributeValue("cost"));
        String seriesNumStr = traceElement.getAttributeValue("seriesNum");
        if (StringUtils.isNotBlank(seriesNumStr)) {
            traceSpan.seriesNum = Integer.valueOf(seriesNumStr);
        }
        if ((attributeElements = traceElement.getChildren("Attribute")) != null && !attributeElements.isEmpty()) {
            for (Element attributeElement : attributeElements) {
                traceSpan.getAttributeMap().put(attributeElement.getAttributeValue("key"), attributeElement.getTextTrim());
            }
        }
        if ((traceChildElements = traceElement.getChildren("Trace")) != null && !traceChildElements.isEmpty()) {
            for (Element traceChildElement : traceChildElements) {
                traceSpan.getChildren().add(TraceSpan.fromXml(traceChildElement));
            }
        }
        return traceSpan;
    }
}

