/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.filesystem.manager;

import com.kingdee.bos.qing.common.lock.ILock;
import com.kingdee.bos.qing.common.lock.LockFactory;
import com.kingdee.bos.qing.common.lock.QingLockRequireException;
import com.kingdee.bos.qing.filesystem.manager.localimpl.FileSysUtil;
import com.kingdee.bos.qing.filesystem.manager.model.AbstractQingFileType;
import com.kingdee.bos.qing.util.LogUtil;
import com.kingdee.bos.qing.util.StringUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;

public class ScheduleFailedManager {
    private static final String dirName = FileSysUtil.getAbsoluteFilePath(File.separator + "QingStorage" + File.separator);
    private static final String fileName = "deleteFailedLog.txt";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logDeleteFailedFile(AbstractQingFileType fileType, String deleteFailedFileName, String accountId) {
        if (!this.checkDeleteFailedFile()) {
            this.makeFile();
        }
        ILock fileLock = LockFactory.createLock(fileName);
        try {
            fileLock.lock();
            try (FileOutputStream fileOutputStream = null;){
                String str = fileType.isTemp() + " " + fileType.getSubFolder() + " " + deleteFailedFileName + " " + accountId;
                File file = new File(dirName + File.separator + fileName);
                fileOutputStream = new FileOutputStream(file, true);
                fileOutputStream.write((str + "\n").getBytes());
            }
        }
        catch (IOException e) {
            LogUtil.error("\u5173\u95ed\u6587\u4ef6\u5931\u8d25", e);
        }
        catch (QingLockRequireException e) {
            LogUtil.error("", e);
        }
        catch (InterruptedException e) {
            LogUtil.error("", e);
        }
        finally {
            fileLock.unlock();
        }
    }

    public void cleanDeleteFailedFile() {
        ILock fileLock = LockFactory.createLock(fileName);
        try {
            fileLock.lock();
            this.deleteFile();
        }
        catch (QingLockRequireException e) {
            LogUtil.error("", e);
        }
        catch (InterruptedException e) {
            LogUtil.error("", e);
        }
        finally {
            fileLock.unlock();
        }
    }

    private boolean checkDeleteFailedFile() {
        File file;
        File directory = new File(dirName);
        return directory.isDirectory() && (file = new File(dirName + File.separator + fileName)).isFile();
    }

    private void makeFile() {
        if (null == dirName || null == fileName) {
            LogUtil.error("\u6587\u4ef6\u5939\u6216\u6587\u4ef6\u540d\u4e3a\u7a7aLOG_FOLDER" + dirName + "fileName" + fileName);
            return;
        }
        File file = new File(dirName + File.separator + fileName);
        if (!file.isFile()) {
            try {
                if (!file.createNewFile()) {
                    LogUtil.error("\u65e0\u6cd5\u521b\u5efa\u65e5\u5fd7\u6587\u4ef6");
                }
            }
            catch (SecurityException e) {
                LogUtil.error("\u521b\u5efa\u6587\u4ef6\u6743\u9650\u4e0d\u8db3" + e.getMessage());
            }
            catch (IOException e) {
                LogUtil.error(e.getMessage());
            }
        }
    }

    private void deleteFile() {
        File file = new File(dirName + File.separator + fileName);
        if (file.exists() && (!file.exists() || file.length() != 0L)) {
            String str = null;
            ArrayList<String> list = new ArrayList<String>();
            try {
                FileInputStream inputStream = new FileInputStream(file);
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                while ((str = bufferedReader.readLine()) != null) {
                    if (str.equals("") || this.deleteSingleFile(str)) continue;
                    list.add(str);
                }
                bufferedReader.close();
                inputStream.close();
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                if (list.size() > 0) {
                    for (String s : list) {
                        fileOutputStream.write((s + "\n").getBytes());
                    }
                }
                fileOutputStream.close();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private boolean deleteSingleFile(String str) {
        String filePath;
        File file1 = null;
        String[] s = str.trim().split(" ");
        boolean isTempFile = Boolean.parseBoolean(s[0]);
        String fileTypeFolderName = s[1];
        String singleFileName = s[2];
        String subAccountIdFolderName = null;
        if (s.length > 3) {
            subAccountIdFolderName = s[3];
        }
        if ((file1 = this.correctPath(dirName, filePath = isTempFile ? "QingTemp" : "QingPersistent", fileTypeFolderName, singleFileName, subAccountIdFolderName)) == null) {
            return true;
        }
        if (!file1.delete()) {
            LogUtil.error("\u6587\u4ef6\u5220\u9664\u5931\u8d25:" + file1.getAbsolutePath());
            return false;
        }
        return true;
    }

    private File correctPath(String dirName, String subFolderName, String fileTypeFolderName, String singleFileName, String subAccountIdFolderName) {
        File file = new File(dirName + subFolderName + File.separator + fileTypeFolderName + File.separator + singleFileName);
        if (!file.exists() && StringUtils.isNotEmpty(subAccountIdFolderName)) {
            file = new File(dirName + subAccountIdFolderName + File.separator + subFolderName + File.separator + fileTypeFolderName + File.separator + singleFileName);
        }
        if (!file.exists()) {
            LogUtil.info("\u6587\u4ef6\u5df2\u88ab\u5220\u9664:" + dirName + "/" + subFolderName + "/" + fileTypeFolderName + "/" + singleFileName + ", accountId:" + subAccountIdFolderName);
            return null;
        }
        return file;
    }
}

