/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.filesystem.manager.fileresource.domain;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ITransactionManagement;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.common.strategy.CustomStrategyRegistrar;
import com.kingdee.bos.qing.common.strategy.license.IQingLicenceChecker;
import com.kingdee.bos.qing.filesystem.manager.fileresource.dao.FileResourceDao;
import com.kingdee.bos.qing.filesystem.manager.fileresource.model.FileResourcePO;
import com.kingdee.bos.qing.filesystem.manager.fileresource.model.FileResourceVO;
import com.kingdee.bos.qing.filesystem.manager.model.AbstractQingFileType;
import com.kingdee.bos.qing.resource.AbstractResourceManager;
import com.kingdee.bos.qing.resource.ResourceManagerFactory;
import com.kingdee.bos.qing.resource.domain.ResourceInfoDomain;
import com.kingdee.bos.qing.resource.exception.ResourceManagementException;
import com.kingdee.bos.qing.util.SystemPropertyUtil;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.List;

public class FileResourceDomain {
    public static final int tenantFreeFileSize = 0;
    public static final int payUserFreeFileSize = 1024;
    public static final int freeUserFreeFileSize = SystemPropertyUtil.getInt("qing.freeUser.freeFileSize", 1024);
    private QingContext qingContext;
    private ITransactionManagement tx;
    private FileResourceDao fileResourceDao;
    private ResourceInfoDomain resourceInfoDomain;

    private ResourceInfoDomain getResourceInfoDomain() {
        if (this.resourceInfoDomain == null) {
            AbstractResourceManager resourceManager = ResourceManagerFactory.createResourceManager(this.qingContext);
            this.resourceInfoDomain = new ResourceInfoDomain(resourceManager);
        }
        return this.resourceInfoDomain;
    }

    public FileResourceDomain(QingContext qingContext, ITransactionManagement tx, IDBExcuter idbExcuter) {
        this.qingContext = qingContext;
        this.tx = tx;
        this.fileResourceDao = new FileResourceDao(idbExcuter);
    }

    public int getTenantFreeFileSize() {
        return 0;
    }

    public int getUserFreeFileSize() {
        IQingLicenceChecker qingLicenseChecker = CustomStrategyRegistrar.getStrategy(IQingLicenceChecker.class);
        if (qingLicenseChecker == null) {
            throw new RuntimeException("Get IQingLicenceChecker Impl Failed, Please check QingLicenseChecker is registed.");
        }
        int licenseResult = qingLicenseChecker.checkLicence();
        if (licenseResult == 0) {
            return 1024;
        }
        return freeUserFreeFileSize;
    }

    public BigDecimal findSumFileSizeByUserId() throws AbstractQingIntegratedException, ResourceManagementException {
        String userId = this.qingContext.getUserId();
        try {
            return this.fileResourceDao.findSumFileSizeByUserId(userId);
        }
        catch (SQLException e) {
            throw new ResourceManagementException(e);
        }
    }

    public BigDecimal findSumFileSizeByUserId(String userId) throws AbstractQingIntegratedException, ResourceManagementException {
        try {
            return this.fileResourceDao.findSumFileSizeByUserId(userId);
        }
        catch (SQLException e) {
            throw new ResourceManagementException(e);
        }
    }

    public BigDecimal findSumTenantUseFileSizeByTenantId() throws AbstractQingIntegratedException, ResourceManagementException {
        String tenantId = this.qingContext.getTenantId();
        try {
            int userFreeFileSize = this.getUserFreeFileSize();
            return this.fileResourceDao.findSumTenantUseFileSizeByTenantId(tenantId, 0x100000L * (long)userFreeFileSize);
        }
        catch (SQLException e) {
            throw new ResourceManagementException(e);
        }
    }

    public void insert(FileResourcePO fileResource) throws AbstractQingIntegratedException, ResourceManagementException {
        if (this.tx.isInTX()) {
            try {
                this.fileResourceDao.insert(fileResource);
            }
            catch (SQLException e) {
                throw new ResourceManagementException(e);
            }
            return;
        }
        try {
            this.tx.beginRequired();
            this.fileResourceDao.insert(fileResource);
        }
        catch (AbstractQingIntegratedException e) {
            this.tx.markRollback();
            throw e;
        }
        catch (SQLException e) {
            this.tx.markRollback();
            throw new ResourceManagementException(e);
        }
        finally {
            this.tx.end();
        }
    }

    public BigDecimal findPaySizeByTenantId() throws AbstractQingIntegratedException, ResourceManagementException {
        int licenseStorageSize = 0;
        try {
            licenseStorageSize = this.getResourceInfoDomain().getLicenseStorageSize();
        }
        catch (SQLException e) {
            throw new ResourceManagementException(e);
        }
        int payFileResourceSizeMB = licenseStorageSize * 1024;
        return new BigDecimal(payFileResourceSizeMB);
    }

    public void deleteFileByUserIdAndFromId(String formId) throws AbstractQingIntegratedException, ResourceManagementException {
        try {
            this.tx.beginRequired();
            this.fileResourceDao.deleteFileByUserIdAndFromId(this.qingContext.getUserId(), formId);
        }
        catch (AbstractQingIntegratedException e) {
            this.tx.markRollback();
            throw e;
        }
        catch (SQLException e) {
            this.tx.markRollback();
            throw new ResourceManagementException(e);
        }
        finally {
            this.tx.end();
        }
    }

    public List<FileResourcePO> findFileListByUserIdAndFromId(String formId) throws AbstractQingIntegratedException, ResourceManagementException {
        try {
            return this.fileResourceDao.findFileListByUserIdAndFromId(this.qingContext.getUserId(), formId);
        }
        catch (SQLException e) {
            throw new ResourceManagementException(e);
        }
    }

    public List<FileResourceVO> findResourceFileListByUserId(String sortField, String sortOrder) throws AbstractQingIntegratedException, ResourceManagementException {
        try {
            return this.fileResourceDao.findResourceFileListByUserId(this.qingContext.getUserId(), sortField, sortOrder);
        }
        catch (SQLException e) {
            throw new ResourceManagementException(e);
        }
    }

    public boolean isEnoughFileSize(long fileSizeByte) throws AbstractQingIntegratedException, ResourceManagementException {
        if (!this.getResourceInfoDomain().hasResourceManager()) {
            return true;
        }
        BigDecimal userUseSumSizeByte = this.findSumFileSizeByUserId();
        return this.isEnoughUserFileSize(userUseSumSizeByte, fileSizeByte);
    }

    public boolean isEnoughFileSize(long fileSizeByte, String userId) throws AbstractQingIntegratedException, ResourceManagementException {
        if (!this.getResourceInfoDomain().hasResourceManager()) {
            return true;
        }
        BigDecimal userUseSumSizeByte = this.findSumFileSizeByUserId(userId);
        return this.isEnoughUserFileSize(userUseSumSizeByte, fileSizeByte);
    }

    private boolean isEnoughUserFileSize(BigDecimal userUseSumSizeByte, long fileSizeByte) throws ResourceManagementException, AbstractQingIntegratedException {
        int userFreeFileSize = this.getUserFreeFileSize();
        BigDecimal userFreeSizeByte = new BigDecimal(0x100000L * (long)userFreeFileSize);
        BigDecimal userLackFileSizeAfterApply = userUseSumSizeByte.add(new BigDecimal(fileSizeByte)).subtract(userFreeSizeByte);
        if (userLackFileSizeAfterApply.compareTo(BigDecimal.ZERO) <= 0) {
            return true;
        }
        BigDecimal userApplyFileSize = new BigDecimal(fileSizeByte);
        if (userUseSumSizeByte.compareTo(userFreeSizeByte) < 0) {
            userApplyFileSize = userLackFileSizeAfterApply;
        }
        BigDecimal tenantFreeSizeByte = new BigDecimal(0L);
        BigDecimal tenantUseSumSizeByte = this.findSumTenantUseFileSizeByTenantId();
        BigDecimal tenantPaySizeByte = this.findPaySizeByTenantId().multiply(new BigDecimal(0x100000L));
        return tenantUseSumSizeByte.add(userApplyFileSize).compareTo(tenantFreeSizeByte.add(tenantPaySizeByte)) <= 0;
    }

    public void deleteFileByFileTypeSubFolderAndFileName(AbstractQingFileType fileType, String fileName) throws AbstractQingIntegratedException, ResourceManagementException {
        try {
            this.tx.beginRequired();
            this.fileResourceDao.deleteFileByFileTypeSubFolderAndFileName(this.qingContext.getUserId(), fileType.getSubFolder(), fileName);
        }
        catch (AbstractQingIntegratedException e) {
            this.tx.markRollback();
            throw e;
        }
        catch (SQLException e) {
            this.tx.markRollback();
            throw new ResourceManagementException(e);
        }
        finally {
            this.tx.end();
        }
    }
}

