/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.filesystem.manager.localimpl;

import com.kingdee.bos.qing.filesystem.manager.localimpl.AbstractFileFilter;
import com.kingdee.bos.qing.filesystem.manager.localimpl.LocalTempQingFile;
import com.kingdee.bos.qing.util.CloseUtil;
import com.kingdee.bos.qing.util.LogUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

public class DirUtil {
    public static boolean delFolder(String path, AbstractFileFilter filter) {
        DirUtil.delAllFile(path, filter);
        File file = new File(path);
        return file.delete();
    }

    public static boolean delOverdueFileAndCacheOthers(String folderPath, AbstractFileFilter filter) {
        boolean flag = false;
        File file = new File(folderPath);
        if (!file.exists()) {
            return flag;
        }
        if (!file.isDirectory()) {
            return flag;
        }
        String[] tempList = file.list();
        File temp = null;
        for (int i = 0; i < tempList.length; ++i) {
            temp = folderPath.endsWith(File.separator) ? new File(folderPath + tempList[i]) : new File(folderPath + File.separator + tempList[i]);
            if (temp.isFile()) {
                if (null != filter) {
                    if (filter.check(temp)) {
                        DirUtil.delFileAndLog(temp);
                    } else {
                        try {
                            LocalTempQingFile.addTempFileCache(temp.getCanonicalPath());
                        }
                        catch (IOException e) {
                            LogUtil.error(e.getMessage(), e);
                        }
                    }
                } else {
                    DirUtil.delFileAndLog(temp);
                }
            }
            if (!temp.isDirectory()) continue;
            DirUtil.delAllFile(folderPath + File.separator + tempList[i], filter);
            DirUtil.delFolder(folderPath + File.separator + tempList[i], filter);
            flag = true;
        }
        return flag;
    }

    public static boolean delAllFile(String folderPath, AbstractFileFilter filter) {
        boolean flag = false;
        File file = new File(folderPath);
        if (!file.exists()) {
            return flag;
        }
        if (!file.isDirectory()) {
            return flag;
        }
        String[] tempList = file.list();
        File temp = null;
        for (int i = 0; i < tempList.length; ++i) {
            temp = folderPath.endsWith(File.separator) ? new File(folderPath + tempList[i]) : new File(folderPath + File.separator + tempList[i]);
            if (temp.isFile()) {
                if (null != filter) {
                    if (filter.check(temp)) {
                        DirUtil.delFileAndLog(temp);
                    }
                } else {
                    DirUtil.delFileAndLog(temp);
                }
            }
            if (!temp.isDirectory()) continue;
            DirUtil.delAllFile(folderPath + File.separator + tempList[i], filter);
            DirUtil.delFolder(folderPath + File.separator + tempList[i], filter);
            flag = true;
        }
        return flag;
    }

    public static void renameTo(File oldDir, String newPath) {
        File[] childFiles;
        File newDir = new File(newPath);
        if (!newDir.exists()) {
            oldDir.renameTo(newDir);
            return;
        }
        if (newDir.isFile()) {
            return;
        }
        for (File childFile : childFiles = oldDir.listFiles()) {
            String newChildFileName = newPath + File.separator + childFile.getName();
            LogUtil.info("rename file " + childFile.getPath() + " to " + newChildFileName);
            DirUtil.renameTo(childFile, newChildFileName);
        }
    }

    private static void delFileAndLog(File file) {
        LogUtil.info("delete file " + file.getPath());
        file.delete();
    }

    public static void moveDir(String sourcePath, String newPath) throws IOException {
        DirUtil.copyDir(sourcePath, newPath);
        DirUtil.delFolder(sourcePath, null);
    }

    public static void copyDir(String sourcePath, String newPath) throws IOException {
        File file = new File(sourcePath);
        String[] filePath = file.list();
        if (!new File(newPath).exists()) {
            new File(newPath).mkdir();
        }
        for (int i = 0; i < filePath.length; ++i) {
            if (new File(sourcePath + File.separator + filePath[i]).isDirectory()) {
                DirUtil.copyDir(sourcePath + File.separator + filePath[i], newPath + File.separator + filePath[i]);
            }
            if (!new File(sourcePath + File.separator + filePath[i]).isFile()) continue;
            DirUtil.copyFile(sourcePath + File.separator + filePath[i], newPath + File.separator + filePath[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(String oldPath, String newPath) throws IOException {
        File oldFile = new File(oldPath);
        File file = new File(newPath);
        FileInputStream in = null;
        FileOutputStream out = null;
        try {
            in = new FileInputStream(oldFile);
            out = new FileOutputStream(file);
            byte[] buffer = new byte[10240];
            int readByte = 0;
            while ((readByte = in.read(buffer)) != -1) {
                out.write(buffer, 0, readByte);
            }
        }
        catch (Throwable throwable) {
            CloseUtil.close(in, out);
            throw throwable;
        }
        CloseUtil.close(in, out);
    }
}

