/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.oplog.model;

import com.kingdee.bos.qing.oplog.IOpLogConstant;
import com.kingdee.bos.qing.oplog.model.OpLogActionType;
import java.util.List;
import java.util.regex.Matcher;

public class OpLogBO {
    private String opName;
    private String opDesc;
    private String bizObjId;

    public OpLogBO(OpLogActionType opLogActionType, IOpLogConstant opLogConstant, String bizObjId, List<String> params) {
        this.build(opLogActionType, opLogConstant, bizObjId, params);
    }

    public OpLogBO(OpLogActionType opLogActionType, IOpLogConstant opLogConstant, List<String> params) {
        this.build(opLogActionType, opLogConstant, null, params);
    }

    private void build(OpLogActionType opLogActionType, IOpLogConstant opLogConstant, String bizObjId, List<String> params) {
        String customDesc = opLogConstant.getLogScene() + opLogConstant.getParamsDesc() + opLogConstant.getDirDesc();
        if (params != null && !params.isEmpty()) {
            for (int i = 1; i <= params.size(); ++i) {
                if (params.get(i - 1) == null) continue;
                customDesc = customDesc.replaceFirst("\\$param", Matcher.quoteReplacement(params.get(i - 1)));
            }
        }
        this.opName = opLogActionType.getValue();
        this.opDesc = this.opName + customDesc;
        this.bizObjId = bizObjId;
    }

    public String getOpName() {
        return this.opName;
    }

    public String getBizObjId() {
        return this.bizObjId;
    }

    public String getOpDesc() {
        return this.opDesc;
    }
}

