/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.resource.domain;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.dao.IDBExcuter;
import com.kingdee.bos.qing.common.dao.ITransactionManagement;
import com.kingdee.bos.qing.resource.domain.IResInfoManagerDomain;
import com.kingdee.bos.qing.resource.exception.MismatchResourceTypeException;
import com.kingdee.bos.qing.resource.model.ResInfoManagerType;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;

public class ResInfoManagerDomainFactory {
    private static Map<ResInfoManagerType, Constructor<? extends IResInfoManagerDomain>> RES_INFO_MANAGER_DOMAIN_CLASS_MAP = new HashMap<ResInfoManagerType, Constructor<? extends IResInfoManagerDomain>>();

    public static Map<ResInfoManagerType, Constructor<? extends IResInfoManagerDomain>> getResInfoManagerDomainClassMap() {
        return RES_INFO_MANAGER_DOMAIN_CLASS_MAP;
    }

    public static IResInfoManagerDomain createResInfoManagerDomain(QingContext qingContext, IDBExcuter dbExcuter, ITransactionManagement tx, ResInfoManagerType resInfoManagerType) throws MismatchResourceTypeException {
        Constructor<? extends IResInfoManagerDomain> constructor = RES_INFO_MANAGER_DOMAIN_CLASS_MAP.get((Object)resInfoManagerType);
        if (constructor == null) {
            throw new MismatchResourceTypeException("can't confirm SourceType : " + resInfoManagerType.name());
        }
        try {
            return constructor.newInstance(qingContext, dbExcuter, tx);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void registerResInfoManagerDomain(ResInfoManagerType resInfoManagerType, Class<? extends IResInfoManagerDomain> clazz) {
        try {
            Constructor<? extends IResInfoManagerDomain> constructor = clazz.getConstructor(QingContext.class, IDBExcuter.class, ITransactionManagement.class);
            RES_INFO_MANAGER_DOMAIN_CLASS_MAP.put(resInfoManagerType, constructor);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }
}

