/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.util;

import com.kingdee.bos.qing.util.LogUtil;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Properties;

public class NetUtil {
    private static String LOCALIP = null;
    private static String processID = null;
    private static Boolean isOSLinux = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final String getIp() {
        if (LOCALIP != null) return LOCALIP;
        Class<NetUtil> clazz = NetUtil.class;
        synchronized (NetUtil.class) {
            if (LOCALIP != null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return LOCALIP;
            }
            try {
                Enumeration<NetworkInterface> allNetInterfaces = NetworkInterface.getNetworkInterfaces();
                InetAddress ip = null;
                block5: while (allNetInterfaces.hasMoreElements()) {
                    NetworkInterface netInterface = allNetInterfaces.nextElement();
                    Enumeration<InetAddress> addresses = netInterface.getInetAddresses();
                    while (addresses.hasMoreElements()) {
                        ip = addresses.nextElement();
                        if (!(ip instanceof Inet4Address) || ip.getHostAddress().equals("127.0.0.1")) continue;
                        LOCALIP = ip.getHostAddress();
                        continue block5;
                    }
                }
            }
            catch (SocketException e) {
                throw new RuntimeException("get LocalHost ip failed.", e);
            }
            return LOCALIP;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final String getProcessID() {
        if (processID != null) return processID;
        Class<NetUtil> clazz = NetUtil.class;
        synchronized (NetUtil.class) {
            if (processID != null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return processID;
            }
            RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
            int prossID = Integer.parseInt(runtimeMXBean.getName().split("@")[0]);
            processID = NetUtil.getIp() + "@" + prossID;
            // ** MonitorExit[var0] (shouldn't be in output)
            return processID;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isOSLinux() {
        if (isOSLinux != null) return isOSLinux;
        Class<NetUtil> clazz = NetUtil.class;
        synchronized (NetUtil.class) {
            if (isOSLinux != null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return isOSLinux;
            }
            Properties prop = System.getProperties();
            String os = prop.getProperty("os.name");
            isOSLinux = os != null && os.toLowerCase().indexOf("linux") > -1 ? Boolean.valueOf(true) : Boolean.valueOf(false);
            // ** MonitorExit[var0] (shouldn't be in output)
            return isOSLinux;
        }
    }

    public static String getLocalHostIp() {
        try {
            String localIp = InetAddress.getLocalHost().getHostAddress();
            if (localIp.equals("127.0.0.1")) {
                LogUtil.warn("current system host ip config error,qing profiler can not use 127.0.0.1 address");
                return NetUtil.getIp();
            }
            return localIp;
        }
        catch (UnknownHostException e) {
            LogUtil.error("", e);
            return null;
        }
    }
}

