/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.util;

import com.kingdee.bos.qing.util.AesCryptTools;
import com.kingdee.bos.qing.util.RsaCryptTools;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;

public class RSAUtils {
    private static final Integer RSAKEY_SIZE = 2048;
    private static final Integer AES_KEY_SIZE = 128;

    public RsaCryptTools.SecretKey generateSecretKey() throws NoSuchAlgorithmException {
        return RsaCryptTools.generateSecretKey(RSAKEY_SIZE);
    }

    public static String encryptData(String data, String publicInfoStr) throws IOException, InvalidKeySpecException, NoSuchAlgorithmException, InvalidKeyException, NoSuchPaddingException, BadPaddingException, IllegalBlockSizeException {
        String aesKey = AesCryptTools.generateSecret(AES_KEY_SIZE);
        String enData = AesCryptTools.encrypt(data, aesKey);
        String enAesKey = RsaCryptTools.encrypt(aesKey, publicInfoStr);
        return enAesKey + "," + enData;
    }

    public static String decryptData(String data, String privateInfoStr) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidKeySpecException, InvalidKeyException, BadPaddingException, IllegalBlockSizeException, UnsupportedEncodingException {
        String[] dataArr = data.split(",");
        if (dataArr.length != 2) {
            throw new IllegalArgumentException("data\u5fc5\u987b\u9017\u53f7\u5206\u5272:'\u4f7f\u7528RSA\u52a0\u5bc6AES\u7684key,\u4f7f\u7528AES\u52a0\u5bc6\u6570\u636e'");
        }
        String aesKey = RsaCryptTools.decrypt(dataArr[0], privateInfoStr);
        return AesCryptTools.decrypt(dataArr[1], aesKey);
    }
}

