/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.util;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.codec.binary.Base64;

public class StringUtils {
    public static final String EMPTY = "";
    private static Charset defaultCharset = Charset.forName("utf-8");

    public static boolean isEmpty(CharSequence cs) {
        return cs == null || cs.length() == 0;
    }

    public static boolean isNotEmpty(CharSequence cs) {
        return !StringUtils.isEmpty(cs);
    }

    public static boolean isBlank(CharSequence cs) {
        int strLen;
        if (cs == null || (strLen = cs.length()) == 0) {
            return true;
        }
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(cs.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNotBlank(CharSequence cs) {
        return !StringUtils.isBlank(cs);
    }

    public static String join(char delimiter, Collection<String> newCallIDs) {
        if (newCallIDs != null && !newCallIDs.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (String callID : newCallIDs) {
                if (sb.length() > 0) {
                    sb.append(delimiter);
                }
                sb.append(callID);
            }
            return sb.toString();
        }
        return EMPTY;
    }

    public static String join(Object[] array, char separator) {
        if (array == null) {
            return null;
        }
        return StringUtils.join(array, separator, 0, array.length);
    }

    public static String join(Object[] array, char separator, int startIndex, int endIndex) {
        if (array == null) {
            return null;
        }
        int bufSize = endIndex - startIndex;
        if (bufSize <= 0) {
            return EMPTY;
        }
        StringBuilder sb = new StringBuilder(bufSize *= (array[startIndex] == null ? 16 : array[startIndex].toString().length()) + 1);
        for (int i = startIndex; i < endIndex; ++i) {
            if (i > startIndex) {
                sb.append(separator);
            }
            if (array[i] == null) continue;
            sb.append(array[i]);
        }
        return sb.toString();
    }

    public static String[] split(String str, char separatorChar) {
        return StringUtils.splitWorker(str, separatorChar, false);
    }

    private static String[] splitWorker(String str, char separatorChar, boolean preserveAllTokens) {
        if (str == null) {
            return null;
        }
        int len = str.length();
        if (len == 0) {
            return new String[0];
        }
        ArrayList<String> list = new ArrayList<String>();
        int i = 0;
        int start = 0;
        boolean match = false;
        boolean lastMatch = false;
        while (i < len) {
            if (str.charAt(i) == separatorChar) {
                if (match || preserveAllTokens) {
                    list.add(str.substring(start, i));
                    match = false;
                    lastMatch = true;
                }
                start = ++i;
                continue;
            }
            lastMatch = false;
            match = true;
            ++i;
        }
        if (match || preserveAllTokens && lastMatch) {
            list.add(str.substring(start, i));
        }
        return list.toArray(new String[list.size()]);
    }

    public static String encodeToBase64String(byte[] input) {
        if (input == null) {
            return null;
        }
        return Base64.encodeBase64String((byte[])input);
    }

    public static String encodeToBase64String(String input) {
        if (input == null) {
            return null;
        }
        return Base64.encodeBase64String((byte[])StringUtils.getBytes(input));
    }

    public static String decodeBase64ToString(String input) {
        if (input == null) {
            return null;
        }
        return StringUtils.decode(Base64.decodeBase64((String)input));
    }

    public static byte[] decodeBase64ToByteArray(String input) {
        if (input == null) {
            return null;
        }
        return Base64.decodeBase64((String)input);
    }

    public static byte[] getBytes(String input) {
        if (input == null) {
            return null;
        }
        return input.getBytes(defaultCharset);
    }

    public static String decode(byte[] input) {
        if (input == null) {
            return null;
        }
        return new String(input, defaultCharset);
    }
}

