/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.core.charttype.longer;

import com.kingdee.bos.qing.core.charttype.longer.AbstractChartTypeCoupler;
import com.kingdee.bos.qing.core.flattening.longer.AbstractFlatBuilder;
import com.kingdee.bos.qing.core.flattening.longer.FlatBuilderForStackBar;
import com.kingdee.bos.qing.core.model.analysis.common.AnalyticalField;
import com.kingdee.bos.qing.core.model.analysis.longer.AnalyticalModel;
import com.kingdee.bos.qing.core.model.analysis.longer.MarkFieldSet;
import com.kingdee.bos.qing.core.model.analysis.longer.ModelAssistantStructure;
import java.util.ArrayList;

class StackBar
extends AbstractChartTypeCoupler {
    StackBar() {
    }

    @Override
    public ModelAssistantStructure parseAssistantStructure(AnalyticalModel model) {
        boolean isAxisMeasureAtRow;
        ArrayList<AnalyticalField> measureFields = new ArrayList<AnalyticalField>();
        ArrayList<AnalyticalField> rowDimensionFields = new ArrayList<AnalyticalField>();
        this.parseFields(model.getRow(), rowDimensionFields, measureFields);
        ArrayList<AnalyticalField> columnDimensionFields = new ArrayList<AnalyticalField>();
        if (measureFields.size() > 0) {
            this.parseFields(model.getColumn(), columnDimensionFields, null);
            isAxisMeasureAtRow = true;
        } else {
            this.parseFields(model.getColumn(), columnDimensionFields, measureFields);
            isAxisMeasureAtRow = measureFields.size() <= 0 && rowDimensionFields.size() <= 0;
        }
        int measureFieldCountForAxis = measureFields.size();
        ArrayList<AnalyticalField> cellDimensionFields = new ArrayList<AnalyticalField>();
        MarkFieldSet markFieldSet = model.getMarkFieldSet();
        StackBar.makeSureMarkTypeExist(markFieldSet);
        StackBar.makeSureMarkTypeAppointed(markFieldSet, "color", "dimension");
        StackBar.makeSureMarkTypeSingle(markFieldSet, "color", "dimension");
        this.parseFields(markFieldSet, cellDimensionFields, measureFields);
        ModelAssistantStructure mas = new ModelAssistantStructure();
        mas.setRowDimensionFields(rowDimensionFields);
        mas.setColumnDimensionFields(columnDimensionFields);
        mas.setCellDimensionFields(cellDimensionFields);
        mas.setMeasureFields(measureFields);
        mas.setMeasureFieldCountForCell(measureFields.size());
        if (isAxisMeasureAtRow) {
            mas.setMeasureFieldCountForXYAxis(0, measureFieldCountForAxis);
        } else {
            mas.setMeasureFieldCountForXYAxis(measureFieldCountForAxis, 0);
        }
        mas.setAxisMeasureAtRowAndColumn(isAxisMeasureAtRow, !isAxisMeasureAtRow);
        return mas;
    }

    @Override
    public AbstractFlatBuilder createFlatBuilder() {
        return new FlatBuilderForStackBar();
    }
}

