/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.core.flattening.common;

import com.kingdee.bos.qing.common.i18n.II18nContext;
import com.kingdee.bos.qing.core.flattening.common.Palette;
import com.kingdee.bos.qing.core.i18n.Messages;
import com.kingdee.bos.qing.core.model.exhibition.common.Legends;
import com.kingdee.bos.qing.core.model.exhibition.common.chart.AbstractChartModel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DiscreteColorConfirmer {
    private String[] _palette;
    private II18nContext _i18nContext;
    private List<AbstractChartModel.IOrderingSupported> _itemList = new ArrayList<AbstractChartModel.IOrderingSupported>();
    private Map<Object, String> _colorMap = new HashMap<Object, String>();
    private Map<Object, String> _textMap = new HashMap<Object, String>();
    private String _title;
    private boolean _isLegendLonelyIgnored;
    private float _translucence = 1.0f;

    public DiscreteColorConfirmer(String[] colors, II18nContext i18nContext) {
        this._palette = colors;
        this._i18nContext = i18nContext;
    }

    public DiscreteColorConfirmer(String skinName, II18nContext i18nContext, Palette.PaletteType chartType) {
        this(Palette.getPalette(skinName, chartType), i18nContext);
    }

    public void setTitle(String title) {
        this._title = title;
    }

    public String getTitle() {
        return this._title;
    }

    public String getColor(AbstractChartModel.IOrderingSupported object, String text) {
        Object value = object.getOrderingValue();
        String color = this._colorMap.get(value);
        if (color == null) {
            this._itemList.add(object);
            int paletteIndex = this._colorMap.size() % this._palette.length;
            color = this._palette[paletteIndex];
            color = this.makeTranslucence(color);
            this._colorMap.put(value, color);
            this._textMap.put(value, text);
        }
        return color;
    }

    public void setTranslucence(float alpha) {
        this._translucence = alpha < 0.0f ? 0.0f : (alpha > 1.0f ? 1.0f : alpha);
    }

    public void setLegendLonelyIgnored(boolean isLonelyIgnored) {
        this._isLegendLonelyIgnored = isLonelyIgnored;
    }

    public boolean isLegendIgnored() {
        return this._isLegendLonelyIgnored && this._itemList.size() < 2;
    }

    public Legends.DiscreteColorLegend createLegend() {
        int displayCount;
        Legends.DiscreteColorLegend legend = new Legends.DiscreteColorLegend();
        int count = this._itemList.size();
        int othersCount = count - (displayCount = Math.min(count, this._palette.length));
        if (othersCount == 1) {
            othersCount = 0;
            displayCount = count;
        }
        for (int i = 0; i < displayCount; ++i) {
            AbstractChartModel.IOrderingSupported item = this._itemList.get(i);
            Object key = item.getOrderingValue();
            String color = this._colorMap.get(key);
            String text = this._textMap.get(key);
            legend.add(color, text);
        }
        legend.setOthersCount(othersCount);
        String othersText = null;
        if (othersCount > 0) {
            othersText = Messages.getLangMessage(this._i18nContext, "otherItemsInLegend", "\u5176\u5b83#1\u9879");
            othersText = othersText.replace("#1", String.valueOf(othersCount));
        }
        legend.setOthersInfo(othersText);
        return legend;
    }

    private String makeTranslucence(String color) {
        return this._translucence == 1.0f ? color : DiscreteColorConfirmer.createColorWithAlpha(color, this._translucence);
    }

    public static String createColorWithAlpha(String color, float alpha) {
        if (!color.startsWith("#") || color.length() != 7) {
            return color;
        }
        String hexRed = color.substring(1, 3);
        String hexGreen = color.substring(3, 5);
        String hexBlue = color.substring(5, 7);
        int red = Integer.parseInt(hexRed, 16);
        int green = Integer.parseInt(hexGreen, 16);
        int blue = Integer.parseInt(hexBlue, 16);
        StringBuilder sb = new StringBuilder();
        sb.append("rgba(");
        sb.append(red);
        sb.append(",");
        sb.append(green);
        sb.append(",");
        sb.append(blue);
        sb.append(",");
        sb.append(alpha);
        sb.append(")");
        return sb.toString();
    }
}

