/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.core.flattening.common;

import com.kingdee.bos.qing.common.i18n.II18nContext;
import com.kingdee.bos.qing.core.engine.Aggregator;
import com.kingdee.bos.qing.core.engine.CompositeKey;
import com.kingdee.bos.qing.core.engine.Cuboid;
import com.kingdee.bos.qing.core.engine.sort.CommonComparator;
import com.kingdee.bos.qing.core.flattening.common.Scope;
import com.kingdee.bos.qing.core.model.analysis.common.AnalyticalField;
import com.kingdee.bos.qing.core.model.analysis.common.pie.LegendOrderMode;
import com.kingdee.bos.qing.core.model.exhibition.common.chart.AbstractChartModel;
import com.kingdee.bos.qing.core.model.exhibition.common.chart.TreeChartModel;
import com.kingdee.bos.qing.core.model.meta.DataType;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TreeChartHandler {
    private II18nContext _i18nContext;
    private boolean _isHideNegative;
    private LegendOrderMode _legendOrderMode = LegendOrderMode.AUTO;
    private AnalyticalField _sizeField;
    private int _sizeMeasureIndex = -1;
    private AnalyticalField _continuousColorField;
    private Scope _continuousColorScope;
    private AnalyticalField _discreteColorField;
    private int _colorDimensionIndex = -1;
    private Map<Object, String[]> _memberToColor;
    private Cuboid _cuboid;
    private AbstractRelative _relative;
    private boolean _isCutTooLarge;

    public boolean isCutTooLarge() {
        return this._isCutTooLarge;
    }

    public void setI18nContext(II18nContext i18nCtx) {
        this._i18nContext = i18nCtx;
    }

    public void setHandlerRelative(AbstractRelative relative) {
        this._relative = relative;
    }

    public void setChartProperty(boolean isHideNegative, LegendOrderMode legendOrderMode) {
        this._isHideNegative = isHideNegative;
        this._legendOrderMode = legendOrderMode;
    }

    public void setCuboid(Cuboid cuboid) {
        this._cuboid = cuboid;
    }

    public void setSizeDefine(AnalyticalField field, int measuzeIdx) {
        this._sizeField = field;
        this._sizeMeasureIndex = measuzeIdx;
    }

    public void setContinueColorDefine(AnalyticalField field, Scope scope) {
        this.intContinueColorDefine(field, scope);
        this.initDiscreteColorDefine(null, -1, null);
    }

    private void intContinueColorDefine(AnalyticalField field, Scope scope) {
        this._continuousColorField = field;
        this._continuousColorScope = scope;
    }

    public void setDiscreteColorDefine(AnalyticalField field, int dimensionIdx) {
        this.initDiscreteColorDefine(field, dimensionIdx, new HashMap<Object, String[]>());
        this.intContinueColorDefine(null, null);
    }

    private void initDiscreteColorDefine(AnalyticalField field, int dimensionIdx, Map<Object, String[]> memberToColor) {
        this._discreteColorField = field;
        this._colorDimensionIndex = dimensionIdx;
        this._memberToColor = memberToColor;
    }

    public AnalyticalField getContinuousColorField() {
        return this._continuousColorField;
    }

    private boolean isColorMeasureImportant() {
        return !this._continuousColorField.isSame(this._sizeField);
    }

    private boolean isColorDimensionImportant() {
        return this._colorDimensionIndex < 0;
    }

    private RtNode buildTree() {
        int colorMeasureIdx = this.searchColorMeasureIndex();
        PropertyValueCollecter colorValues = new PropertyValueCollecter();
        RtNode root = new RtNode(null);
        int dimensions = this._cuboid.getDimensionFields().size();
        int count = 0;
        Iterator<CompositeKey> itKeys = this._cuboid.createDimensionKeyIterator();
        while (itKeys.hasNext()) {
            Object colorValue;
            Aggregator[] aggs;
            Aggregator aggSize;
            BigDecimal sizeValue;
            CompositeKey dimKey = itKeys.next();
            if (this._relative.isSubtotal(dimKey) || (sizeValue = (aggSize = (aggs = this._cuboid.getCellAggregators(dimKey))[this._sizeMeasureIndex]).getNumberValue()) == null || this._isHideNegative && sizeValue.signum() == -1) continue;
            if (count > this._relative.getItemLimited()) {
                this._isCutTooLarge = true;
                break;
            }
            ++count;
            RtNode node = root;
            for (int i = 0; i < dimensions; ++i) {
                Object member = dimKey.getMember(i);
                node = node.searchChild(member);
                if (this._colorDimensionIndex != i) continue;
                colorValues.addValue(member);
                node.setColorValue(member);
            }
            node.setSizeValue(sizeValue);
            if (colorMeasureIdx < 0) continue;
            Aggregator aggColor = aggs[colorMeasureIdx];
            if (this._continuousColorField != null) {
                colorValue = aggColor.getNumberValue();
                node.setColorValue(colorValue);
                this._continuousColorScope.join((BigDecimal)colorValue);
                continue;
            }
            if (this._discreteColorField == null || this._colorDimensionIndex >= 0) continue;
            colorValue = PropertyValueCollecter.getPropertyValue(aggColor);
            colorValues.addValue(colorValue);
            node.setColorValue(colorValue);
        }
        this.sortSubTree(root);
        if (this.isLegendOrderBySize()) {
            this.allocateColorBySize(root);
        } else {
            this.allocateColor(colorValues);
        }
        return root;
    }

    private int searchColorMeasureIndex() {
        List<AnalyticalField> measureFields = this._cuboid.getMeasureFields();
        for (int i = 0; i < measureFields.size(); ++i) {
            AnalyticalField field = measureFields.get(i);
            if (!field.isSame(this._discreteColorField) && !field.isSame(this._continuousColorField)) continue;
            return i;
        }
        return -1;
    }

    private boolean isLegendOrderBySize() {
        if (this._discreteColorField != null && this._colorDimensionIndex == 0) {
            if (this._legendOrderMode == LegendOrderMode.VALUE) {
                return true;
            }
            if (this._legendOrderMode == LegendOrderMode.NAME) {
                return false;
            }
            return this._discreteColorField.getDataType() != DataType.DATE;
        }
        return false;
    }

    private void allocateColor(PropertyValueCollecter pvc) {
        Set<Object> colorValues = pvc.getSingleValues();
        Object multiValue = pvc.getMultiValue();
        if (!colorValues.isEmpty()) {
            List<AbstractChartModel.IOrderingSupported> colorValueWraps = AbstractChartModel.toOrderedWrapList(colorValues, this._i18nContext.getLanManager().getLocale());
            for (AbstractChartModel.IOrderingSupported item : colorValueWraps) {
                Object member = item.getOrderingValue();
                String text = this._relative.formatValue(member, this._discreteColorField);
                String color = this._relative.makeDiscreteColorValue(item, text);
                this._memberToColor.put(member, new String[]{text, color});
            }
        }
        if (multiValue != null) {
            AbstractChartModel.OrderingObject item = new AbstractChartModel.OrderingObject(multiValue);
            String text = "*";
            String color = this._relative.makeDiscreteColorValue(item, text);
            this._memberToColor.put(multiValue, new String[]{text, color});
        }
    }

    private void allocateColorBySize(RtNode root) {
        List<RtNode> topLevelNodes = root.getSortedChildren();
        if (topLevelNodes != null) {
            for (RtNode node : topLevelNodes) {
                Object member = node.getColorValue();
                AbstractChartModel.OrderingObject item = new AbstractChartModel.OrderingObject(member);
                String text = this._relative.formatValue(member, this._discreteColorField);
                String color = this._relative.makeDiscreteColorValue(item, text);
                this._memberToColor.put(member, new String[]{text, color});
            }
        }
    }

    private void sortSubTree(RtNode node) {
        if (!node.hasChildren()) {
            return;
        }
        BigDecimal subTotal = null;
        ArrayList<RtNode> toSort = new ArrayList<RtNode>();
        Iterator<RtNode> itNodes = node.getPreSortChildren();
        while (itNodes.hasNext()) {
            RtNode child = itNodes.next();
            this.sortSubTree(child);
            toSort.add(child);
            BigDecimal value = child.getSizeValue();
            if (value == null) continue;
            if (subTotal == null) {
                subTotal = value.abs();
                continue;
            }
            subTotal = subTotal.add(value.abs());
        }
        node.setSizeValue(subTotal);
        RtNode[] nodes = toSort.toArray(new RtNode[0]);
        Arrays.sort(nodes, new MyComparator());
        List<RtNode> sorted = Arrays.asList(nodes);
        node.setSortedChildren(sorted);
    }

    public TreeChartModel makeChartModel() {
        TreeChartModel chart = new TreeChartModel();
        TreeChartModel.TreeChartNode treeChartRoot = new TreeChartModel.TreeChartNode();
        chart.setRoot(treeChartRoot);
        if (this._sizeField != null && this._sizeMeasureIndex >= 0) {
            List<TreeChartModel.TreeChartNode> tcns;
            RtNode root = this.buildTree();
            if (root.hasChildren()) {
                tcns = this.makeNode(root.getSortedChildren(), 0);
                ArrayList<String> dimensionTitles = new ArrayList<String>();
                for (AnalyticalField dimensionField : this._cuboid.getDimensionFields()) {
                    dimensionTitles.add(dimensionField.getTitle(this._i18nContext));
                }
                chart.setDimensionTitle(dimensionTitles);
            } else {
                TreeChartModel.TreeChartNode tcn = new TreeChartModel.TreeChartNode();
                this.makeLeafNode(root, tcn);
                tcns = new ArrayList<TreeChartModel.TreeChartNode>(1);
                tcns.add(tcn);
            }
            treeChartRoot.setChildren(tcns);
            if (this._continuousColorField == null && this._discreteColorField == null) {
                treeChartRoot.setColor(this._relative.getDefaultColor());
            }
            chart.setMeasureTitle(this._sizeField.getTitle(this._i18nContext));
            chart.setMeasureFormat(this._sizeField.getNumberFormat());
            if (this._continuousColorField != null && this.isColorMeasureImportant()) {
                chart.addDetailCaption(this._continuousColorField.getTitle(this._i18nContext), false);
            }
            if (this._discreteColorField != null && this.isColorDimensionImportant()) {
                chart.addDetailCaption(this._discreteColorField.getTitle(this._i18nContext), true);
            }
        }
        return chart;
    }

    private List<TreeChartModel.TreeChartNode> makeNode(List<RtNode> sorted, int dimensionLevel) {
        AnalyticalField dimensionField = this._cuboid.getDimensionFields().get(dimensionLevel);
        ArrayList<TreeChartModel.TreeChartNode> tcns = new ArrayList<TreeChartModel.TreeChartNode>();
        for (int i = 0; i < sorted.size(); ++i) {
            RtNode node = sorted.get(i);
            TreeChartModel.TreeChartNode tcn = new TreeChartModel.TreeChartNode();
            String text = this._relative.formatValue(node.getMember(), dimensionField);
            String value = this._relative.encodeCategoryValue(node.getMember(), text);
            tcn.setDimension(text, value);
            if (this._memberToColor != null && this._colorDimensionIndex == dimensionLevel) {
                this.makeNodeDiscreteColor(node, tcn);
            }
            if (node.hasChildren()) {
                List<TreeChartModel.TreeChartNode> subTcns = this.makeNode(node.getSortedChildren(), dimensionLevel + 1);
                tcn.setChildren(subTcns);
            } else {
                this.makeLeafNode(node, tcn);
            }
            tcns.add(tcn);
        }
        return tcns;
    }

    private void makeLeafNode(RtNode node, TreeChartModel.TreeChartNode tcn) {
        BigDecimal measure = node.getSizeValue();
        tcn.setMeasure(measure == null ? null : measure.toString());
        if (this._continuousColorScope != null) {
            BigDecimal colorValue = (BigDecimal)node.getColorValue();
            String continuousColor = this._relative.makeContinuousColorValue(colorValue, this._continuousColorScope, this._continuousColorField);
            tcn.setColor(continuousColor);
            if (this.isColorMeasureImportant()) {
                String colorText = this._relative.formatNumber(colorValue, this._continuousColorField);
                tcn.addDetailTexts(colorText);
            }
        } else if (this._memberToColor != null && this._colorDimensionIndex < 0) {
            String text = this.makeNodeDiscreteColor(node, tcn);
            if (this.isColorDimensionImportant()) {
                tcn.addDetailTexts(text);
            }
        }
    }

    private String makeNodeDiscreteColor(RtNode node, TreeChartModel.TreeChartNode tcn) {
        Object member = node.getColorValue();
        String[] wrap = this._memberToColor.get(member);
        String text = null;
        if (wrap != null) {
            text = wrap[0];
            String color = wrap[1];
            tcn.setColor(color);
        }
        return text;
    }

    private static class RtNode {
        private Object _member;
        private BigDecimal _sizeValue;
        private Object _colorValue;
        private Map<Object, RtNode> _children;
        private List<RtNode> _sortedChildren;

        public RtNode(Object member) {
            this._member = member;
        }

        public Object getMember() {
            return this._member;
        }

        public void setSizeValue(BigDecimal value) {
            this._sizeValue = value;
        }

        public BigDecimal getSizeValue() {
            return this._sizeValue;
        }

        public void setColorValue(Object value) {
            this._colorValue = value;
        }

        public Object getColorValue() {
            return this._colorValue;
        }

        public RtNode searchChild(Object member) {
            RtNode child;
            if (this._children == null) {
                this._children = new HashMap<Object, RtNode>();
            }
            if ((child = this._children.get(member)) == null) {
                child = new RtNode(member);
                this._children.put(member, child);
            }
            return child;
        }

        public boolean hasChildren() {
            return this._children != null && !this._children.isEmpty();
        }

        public Iterator<RtNode> getPreSortChildren() {
            return this._children.values().iterator();
        }

        public void setSortedChildren(List<RtNode> sorted) {
            this._sortedChildren = sorted;
        }

        public List<RtNode> getSortedChildren() {
            return this._sortedChildren;
        }
    }

    private class MyComparator
    implements Comparator<RtNode> {
        private CommonComparator _comparer;

        private MyComparator() {
        }

        @Override
        public int compare(RtNode o1, RtNode o2) {
            int c;
            BigDecimal v1 = o1.getSizeValue();
            BigDecimal v2 = o2.getSizeValue();
            if (v1 == null) {
                c = v2 == null ? 0 : -1;
            } else {
                v1 = v1.abs();
                if (v2 == null) {
                    c = 1;
                } else {
                    v2 = v2.abs();
                    c = v1.compareTo(v2);
                }
            }
            if (c == 0) {
                if (this._comparer == null) {
                    this._comparer = new CommonComparator(TreeChartHandler.this._i18nContext.getLanManager().getLocale());
                }
                c = this._comparer.compare((Comparable)o1.getMember(), (Comparable)o2.getMember());
            } else {
                c = -c;
            }
            return c;
        }
    }

    private static class PropertyValueCollecter {
        private static final String MULTIVALUE = "";
        private Set<Object> _singleValues = new HashSet<Object>();
        private Object _multiValue;

        private PropertyValueCollecter() {
        }

        public void addValue(Object value) {
            if (value == MULTIVALUE) {
                this._multiValue = MULTIVALUE;
            } else {
                this._singleValues.add(value);
            }
        }

        public Set<Object> getSingleValues() {
            return this._singleValues;
        }

        public Object getMultiValue() {
            return this._multiValue;
        }

        public static Object getPropertyValue(Aggregator agg) {
            Aggregator.Properties p = (Aggregator.Properties)agg;
            if (p.getValueCount() == 1) {
                return p.getSingleValue();
            }
            return MULTIVALUE;
        }
    }

    public static abstract class AbstractRelative {
        public abstract String formatValue(Object var1, AnalyticalField var2);

        public abstract String formatNumber(BigDecimal var1, AnalyticalField var2);

        public abstract String encodeCategoryValue(Object var1, String var2);

        public abstract String getDefaultColor();

        public abstract String makeDiscreteColorValue(AbstractChartModel.IOrderingSupported var1, String var2);

        public abstract String makeContinuousColorValue(BigDecimal var1, Scope var2, AnalyticalField var3);

        public boolean isSubtotal(CompositeKey dimKey) {
            return false;
        }

        public int getItemLimited() {
            return 10000;
        }
    }
}

