/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.core.flattening.longer;

import com.kingdee.bos.qing.core.engine.Aggregator;
import com.kingdee.bos.qing.core.engine.CompositeKey;
import com.kingdee.bos.qing.core.engine.Cuboid;
import com.kingdee.bos.qing.core.engine.SubCuboidKey;
import com.kingdee.bos.qing.core.exception.EnvCeilingException;
import com.kingdee.bos.qing.core.flattening.common.Scope;
import com.kingdee.bos.qing.core.flattening.longer.AbstractFlatBuilder;
import com.kingdee.bos.qing.core.flattening.longer.AbstractFlatBuilderForLineSimilar;
import com.kingdee.bos.qing.core.flattening.longer.AbstractMarkParser;
import com.kingdee.bos.qing.core.flattening.longer.CuboidSpliter;
import com.kingdee.bos.qing.core.model.analysis.common.AnalyticalField;
import com.kingdee.bos.qing.core.model.analysis.longer.ModelAssistantStructure;
import com.kingdee.bos.qing.core.model.exhibition.common.chart.AbstractChartModel;
import com.kingdee.bos.qing.core.model.exhibition.common.chart.AbstractNormalChartModel;
import com.kingdee.bos.qing.core.model.exhibition.common.chart.MultiSeriesChartModel;
import com.kingdee.bos.qing.core.model.exhibition.longer.ICell;
import com.kingdee.bos.qing.core.model.exhibition.longer.cell.ChartCell;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class FlatBuilderForArea
extends AbstractFlatBuilderForLineSimilar {
    private CuboidSpliter _cuboidSpliter;
    private Scope _unifiedAxisScope = new Scope();
    private Set<Object> _seriesCollection = new HashSet<Object>();
    private int _estimatedHeapSizePerCell;

    @Override
    protected AbstractMarkParser createMarkParser() {
        return new MarkParserForArea(this.getModelAssistantStructure());
    }

    private MarkParserForArea getMyMarkParser() {
        return (MarkParserForArea)this.getMarkParser();
    }

    @Override
    protected float getPaletteTranslucenceAlpha() {
        return 0.7f;
    }

    @Override
    protected void beforeFlatCuboid() {
        this._cuboidSpliter = this.createCuboidSpliter();
        ModelAssistantStructure mas = this.getModelAssistantStructure();
        int count = mas.getCellDimensionFieldCount();
        if (this.getMyMarkParser().hasColorField()) {
            this.setCategoryField(count == 2 ? mas.getCellDimensionFields().get(0) : null);
        } else {
            this.setCategoryField(count == 1 ? mas.getCellDimensionFields().get(0) : null);
        }
        if (this.getMyMarkParser().isStackByMeasure()) {
            int measureCount = this.getModelAssistantStructure().getMeasureFieldCountForAxis();
            for (int i = 0; i < measureCount; ++i) {
                this._seriesCollection.add(this.getMeasureTitle(i));
            }
        }
    }

    @Override
    protected Iterator<CompositeKey> prepareIteratorForFlatCuboid(Cuboid cuboid, SubCuboidKey subCuboidTag) throws EnvCeilingException {
        this._cuboidSpliter.standardizingCuboid(cuboid, subCuboidTag, new CuboidSpliter.AbstractDoMoreHandler(){

            @Override
            public void forDimension(CompositeKey dimKeyInCell) {
                Object categoryValue = FlatBuilderForArea.this.getCategoryValue(dimKeyInCell);
                FlatBuilderForArea.this.collectCategory(categoryValue);
                if (FlatBuilderForArea.this.getMyMarkParser().hasColorField()) {
                    Object value = dimKeyInCell.getMember(dimKeyInCell.getMemberCount() - 1);
                    FlatBuilderForArea.this._seriesCollection.add(value);
                }
            }
        });
        int displayMeasureCount = this.getModelAssistantStructure().getMeasureFieldCountForCell();
        int categoryCount = this.getCategorySize();
        this._estimatedHeapSizePerCell = ChartCell.HEAPZISE_OVERHEAD + MultiSeriesChartModel.HEAPZISE_OVERHEAD + AbstractNormalChartModel.Series.HEAPZISE_OVERHEAD * displayMeasureCount + AbstractNormalChartModel.Category.HEAPZISE_OVERHEAD * categoryCount + AbstractNormalChartModel.Node.HEAPZISE_OVERHEAD * displayMeasureCount * categoryCount;
        return this._cuboidSpliter.getStandardizedCube(subCuboidTag).keySet().iterator();
    }

    @Override
    protected void flatCubeCell(SubCuboidKey subCuboidTag, boolean[] whichMeasureToDraw, CompositeKey dimKey) {
        int measureIndex = this.getDrawingMeasureCount() == 1 ? 0 : -1;
        AbstractFlatBuilder.GroupItem groupItem = this.createGroupItem(dimKey, subCuboidTag, measureIndex);
        this.mapping(dimKey, groupItem, -1);
    }

    @Override
    protected void afterFlatCuboid() {
        this.makeSureDateContinuous();
        this.makeCommonChart();
        this.addAllSeriesColors();
        if (this.getMyMarkParser().hasColorField()) {
            this.confirmDiscreteColorLegendTitlebyField(this.getMyMarkParser().getColorField());
        } else if (this.getMyMarkParser().isStackByMeasure()) {
            this.confirmDiscreteColorLegendTitlebyField(null);
        }
    }

    private void addAllSeriesColors() {
        if (!this.getMyMarkParser().hasColorField()) {
            return;
        }
        List<AbstractChartModel.IOrderingSupported> sortedList = AbstractChartModel.toOrderedWrapList(this._seriesCollection, this.getI18nCtx().getLanManager().getLocale());
        for (AbstractChartModel.IOrderingSupported seriesValue : sortedList) {
            String seriesName = this.formatValue(seriesValue.getOrderingValue(), this.getMyMarkParser().getColorField());
            this.makeDiscreteColorValue(seriesValue, seriesName);
        }
    }

    @Override
    protected int getCellHeapSize() {
        return this._estimatedHeapSizePerCell;
    }

    @Override
    protected ICell createCell(AbstractFlatBuilder.GroupItem item) {
        MultiSeriesChartModel chart = new MultiSeriesChartModel();
        int categoryCount = this.getCategorySize();
        BigDecimal[][] stackScope = new BigDecimal[categoryCount][2];
        for (int i = 0; i < categoryCount; ++i) {
            stackScope[i][0] = BigDecimal.ZERO;
            stackScope[i][1] = BigDecimal.ZERO;
        }
        int measureCount = this.getModelAssistantStructure().getMeasureFieldCountForAxis();
        boolean isStackByMeasure = this.getMyMarkParser().isStackByMeasure();
        boolean hasColorField = this.getMyMarkParser().hasColorField();
        AnalyticalField colorField = this.getMyMarkParser().getColorField();
        ArrayList<Object> seriesValues = null;
        if (isStackByMeasure) {
            for (int i = 0; i < measureCount; ++i) {
                String seriesName = this.getMeasureTitle(i);
                AbstractNormalChartModel.Series series = chart.addSeries(seriesName);
                series.setOrderingValue(i);
                String color = this.makeDiscreteColorValue(series, seriesName);
                series.setColor(color);
                for (int j = 0; j < categoryCount; ++j) {
                    series.getNodes().add(null);
                }
            }
        } else {
            seriesValues = new ArrayList<Object>();
        }
        Map<CompositeKey, Cuboid> rowColPartOfCuboid = this._cuboidSpliter.getStandardizedCube(item.getSubCuboidTag());
        CompositeKey dimKey = item.getDimensionKey();
        Cuboid cuboidInCell = rowColPartOfCuboid.get(dimKey);
        Iterator<CompositeKey> it = cuboidInCell.createDimensionKeyIterator();
        while (it.hasNext()) {
            int seriesIdx;
            AbstractNormalChartModel.Series series;
            CompositeKey dimKeyInCell = it.next();
            Aggregator[] aggregators = cuboidInCell.getCellAggregators(dimKeyInCell);
            Object categoryValue = this.getCategoryValue(dimKeyInCell);
            int categoryIndex = this.getCategoryIndex(categoryValue);
            if (isStackByMeasure) {
                for (int i = 0; i < measureCount; ++i) {
                    Aggregator aggregator = aggregators[i];
                    BigDecimal measureValue = aggregator.getNumberValue();
                    AbstractNormalChartModel.Node node = this.createNode(measureValue, i);
                    series = chart.getSeries(i);
                    series.getNodes().set(categoryIndex, node);
                    this.stack(measureValue, stackScope[categoryIndex]);
                }
                continue;
            }
            String seriesFieldValueText = null;
            Object seriesFieldValue = null;
            if (hasColorField) {
                seriesFieldValue = dimKeyInCell.getMember(dimKeyInCell.getMemberCount() - 1);
                seriesFieldValueText = this.formatValue(seriesFieldValue, colorField);
            }
            if ((seriesIdx = seriesValues.indexOf(seriesFieldValue)) < 0) {
                seriesIdx = seriesValues.size();
                seriesValues.add(seriesFieldValue);
                String seriesName = this.getMeasureTitle(0);
                series = chart.addSeries(seriesName);
                series.setOrderingValue(seriesFieldValue);
                series.setSeriesFieldValueText(FlatBuilderForArea.encodeCategoryValue(seriesFieldValue, seriesFieldValueText), seriesFieldValueText);
                if (hasColorField) {
                    String color = this.makeDiscreteColorValue(series, seriesFieldValueText);
                    series.setColor(color);
                } else {
                    series.setColor(this.getDefaultColorValue());
                }
                for (int j = 0; j < categoryCount; ++j) {
                    series.getNodes().add(null);
                }
            }
            Aggregator aggregator = aggregators[0];
            BigDecimal measureValue = aggregator.getNumberValue();
            AbstractNormalChartModel.Node node = this.createNode(measureValue, 0);
            AbstractNormalChartModel.Series series2 = chart.getSeries(seriesIdx);
            series2.getNodes().set(categoryIndex, node);
            this.stack(measureValue, stackScope[categoryIndex]);
        }
        chart.sortSeries(this.getI18nCtx().getLanManager().getLocale());
        for (int i = 0; i < categoryCount; ++i) {
            this._unifiedAxisScope.join(stackScope[i][0]);
            this._unifiedAxisScope.join(stackScope[i][1]);
        }
        this.cutTooLargeChart(chart);
        ChartCell cell = new ChartCell();
        cell.setChart(chart);
        return cell;
    }

    private AbstractNormalChartModel.Node createNode(BigDecimal measureValue, int measureIndex) {
        AbstractNormalChartModel.Node node = new AbstractNormalChartModel.Node();
        node.setValue(measureValue == null ? "" : measureValue.toString());
        node.setText(this.formatNumber(measureValue, this.getModelAssistantStructure().getMeasureField(measureIndex)));
        return node;
    }

    private void stack(BigDecimal measureValue, BigDecimal[] valueStack) {
        if (measureValue != null) {
            if (measureValue.compareTo(BigDecimal.ZERO) > 0) {
                valueStack[0] = valueStack[0].add(measureValue);
            } else {
                valueStack[1] = valueStack[1].add(measureValue);
            }
        }
    }

    @Override
    protected void makeRedundance() {
        MultiSeriesChartModel commonChart = this.getCommonChart();
        commonChart.addValueScope(this._unifiedAxisScope.getMin().toString(), this._unifiedAxisScope.getMax().toString());
        int seriesCount = this.getModelAssistantStructure().getMeasureFieldCountForAxis();
        AbstractNormalChartModel.Series series = commonChart.addSeries(null);
        if (seriesCount > 0) {
            series.setFormatString(this.getModelAssistantStructure().getMeasureField(0).getUsableNumberFormat());
        }
        ChartCell cell = new ChartCell();
        cell.setChart(commonChart);
        this.getTableView().setCommonCell(cell);
    }

    @Override
    protected AnalyticalField getColorField() {
        return this.getMyMarkParser().getColorField();
    }

    private static class MarkParserForArea
    extends AbstractMarkParser {
        private ModelAssistantStructure _mas;
        private AnalyticalField _colorDimensionField;
        private boolean _isStackByMeasure;

        public MarkParserForArea(ModelAssistantStructure mas) {
            this._mas = mas;
        }

        public AnalyticalField getColorField() {
            return this._colorDimensionField;
        }

        public boolean hasColorField() {
            return this._colorDimensionField != null;
        }

        public boolean isStackByMeasure() {
            return this._isStackByMeasure;
        }

        @Override
        protected void confirmWhichMeasureToDraw(List<AnalyticalField> measureFields, boolean[] whichMeasureToDraw) {
            int idx = this.searchMarkAsDimension("color");
            if (idx >= 0) {
                this._colorDimensionField = this.getModel().getFields().get(idx);
            }
            int measureCount = this._mas.getMeasureFieldCountForAxis();
            boolean bl = this._isStackByMeasure = this._colorDimensionField == null && measureCount > 1;
            if (whichMeasureToDraw.length > 0) {
                whichMeasureToDraw[0] = true;
            }
        }
    }
}

