/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.core.model.analysis.common;

import java.util.Arrays;
import java.util.List;
import org.jdom2.Element;

public class CustomPalette {
    private String name;
    private List<String> colors;

    public String getPresetName() {
        return this.name;
    }

    public void setPresetName(String name) {
        this.name = name;
    }

    public List<String> getColors() {
        return this.colors;
    }

    public void setColors(List<String> colors) {
        this.colors = colors;
    }

    public void toXml(Element node) {
        if (this.colors != null) {
            String encodedColors = CustomPalette.encodeColors(this.colors);
            node.setText(encodedColors);
        }
    }

    public void fromXml(Element node) {
        String encodedColors = node.getTextTrim();
        if (encodedColors.length() > 0) {
            this.colors = CustomPalette.decodeColors(encodedColors);
        }
    }

    private static String encodeColors(List<String> colors) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < colors.size(); ++i) {
            if (i > 0) {
                sb.append(",");
            }
            String color = colors.get(i);
            sb.append(color);
        }
        return sb.toString();
    }

    private static List<String> decodeColors(String encodedColors) {
        String[] colors = encodedColors.split(",");
        if (colors.length > 0) {
            return Arrays.asList(colors);
        }
        return null;
    }
}

