/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.core.model.analysis.longer;

import com.kingdee.bos.qing.core.exception.PersistentModelParseException;
import com.kingdee.bos.qing.core.model.analysis.AbstractQingModel;
import com.kingdee.bos.qing.core.model.analysis.IPreferences;
import com.kingdee.bos.qing.core.model.analysis.common.AnalyticalField;
import com.kingdee.bos.qing.core.model.analysis.common.OutsideReference;
import com.kingdee.bos.qing.core.model.analysis.common.filter.AbstractAnalyticalFilter;
import com.kingdee.bos.qing.core.model.analysis.common.linkage.LinkTargets;
import com.kingdee.bos.qing.core.model.analysis.longer.AbstractFieldSet;
import com.kingdee.bos.qing.core.model.analysis.longer.AnalyticalFieldSet;
import com.kingdee.bos.qing.core.model.analysis.longer.ChartType;
import com.kingdee.bos.qing.core.model.analysis.longer.FilterFieldSet;
import com.kingdee.bos.qing.core.model.analysis.longer.MarkFieldSet;
import com.kingdee.bos.qing.core.model.analysis.longer.SortingLane;
import com.kingdee.bos.qing.core.model.analysis.longer.preferences.AnalyticalPreferences;
import com.kingdee.bos.qing.core.model.analysis.longer.preferences.ChartConfig;
import com.kingdee.bos.qing.core.model.analysis.longer.preferences.ExhibitionStatus;
import com.kingdee.bos.qing.core.model.meta.DataType;
import com.kingdee.bos.qing.core.model.meta.Meta;
import com.kingdee.bos.qing.core.model.meta.MetaField;
import com.kingdee.bos.qing.util.XmlUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jdom2.Content;
import org.jdom2.Element;

public class AnalyticalModel
extends AbstractQingModel {
    private transient AnalyticalPreferences _preferences;
    private ChartType chartType;
    private AnalyticalFieldSet column;
    private AnalyticalFieldSet row;
    private List<MarkFieldSet> marks;
    private FilterFieldSet filter;
    private boolean isRowGrandTotal;
    private boolean isColumnGrandTotal;
    private SortingLane columnsSortingLane;
    private SortingLane rowsSortingLane;
    private LinkTargets linkTargets;

    @Override
    public void fixReferences(List<OutsideReference> refItems) {
    }

    @Override
    public List<OutsideReference> pickReferences() {
        return null;
    }

    public ChartType getChartType() {
        return this.chartType;
    }

    public void setChartType(ChartType chartType) {
        this.chartType = chartType;
    }

    public AnalyticalFieldSet getColumn() {
        return this.column;
    }

    public void setColumn(AnalyticalFieldSet column) {
        this.column = column;
    }

    public AnalyticalFieldSet getRow() {
        return this.row;
    }

    public void setRow(AnalyticalFieldSet row) {
        this.row = row;
    }

    public MarkFieldSet getMarkFieldSet() {
        if (this.marks == null || this.marks.size() == 0) {
            return null;
        }
        return this.marks.get(0);
    }

    public void setMarkFieldSet(MarkFieldSet mark) {
        if (mark == null) {
            this.marks = null;
        } else {
            this.marks = new ArrayList<MarkFieldSet>(1);
            this.marks.add(mark);
        }
    }

    public FilterFieldSet getFilterFieldSet() {
        return this.filter;
    }

    public void setFilterFieldSet(FilterFieldSet filterFieldSet) {
        this.filter = filterFieldSet;
    }

    public boolean isRowGrandTotal() {
        return this.isRowGrandTotal;
    }

    public void setRowGrandTotal(boolean isRowGrandTotal) {
        this.isRowGrandTotal = isRowGrandTotal;
    }

    public boolean isColumnGrandTotal() {
        return this.isColumnGrandTotal;
    }

    public void setColumnGrandTotal(boolean isColumnGrandTotal) {
        this.isColumnGrandTotal = isColumnGrandTotal;
    }

    public SortingLane getColumnsSortingLane() {
        return this.columnsSortingLane;
    }

    public void setColumnsSortingLane(SortingLane sortingLane) {
        this.columnsSortingLane = sortingLane;
    }

    public SortingLane getRowsSortingLane() {
        return this.rowsSortingLane;
    }

    public void setRowsSortingLane(SortingLane sortingLane) {
        this.rowsSortingLane = sortingLane;
    }

    public LinkTargets getLinkage() {
        if (this.linkTargets == null) {
            this.linkTargets = new LinkTargets();
        }
        return this.linkTargets;
    }

    @Override
    public void safetyTemplate() {
        this.filter.safety();
    }

    public ChartConfig getChartConfig() {
        return this._preferences == null ? null : this._preferences.getChartConfig();
    }

    public List<ExhibitionStatus.TreeExpandState> getTreeExpandStates() {
        List<ExhibitionStatus.TreeExpandState> tes = null;
        if (this._preferences != null && this._preferences.getExhibitionStatus() != null) {
            tes = this._preferences.getExhibitionStatus().getTreeExpandStates();
        }
        tes = tes == null ? new ArrayList<ExhibitionStatus.TreeExpandState>() : tes;
        return tes;
    }

    @Override
    public void bindPreferences(IPreferences preferences) {
        this._preferences = (AnalyticalPreferences)preferences;
    }

    @Override
    protected void fixMetaFieldBinding(Meta meta) {
        Map<String, MetaField> metaFields = meta.createSearchingMap();
        AnalyticalModel.fixMetaFieldBinding(metaFields, this.getRow().getFields());
        AnalyticalModel.fixMetaFieldBinding(metaFields, this.getColumn().getFields());
        AnalyticalModel.fixMetaFieldBinding(metaFields, this.getMarkFieldSet().getFields());
        AnalyticalModel.fixMetaFieldBinding(metaFields, this.getFilterFieldSet().getFields());
    }

    private static void fixMetaFieldBinding(Map<String, MetaField> metaFields, List<AnalyticalField> fields) {
        for (AnalyticalField field : fields) {
            field.fixMetaFieldBinding(metaFields);
        }
    }

    public void fixMetaFieldBinding(AnalyticalField field) {
        Map<String, MetaField> metaFields = this.getMeta().createSearchingMap();
        field.fixMetaFieldBinding(metaFields);
    }

    public boolean isAnyMetaFieldLost(List<String> lostMetaFields) {
        return AnalyticalModel.isAnyMetaFieldLost(this.getRow().getFields(), lostMetaFields) || AnalyticalModel.isAnyMetaFieldLost(this.getColumn().getFields(), lostMetaFields) || AnalyticalModel.isAnyMetaFieldLost(this.getMarkFieldSet().getFields(), lostMetaFields) || AnalyticalModel.isAnyMetaFieldLost(this.getFilterFieldSet().getFields(), lostMetaFields);
    }

    private static boolean isAnyMetaFieldLost(List<AnalyticalField> fields, List<String> lostMetaFields) {
        for (AnalyticalField field : fields) {
            if (!field.getMetaField().isLost()) continue;
            lostMetaFields.add(field.getMetaField().getFullDisplayName());
            return true;
        }
        return false;
    }

    @Override
    public Set<String> lookupUsedMetaFields() {
        HashSet<String> collector = new HashSet<String>();
        AnalyticalModel.lookupUsedMetaFields(this.getRow().getFields(), collector);
        AnalyticalModel.lookupUsedMetaFields(this.getColumn().getFields(), collector);
        AnalyticalModel.lookupUsedMetaFields(this.getMarkFieldSet().getFields(), collector);
        AnalyticalModel.lookupUsedMetaFields(this.getFilterFieldSet().getFields(), collector);
        if (this.linkTargets != null) {
            int c = this.linkTargets.getItemsCount();
            for (int i = 0; i < c; ++i) {
                LinkTargets.LinkTargetItem item = this.linkTargets.getItem(i);
                String field = item.getForeignKey();
                if (field == null) continue;
                collector.add(field);
            }
        }
        return collector;
    }

    private static void lookupUsedMetaFields(List<AnalyticalField> fields, Set<String> collector) {
        for (AnalyticalField field : fields) {
            MetaField mf = field.getMetaField();
            if (mf.isCalculation()) {
                Set<String> dependence = mf.getAllDependence();
                if (dependence == null) continue;
                collector.addAll(dependence);
                continue;
            }
            collector.add(mf.getFullName());
        }
    }

    @Override
    public void visitFilters(AbstractQingModel.IFilterVisitor visitor) {
        int c = this.filter.getFieldCount();
        for (int i = 0; i < c; ++i) {
            AnalyticalField oneField = this.filter.getField(i);
            AbstractAnalyticalFilter oneFilter = this.filter.getFilter(i);
            visitor.visit(oneField, oneFilter);
        }
    }

    @Override
    public void toXml(Element node) {
        this.sharedToXml(node);
        XmlUtil.writeAttrNotNull((Element)node, (String)"chartType", (String)this.chartType.toPersistance());
        XmlUtil.writeAttrDefaultFalse((Element)node, (String)"rowGrandTotal", (boolean)this.isRowGrandTotal);
        XmlUtil.writeAttrDefaultFalse((Element)node, (String)"columnGrandTotal", (boolean)this.isColumnGrandTotal);
        Element nodeColumn = this.column.toXml();
        nodeColumn.setName("Column");
        node.addContent((Content)nodeColumn);
        Element nodeRow = this.row.toXml();
        nodeRow.setName("Row");
        node.addContent((Content)nodeRow);
        Element nodeMarks = new Element("Marks");
        node.addContent((Content)nodeMarks);
        for (int i = 0; i < this.marks.size(); ++i) {
            MarkFieldSet mfs = this.marks.get(i);
            Element nodeMark = mfs.toXml();
            nodeMark.setName("Mark");
            nodeMarks.addContent((Content)nodeMark);
        }
        Element nodeFilter = this.filter.toXml();
        nodeFilter.setName("Filter");
        node.addContent((Content)nodeFilter);
        if (this.rowsSortingLane != null) {
            Element nodeRowSortingLane = this.rowsSortingLane.toXml();
            nodeRowSortingLane.setName("RowsSortingLane");
            node.addContent((Content)nodeRowSortingLane);
        }
        if (this.columnsSortingLane != null) {
            Element nodeColumnSortingLane = this.columnsSortingLane.toXml();
            nodeColumnSortingLane.setName("ColumnsSortingLane");
            node.addContent((Content)nodeColumnSortingLane);
        }
        if (this.linkTargets != null) {
            Element nodeLinkage = new Element("Linkage");
            this.linkTargets.toXml(nodeLinkage);
            node.addContent((Content)nodeLinkage);
        }
    }

    @Override
    public void fromXml(Element node) throws PersistentModelParseException {
        Element nodeLinkage;
        Element nodeColumnsSortingLane;
        Element nodeFilter;
        List markNodes;
        Element nodeRow;
        Element nodeColumn;
        this.sharedFromXml(node);
        try {
            this.chartType = ChartType.fromPersistance(XmlUtil.readAttrNotNull((Element)node, (String)"chartType"));
            nodeColumn = XmlUtil.getChildNotNull((Element)node, (String)"Column");
            nodeRow = XmlUtil.getChildNotNull((Element)node, (String)"Row");
            markNodes = XmlUtil.getChildren((Element)XmlUtil.getChildNotNull((Element)node, (String)"Marks"), (String)"Mark");
            nodeFilter = XmlUtil.getChildNotNull((Element)node, (String)"Filter");
        }
        catch (XmlUtil.NullException ex) {
            throw new PersistentModelParseException(ex);
        }
        this.isRowGrandTotal = XmlUtil.readAttrDefaultFalse((Element)node, (String)"rowGrandTotal");
        this.isColumnGrandTotal = XmlUtil.readAttrDefaultFalse((Element)node, (String)"columnGrandTotal");
        this.column = new AnalyticalFieldSet();
        this.column.fromXml(nodeColumn);
        this.row = new AnalyticalFieldSet();
        this.row.fromXml(nodeRow);
        this.marks = new ArrayList<MarkFieldSet>(1);
        for (int i = 0; i < markNodes.size(); ++i) {
            Element nodeMark = (Element)markNodes.get(i);
            MarkFieldSet mfs = new MarkFieldSet();
            mfs.fromXml(nodeMark);
            this.marks.add(mfs);
        }
        this.filter = new FilterFieldSet();
        this.filter.fromXml(nodeFilter);
        Element nodeRowsSortingLane = XmlUtil.getChild((Element)node, (String)"RowsSortingLane");
        if (nodeRowsSortingLane != null) {
            this.rowsSortingLane = new SortingLane();
            this.rowsSortingLane.fromXml(nodeRowsSortingLane);
        }
        if ((nodeColumnsSortingLane = XmlUtil.getChild((Element)node, (String)"ColumnsSortingLane")) != null) {
            this.columnsSortingLane = new SortingLane();
            this.columnsSortingLane.fromXml(nodeColumnsSortingLane);
        }
        if ((nodeLinkage = node.getChild("Linkage")) != null) {
            this.getLinkage().fromXml(nodeLinkage);
        }
    }

    public AnalyticalModel copy() {
        AnalyticalModel target = new AnalyticalModel();
        target.setChartType(this.getChartType());
        target.setColumn(this.getColumn().copy());
        target.setRow(this.getRow().copy());
        target.setMarkFieldSet(this.getMarkFieldSet().copy());
        target.setFilterFieldSet(this.getFilterFieldSet().copy());
        target.setRowGrandTotal(this.isRowGrandTotal());
        target.setColumnGrandTotal(this.isColumnGrandTotal());
        this.sharedCopy(target);
        target.bindMeta(this.getMeta());
        target.bindPreferences(this._preferences);
        return target;
    }

    public boolean isContainsCubeInterlineCalculation() {
        return AnalyticalModel.isCubeInterlineExist(this.getMarkFieldSet()) || AnalyticalModel.isCubeInterlineExist(this.row) || AnalyticalModel.isCubeInterlineExist(this.column);
    }

    private static boolean isCubeInterlineExist(AbstractFieldSet fieldSet) {
        for (AnalyticalField field : fieldSet.getFields()) {
            if (!field.getMetaField().isCubeInterlineCalculation()) continue;
            return true;
        }
        return false;
    }

    public Set<AnalyticalField> getCubeInterlineDimensions(AnalyticalField filterField) {
        HashSet<AnalyticalField> collector = new HashSet<AnalyticalField>();
        AnalyticalModel.pickCubeInterlineDimemsionField(this.getMarkFieldSet(), filterField, collector);
        AnalyticalModel.pickCubeInterlineDimemsionField(this.row, filterField, collector);
        AnalyticalModel.pickCubeInterlineDimemsionField(this.column, filterField, collector);
        return collector;
    }

    private static void pickCubeInterlineDimemsionField(AbstractFieldSet fieldSet, AnalyticalField filterField, Set<AnalyticalField> collector) {
        for (AnalyticalField field : fieldSet.getFields()) {
            if (!field.isDimension() || field.getMetaField() != filterField.getMetaField() || (field.getDataType() != DataType.DATE || field.getPartValue() != filterField.getPartValue()) && field.getMetaField().getCustomPeriod() == null) continue;
            collector.add(field);
        }
    }
}

