/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.core.model.analysis.longer;

import com.kingdee.bos.qing.core.exception.PersistentModelParseException;
import com.kingdee.bos.qing.core.model.analysis.longer.AbstractFieldSet;
import com.kingdee.bos.qing.util.XmlUtil;
import java.util.ArrayList;
import java.util.List;
import org.jdom2.Content;
import org.jdom2.Element;

public class MarkFieldSet
extends AbstractFieldSet {
    public static final String TYPE_UNSURE = "";
    public static final String TYPE_LABEL = "label";
    public static final String TYPE_COLOR = "color";
    public static final String TYPE_SIZE = "size";
    public static final String TYPE_ANGLE = "angle";
    public static final String TYPE_BLANK = "blank";
    private List<String> markTypes = new ArrayList<String>();

    public List<String> getMarkTypes() {
        return this.markTypes;
    }

    public void setMarkTypes(List<String> markTypes) {
        this.markTypes = markTypes;
    }

    public String getMarkType(int idx) {
        return this.markTypes.get(idx);
    }

    @Override
    protected Element itemToXml(int idx) {
        Element nodeMarkType = new Element("MarkType");
        String markType = this.markTypes.get(idx);
        XmlUtil.writeAttrWhenExist((Element)nodeMarkType, (String)"name", (String)markType);
        if (!TYPE_COLOR.equals(markType)) {
            this.getField(idx).setContinuousColor(null);
        }
        Element nodeField = super.fieldToXml(idx);
        nodeField.setName("Field");
        Element nodeItem = new Element("Item");
        nodeItem.addContent((Content)nodeField);
        nodeItem.addContent((Content)nodeMarkType);
        return nodeItem;
    }

    @Override
    protected void itemFromXml(Element nodeItem, int idx) throws PersistentModelParseException {
        Element nodeMarkType;
        Element nodeField;
        try {
            nodeField = XmlUtil.getChildNotNull((Element)nodeItem, (String)"Field");
            nodeMarkType = XmlUtil.getChildNotNull((Element)nodeItem, (String)"MarkType");
        }
        catch (XmlUtil.NullException e) {
            throw new PersistentModelParseException(e);
        }
        super.fieldFromXml(nodeField, idx);
        String markType = XmlUtil.readAttrWhenExist((Element)nodeMarkType, (String)"name");
        if (markType == null) {
            this.markTypes.add(idx, TYPE_UNSURE);
        } else {
            this.markTypes.add(idx, markType);
        }
    }

    MarkFieldSet copy() {
        MarkFieldSet inst = new MarkFieldSet();
        this.copyProperties(inst);
        for (String markType : this.markTypes) {
            inst.markTypes.add(markType);
        }
        return inst;
    }
}

