/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.core.model.exhibition.common;

import com.kingdee.bos.qing.core.model.exhibition.common.AbstractComparableObject;
import com.kingdee.bos.qing.util.LogUtil;

public class Style
extends AbstractComparableObject {
    public static final String KEY_COLOR = "color";
    public static final String KEY_BACKGROUND = "background";
    public static final String KEY_FONTSIZE = "fontSize";
    public static final String KEY_BOLD = "bold";
    public static final String KEY_ALIGN = "align";
    public static final String KEY_HIDE = "hide";
    private transient int _hashcode;
    private Integer fontSize;
    private Boolean bold;
    private String color;
    private String background;
    private String align;
    private Boolean hide;

    public void setFontSize(Integer fontSize) {
        this.fontSize = fontSize;
        this.dirty();
    }

    public Integer getFontSize() {
        return this.fontSize;
    }

    public void setBold(Boolean isBold) {
        this.bold = isBold;
        this.dirty();
    }

    public boolean isBold() {
        return this.bold == null ? false : this.bold;
    }

    public void setColor(String color) {
        this.color = color;
        this.dirty();
    }

    public String getColor() {
        return this.color;
    }

    public void setBackground(String background) {
        this.background = background;
        this.dirty();
    }

    public String getBackground() {
        return this.background;
    }

    public void setAlign(String type) {
        this.align = type;
        this.dirty();
    }

    public String getAlign() {
        return this.align;
    }

    public void setHide(Boolean isHide) {
        this.hide = isHide;
        this.dirty();
    }

    public boolean isHide() {
        return this.hide == null ? false : this.hide;
    }

    private void dirty() {
        this._hashcode = 0;
    }

    public void set(String key, Object value) {
        if (KEY_COLOR.equalsIgnoreCase(key)) {
            this.setColor(String.valueOf(value));
        } else if (KEY_BACKGROUND.equalsIgnoreCase(key)) {
            this.setBackground(String.valueOf(value));
        } else if (KEY_FONTSIZE.equalsIgnoreCase(key)) {
            try {
                this.setFontSize(Integer.parseInt(String.valueOf(value)));
            }
            catch (NumberFormatException ex) {
                if (LogUtil.isDebugEnabled()) {
                    LogUtil.debug((String)("It can not be a number for font-size: " + value), (Throwable)ex);
                }
            }
        } else if (KEY_BOLD.equalsIgnoreCase(key)) {
            this.setBold(Boolean.parseBoolean(String.valueOf(value)) ? Boolean.TRUE : null);
        } else if (KEY_ALIGN.equalsIgnoreCase(key)) {
            this.setAlign(String.valueOf(value));
        } else if (KEY_HIDE.equalsIgnoreCase(key)) {
            this.setHide(Boolean.parseBoolean(String.valueOf(value)) ? Boolean.TRUE : null);
        }
    }

    public Style copy() {
        Style style = new Style();
        style.setFontSize(this.fontSize);
        style.setBold(this.bold);
        style.setColor(this.color);
        style.setBackground(this.background);
        style.setAlign(this.align);
        style.setHide(this.hide);
        return style;
    }

    public int hashCode() {
        if (this._hashcode == 0) {
            this._hashcode = this.fontSize == null ? 0 : this.fontSize.hashCode();
            this._hashcode = this._hashcode * 31 + (this.bold == null ? 0 : this.bold.hashCode());
            this._hashcode = this._hashcode * 31 + (this.color == null ? 0 : this.color.hashCode());
            this._hashcode = this._hashcode * 31 + (this.background == null ? 0 : this.background.hashCode());
            this._hashcode = this._hashcode * 31 + (this.align == null ? 0 : this.align.hashCode());
            this._hashcode = this._hashcode * 31 + (this.hide == null ? 0 : this.hide.hashCode());
        }
        return this._hashcode;
    }

    public boolean equals(Object o) {
        if (o instanceof Style) {
            Style another = (Style)o;
            return Style.isEquals(this.fontSize, another.fontSize) && Style.isEquals(this.bold, another.bold) && Style.isEquals(this.color, another.color) && Style.isEquals(this.background, another.background) && Style.isEquals(this.align, another.align) && Style.isEquals(this.hide, another.hide);
        }
        return false;
    }

    @Override
    public boolean isEqualTo(Object standard) {
        return this.equals(standard);
    }
}

