/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.core.model.meta;

import com.kingdee.bos.qing.util.XmlUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jdom2.Content;
import org.jdom2.Element;

public class CustomPeriod {
    private List<Part> parts;

    public List<Part> getParts() {
        return this.parts;
    }

    public void addPart(Part part) {
        if (this.parts == null) {
            this.parts = new ArrayList<Part>();
        }
        this.parts.add(part);
    }

    public boolean isValid() {
        return this.parts != null && this.parts.size() > 0;
    }

    public boolean isYear() {
        return this.isValid() && this.parts.size() == 1 && this.parts.get(0).isAsYear();
    }

    public boolean isWithYear() {
        return this.isValid() && this.parts.size() > 1 && this.parts.get(0).isAsYear();
    }

    public Element toXml() {
        Element node = new Element("Temp");
        for (Part part : this.parts) {
            node.addContent((Content)part.toXml());
        }
        return node;
    }

    public void fromXml(Element node) {
        List children = node.getChildren();
        for (Element child : children) {
            Part part = new Part();
            part.fromXml(child);
            if (this.parts == null) {
                this.parts = new ArrayList<Part>();
            }
            this.parts.add(part);
        }
    }

    public static class Part {
        private String description;
        private Boolean asYear;
        private List<String> value;

        public void setAsYear(boolean isAsYear) {
            this.asYear = isAsYear ? Boolean.TRUE : null;
        }

        public boolean isAsYear() {
            return this.asYear == null ? false : this.asYear;
        }

        public void setEnumeration(List<String> value) {
            this.value = value;
        }

        public List<String> getEnumeration() {
            return this.value;
        }

        public Element toXml() {
            Element node = new Element("Item");
            XmlUtil.writeAttrWhenExist((Element)node, (String)"description", (String)this.description);
            XmlUtil.writeAttrBoolWhenExist((Element)node, (String)"asYear", (Boolean)this.asYear);
            String encodedValue = null;
            if (this.value != null) {
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < this.value.size(); ++i) {
                    if (i > 0) {
                        sb.append("_|_");
                    }
                    sb.append(this.value.get(i));
                }
                encodedValue = sb.toString();
            }
            XmlUtil.writeAttrWhenExist((Element)node, (String)"value", encodedValue);
            return node;
        }

        public void fromXml(Element node) {
            this.description = XmlUtil.readAttrWhenExist((Element)node, (String)"description");
            this.asYear = XmlUtil.readAttrBoolWhenExist((Element)node, (String)"asYear");
            String encodedValue = XmlUtil.readAttrWhenExist((Element)node, (String)"value");
            if (encodedValue != null) {
                String[] value = encodedValue.split("_\\|_");
                this.value = Arrays.asList(value);
            }
        }
    }
}

