/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.domain;

import com.kingdee.bos.qing.common.grammar.exception.ParserException;
import com.kingdee.bos.qing.common.grammar.i18n.ErrorMessage;
import com.kingdee.bos.qing.common.i18n.DefaultI18nContext;
import com.kingdee.bos.qing.common.i18n.II18nContext;
import com.kingdee.bos.qing.core.exception.AnalysisException;
import com.kingdee.bos.qing.core.exception.FormulaException;
import com.kingdee.bos.qing.core.i18n.Messages;
import com.kingdee.bos.qing.core.model.meta.DataType;
import com.kingdee.bos.qing.core.model.meta.Meta;
import com.kingdee.bos.qing.core.model.meta.MetaField;
import com.kingdee.bos.qing.core.model.meta.MetaTable;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class FormulaCheckDomain {
    private II18nContext _i18nContext;

    public CheckingInfo checkFormula(String formula, Meta meta, String selfFieldName) throws AnalysisException {
        String[] twoParts = MetaField.decodeFullName(selfFieldName);
        String tableName = twoParts[0];
        String fieldPureName = twoParts[1];
        MetaField mf = new MetaField();
        mf.setPureName(fieldPureName);
        mf.setFormula(formula);
        mf.setPureDisplayName("");
        List<MetaTable> mts = meta.getTables();
        for (int i = 0; i < mts.size(); ++i) {
            MetaTable mt = mts.get(i);
            if ((tableName != null || mt.getName() != null) && (tableName == null || !tableName.equals(mt.getName()))) continue;
            List<MetaField> mfs = mt.getFields();
            for (int j = mfs.size() - 1; j >= 0; --j) {
                MetaField exist = mfs.get(j);
                if (!exist.getPureName().equals(fieldPureName)) continue;
                mfs.remove(j);
            }
            mfs.add(0, mf);
            mf.setMetaTable(mt);
            break;
        }
        FormulaParsingExceptionHandler exHandler = new FormulaParsingExceptionHandler(meta, mf, this.getI18nContext());
        meta.checkEditingFormula(exHandler);
        CheckingInfo exInfo = exHandler.getExceptionInfo();
        if (exInfo == null) {
            DataType dataType = mf.getDataType();
            Set<String> dependence = mf.getAllDependence();
            MetaField.FormulaAggStatus aggStatus = mf.getFormulaAggStatus();
            return new CheckingInfo(dataType, dependence, aggStatus);
        }
        return exInfo;
    }

    public void repairMeta(Meta meta) throws AnalysisException {
        meta.fixExprAndDependents();
    }

    public final void setI18nContext(II18nContext i18nCtx) {
        this._i18nContext = i18nCtx;
    }

    protected final II18nContext getI18nContext() {
        if (this._i18nContext == null) {
            this._i18nContext = new DefaultI18nContext();
        }
        return this._i18nContext;
    }

    public static class CheckingInfo {
        private boolean ok;
        private DataType dataType;
        private Set<String> dependence;
        private MetaField.FormulaAggStatus formulaAggStaus;
        private Integer errorPosition;
        private String errorPrompt;

        public CheckingInfo(DataType dataType, Set<String> dependence, MetaField.FormulaAggStatus formulaAggStaus) {
            this.ok = true;
            this.dataType = dataType;
            this.dependence = dependence;
            this.formulaAggStaus = formulaAggStaus;
        }

        public CheckingInfo(FormulaException ex, Map<String, MetaField> metaFields, II18nContext ii18nContext) {
            String prompt;
            block8: {
                block11: {
                    block10: {
                        block9: {
                            block7: {
                                this.ok = false;
                                this.errorPosition = ex.getPosition();
                                if (!(ex instanceof FormulaException.CycleReferenceException)) break block7;
                                prompt = Messages.getLangMessage(ii18nContext, "formulaLoopReference", "\u5faa\u73af\u5f15\u7528");
                                break block8;
                            }
                            if (!(ex instanceof FormulaException.FieldNotFoundException)) break block9;
                            prompt = Messages.getLangMessage(ii18nContext, "formulaFieldNotExists", "\u5b57\u6bb5\u4e0d\u5b58\u5728");
                            break block8;
                        }
                        if (!(ex instanceof FormulaException.InvalidReferenceException)) break block10;
                        prompt = Messages.getLangMessage(ii18nContext, "formulaFieldIncorrect", "\u5b57\u6bb5\u4e0d\u6b63\u786e");
                        break block8;
                    }
                    if (!(ex instanceof FormulaException.MixedException)) break block11;
                    switch (((FormulaException.MixedException)ex).getType()) {
                        case AggMixRef: {
                            prompt = Messages.getLangMessage(ii18nContext, "formulaAggMixRef", "\u4e0d\u5141\u8bb8\u6df7\u5408\u805a\u5408\u8fd0\u7b97\u4e0e\u6570\u636e\u884c\u53d6\u503c");
                            break block8;
                        }
                        case NestedAgg: {
                            prompt = Messages.getLangMessage(ii18nContext, "formulaAggNested", "\u4e0d\u5141\u8bb8\u805a\u5408\u8fd0\u7b97\u5d4c\u5957");
                            break block8;
                        }
                        case NestedInterline: {
                            prompt = Messages.getLangMessage(ii18nContext, "formulaInterlineNested", "\u4e0d\u5141\u8bb8\u89c6\u56fe\u8ba1\u7b97\u5d4c\u5957");
                            break block8;
                        }
                        case AggBeforeInterline: {
                            prompt = Messages.getLangMessage(ii18nContext, "formulaAggBeforeInterline", "\u805a\u5408\u51fd\u6570\u7684\u53c2\u6570\u4e0d\u5141\u8bb8\u51fa\u73b0\u89c6\u56fe\u8ba1\u7b97");
                            break block8;
                        }
                        case InterlineWithoutAgg: {
                            prompt = Messages.getLangMessage(ii18nContext, "formulaInterlineWithoutAgg", "\u89c6\u56fe\u8ba1\u7b97\u5fc5\u987b\u4ee5\u805a\u5408\u51fd\u6570\u4f5c\u4e3a\u53c2\u6570");
                            break block8;
                        }
                        default: {
                            throw new RuntimeException("Unknown");
                        }
                    }
                }
                throw new RuntimeException("Unknown");
            }
            String name = ex.getMetaFieldName();
            MetaField mf = metaFields.get(name);
            String alias = mf == null ? null : mf.getFullDisplayName();
            this.errorPrompt = prompt + (alias == null || "".equals(alias) ? "" : ": [" + alias + "]");
        }

        public CheckingInfo(ParserException ex, II18nContext i18nCtx) {
            this.ok = false;
            this.errorPosition = ex.getCharacterIndex();
            this.errorPrompt = ErrorMessage.encodeParserException((ParserException)ex, (II18nContext)i18nCtx);
        }
    }

    private static class FormulaParsingExceptionHandler
    implements Meta.IFormulaParsingExceptionHandler {
        private Meta _meta;
        private MetaField _self;
        private CheckingInfo _info;
        private II18nContext _i18nContext;

        public FormulaParsingExceptionHandler(Meta meta, MetaField self, II18nContext i18nContext) {
            this._meta = meta;
            this._self = self;
            this._i18nContext = i18nContext;
        }

        public CheckingInfo getExceptionInfo() {
            return this._info;
        }

        @Override
        public boolean forParsing(MetaField mf, ParserException ex) {
            if (mf == this._self) {
                this._info = new CheckingInfo(ex, this._i18nContext);
                return true;
            }
            mf.setInvalid(true);
            return false;
        }

        @Override
        public boolean forChecking(MetaField mf, FormulaException ex) {
            if (mf == this._self) {
                this._info = new CheckingInfo(ex, this._meta.createSearchingMap(), this._i18nContext);
                return true;
            }
            mf.setInvalid(true);
            return false;
        }
    }
}

