/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.domain;

import com.kingdee.bos.qing.core.engine.CompositeKey;
import com.kingdee.bos.qing.core.exception.AnalysisException;
import com.kingdee.bos.qing.core.exception.ExhibitionCacheException;
import com.kingdee.bos.qing.core.model.analysis.longer.preferences.ExhibitionStatus;
import com.kingdee.bos.qing.core.model.exhibition.longer.ICell;
import com.kingdee.bos.qing.core.model.exhibition.longer.MergeBlock;
import com.kingdee.bos.qing.core.model.exhibition.longer.TableView;
import com.kingdee.bos.qing.core.model.exhibition.longer.headcell.NonstringCell;
import com.kingdee.bos.qing.core.model.exhibition.longer.headcell.TreeNodeCell;
import com.kingdee.bos.qing.domain.AbstractDomain;
import com.kingdee.bos.qing.util.JsonUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PostExecuteDomain {
    public void cacheNormalExhibition(AbstractDomain.IExhibitionCacheWriter writer, TableView tableView, int firstPartRows, int everyPartRows) {
        List<Object[]> leftHead = tableView.getLeftHead();
        if (leftHead.size() <= firstPartRows) {
            return;
        }
        List<ICell[]> cells = tableView.getCells();
        ArrayList<Object[]> firstPartOfLeftHead = new ArrayList<Object[]>(firstPartRows);
        ArrayList<ICell[]> firstPartOfCells = new ArrayList<ICell[]>();
        for (int i = 0; i < firstPartRows; ++i) {
            firstPartOfLeftHead.add(leftHead.get(i));
            if (i >= cells.size()) continue;
            firstPartOfCells.add(cells.get(i));
        }
        tableView.setLeftHead(firstPartOfLeftHead);
        tableView.setCells(firstPartOfCells);
        TableView cacheTableView = new TableView();
        cacheTableView.setLeftHead(leftHead);
        cacheTableView.setCells(cells);
        String cacheKey = writer.createCacheKey();
        tableView.getExhibitionCache().setCahceKey(cacheKey);
        tableView.getExhibitionCache().setNextPartRowStart(firstPartRows);
        tableView.getExhibitionCache().setEveryPartRows(everyPartRows);
        tableView.getExhibitionCache().setTotalRows(leftHead.size());
        writer.asyncCache(cacheTableView, false);
    }

    public void cacheTreeExhibition(AbstractDomain.IExhibitionCacheWriter writer, TableView tableView, List<ExhibitionStatus.TreeExpandState> treeExpandStates, int leftColumnCount) {
        TableView cacheTableView = new TableView();
        cacheTableView.setLeftHead(tableView.getLeftHead());
        cacheTableView.setCells(tableView.getCells());
        this.pickTreeDisplayRows(tableView, treeExpandStates, leftColumnCount);
        String cacheKey = writer.createCacheKey();
        tableView.getExhibitionCache().setCahceKey(cacheKey);
        writer.asyncCache(cacheTableView, true);
    }

    private void pickTreeDisplayRows(TableView tv, List<ExhibitionStatus.TreeExpandState> treeExpandState, int columnCount) {
        int tableTopHeadRows = tv.getTopHead().size() > 0 ? tv.getTopHead().get(0).length : 1;
        Map<CompositeKey, Boolean> expandedSearchingMap = PostExecuteDomain.createTreeExpandedSearchingMap(treeExpandState);
        Object[] eachColumnLastCell = new Object[columnCount];
        int[] eachColumnMergedRowStart = new int[columnCount];
        boolean[] eachColumnCollapsedByAncestor = new boolean[columnCount];
        int[] eachColumnCollapsedLevel = new int[columnCount];
        for (int j = 0; j < columnCount; ++j) {
            eachColumnCollapsedByAncestor[j] = false;
            eachColumnCollapsedLevel[j] = Integer.MAX_VALUE;
        }
        ArrayList<Object[]> pickedLeftHeads = new ArrayList<Object[]>();
        ArrayList<ICell[]> pickedCells = new ArrayList<ICell[]>();
        ArrayList<Integer> pickedRowsIdx = new ArrayList<Integer>();
        List<Object[]> leftHeads = tv.getLeftHead();
        List<ICell[]> cells = tv.getCells();
        int rowIdxAtView = tableTopHeadRows;
        for (int i = 0; i < leftHeads.size(); ++i) {
            Object[] oneRow = leftHeads.get(i);
            CompositeKey members = new CompositeKey();
            boolean votingHide = false;
            boolean isMerged = true;
            for (int j = 0; j < columnCount; ++j) {
                TreeNodeCell tnc;
                Object headCell = oneRow[j];
                boolean bl = isMerged = isMerged ? headCell.equals(eachColumnLastCell[j]) : false;
                if (!isMerged) {
                    PostExecuteDomain.tryToAppendMergeBlock(tv.getMergeBlocks(), j, eachColumnMergedRowStart[j], rowIdxAtView - 1);
                    eachColumnMergedRowStart[j] = rowIdxAtView;
                }
                if ((tnc = PostExecuteDomain.parseHeadCell(headCell, members)) != null) {
                    boolean isCollapsedByAncestor;
                    boolean isExpanded = PostExecuteDomain.isExpanded(expandedSearchingMap, members);
                    if (isMerged) {
                        isCollapsedByAncestor = eachColumnCollapsedByAncestor[j];
                    } else {
                        isCollapsedByAncestor = true;
                        int collapsedLevel = eachColumnCollapsedLevel[j];
                        if (tnc.getLevel() <= collapsedLevel) {
                            isCollapsedByAncestor = false;
                            eachColumnCollapsedLevel[j] = collapsedLevel = isExpanded ? Integer.MAX_VALUE : tnc.getLevel();
                        }
                        eachColumnCollapsedByAncestor[j] = isCollapsedByAncestor;
                    }
                    boolean bl2 = votingHide = votingHide || isCollapsedByAncestor;
                    if (!votingHide && isExpanded) {
                        tnc.setExpanded(true);
                    }
                }
                eachColumnLastCell[j] = headCell;
            }
            if (votingHide) continue;
            ++rowIdxAtView;
            pickedLeftHeads.add(oneRow);
            if (cells.size() > 0) {
                pickedCells.add(cells.get(i));
            }
            pickedRowsIdx.add(i);
        }
        for (int j = 0; j < columnCount; ++j) {
            PostExecuteDomain.tryToAppendMergeBlock(tv.getMergeBlocks(), j, eachColumnMergedRowStart[j], rowIdxAtView - 1);
        }
        tv.setLeftHead(pickedLeftHeads);
        tv.setCells(pickedCells);
        tv.setIdxForRows(pickedRowsIdx);
    }

    private static boolean isExpanded(Map<CompositeKey, Boolean> expandedSearchingMap, CompositeKey members) {
        Boolean isExpanded = expandedSearchingMap.get(members);
        if (isExpanded == null) {
            return false;
        }
        return isExpanded;
    }

    private static Map<CompositeKey, Boolean> createTreeExpandedSearchingMap(List<ExhibitionStatus.TreeExpandState> treeExpandStates) {
        HashMap<CompositeKey, Boolean> map = new HashMap<CompositeKey, Boolean>(treeExpandStates.size());
        for (ExhibitionStatus.TreeExpandState state : treeExpandStates) {
            String[] keys = state.getKeys();
            CompositeKey compositeKey = new CompositeKey();
            for (String key : keys) {
                compositeKey.addMember(key);
            }
            map.put(compositeKey, state.isExpanded());
        }
        return map;
    }

    private static void tryToAppendMergeBlock(List<MergeBlock> mbs, int colIdx, int startRowIdx, int endRowIdx) {
        if (endRowIdx > startRowIdx) {
            mbs.add(new MergeBlock(startRowIdx, endRowIdx, colIdx, colIdx));
        }
    }

    private static TreeNodeCell parseHeadCell(Object headCell, CompositeKey members) {
        if (headCell instanceof String) {
            members.addMember(headCell);
        } else if (headCell instanceof NonstringCell) {
            members.addMember(((NonstringCell)headCell).getText());
        } else if (headCell instanceof TreeNodeCell) {
            TreeNodeCell tnc = (TreeNodeCell)headCell;
            members.addMember(tnc.getId());
            return tnc;
        }
        return null;
    }

    public String getNormalCachedExhibition(AbstractDomain.IExhibitionCacheReader reader, String cacheKey, int fromRow, int rows, long timestamp) throws AnalysisException {
        return this.getCachedExhibition(reader, cacheKey, fromRow, -1, rows, -1, timestamp);
    }

    public String getTreeCachedExhibition(AbstractDomain.IExhibitionCacheReader reader, String cacheKey, int fromRow, int fromCol, int appendRowAtView, long timestamp) throws AnalysisException {
        return this.getCachedExhibition(reader, cacheKey, fromRow, fromCol, -1, appendRowAtView, timestamp);
    }

    private String getCachedExhibition(AbstractDomain.IExhibitionCacheReader reader, String cacheKey, int fromRow, int fromCol, int rows, int appendRowAtView, long timestamp) throws AnalysisException {
        String tableViewContent;
        if (fromCol < 0) {
            rows = rows <= 0 ? 100 : rows;
            tableViewContent = reader.getCachedJson(cacheKey, fromRow, rows);
        } else {
            tableViewContent = reader.getCachedJsonForTree(cacheKey, fromRow, fromCol, appendRowAtView);
        }
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        sb.append('\"');
        sb.append("timestamp");
        sb.append('\"');
        sb.append(':');
        sb.append(timestamp);
        sb.append(',');
        sb.append('\"');
        sb.append("tableView");
        sb.append('\"');
        sb.append(':');
        sb.append(tableViewContent);
        sb.append('}');
        return sb.toString();
    }

    public static abstract class AbstractExhibitionCacheReader
    extends RelatedConstant
    implements AbstractDomain.IExhibitionCacheReader {
        @Override
        public final String getCachedJson(String cacheKey, int rowIdx, int rows) throws AnalysisException {
            this.seekCachedRow(cacheKey, rowIdx);
            int nextPartRowStart = rowIdx + rows;
            int leftHeadColumns = this.getLeftHeadColumns();
            int cellColumns = this.getCellColumns();
            StringBuilder sbLeftHead = new StringBuilder();
            StringBuilder sbCells = new StringBuilder();
            sbLeftHead.append('[');
            sbCells.append('[');
            for (int i = 0; i < rows; ++i) {
                if (i > 0) {
                    sbLeftHead.append(',');
                    if (cellColumns > 0) {
                        sbCells.append(',');
                    }
                }
                this.appendOneRowCachedJson(sbLeftHead, sbCells, leftHeadColumns, cellColumns);
                if (!this.hasNextCachedRow()) {
                    nextPartRowStart = -1;
                    break;
                }
                this.nextCachedRow();
            }
            sbLeftHead.append(']');
            sbCells.append(']');
            TableView.ExhibitionCache ec = new TableView.ExhibitionCache();
            ec.setCahceKey(cacheKey);
            ec.setNextPartRowStart(nextPartRowStart);
            ec.setEveryPartRows(rows);
            StringBuilder sb = new StringBuilder();
            sb.append('{');
            AbstractExhibitionCacheReader.appendJsonKey(sb, "leftHead");
            sb.append((CharSequence)sbLeftHead);
            sb.append(',');
            AbstractExhibitionCacheReader.appendJsonKey(sb, "cells");
            sb.append((CharSequence)sbCells);
            sb.append(',');
            AbstractExhibitionCacheReader.appendJsonKey(sb, "exhibitionCache");
            sb.append(JsonUtil.encodeToString((Object)ec));
            sb.append('}');
            return sb.toString();
        }

        @Override
        public final String getCachedJsonForTree(String cacheKey, int expandingRowIdx, int expandingColumnIdx, int appendRowIdxAtView) throws AnalysisException {
            this.seekCachedRow(cacheKey, expandingRowIdx);
            int leftHeadColumns = this.getLeftHeadColumns();
            int cellColumns = this.getCellColumns();
            int expandingLevel = this.getCachedTreeLevel(expandingColumnIdx);
            String expandingCell = this.getCachedLeftHead(expandingColumnIdx);
            String[] eachColumnLastCell = new String[leftHeadColumns];
            int[] eachColumnMergedRowStart = new int[leftHeadColumns];
            boolean[] eachColumnCollapsedByAncestor = new boolean[leftHeadColumns];
            int[] eachColumnCollapsedLevel = new int[leftHeadColumns];
            for (int j = 0; j < leftHeadColumns; ++j) {
                eachColumnLastCell[j] = this.getCachedLeftHead(j);
                eachColumnMergedRowStart[j] = appendRowIdxAtView;
                eachColumnCollapsedByAncestor[j] = false;
                eachColumnCollapsedLevel[j] = Integer.MAX_VALUE;
            }
            StringBuilder sbLeftHead = new StringBuilder();
            StringBuilder sbCells = new StringBuilder();
            sbLeftHead.append('[');
            sbCells.append('[');
            ArrayList<Integer> pickedRowsIdx = new ArrayList<Integer>();
            ArrayList mergeBlocks = new ArrayList();
            boolean isStop = false;
            while (this.hasNextCachedRow() && !isStop) {
                int j;
                this.nextCachedRow();
                boolean votingHide = false;
                boolean isMerged = true;
                for (j = 0; j < leftHeadColumns; ++j) {
                    boolean isCollapsedByAncestor;
                    String json = this.getCachedLeftHead(j);
                    boolean bl = isMerged = isMerged ? json.equals(eachColumnLastCell[j]) : false;
                    if (j < expandingColumnIdx) {
                        if (isMerged) continue;
                        isStop = true;
                        break;
                    }
                    int level = this.getCachedTreeLevel(j);
                    if (j == expandingColumnIdx) {
                        if (json.equals(expandingCell)) {
                            votingHide = true;
                            break;
                        }
                        if (level <= expandingLevel) {
                            isStop = true;
                            break;
                        }
                    }
                    if (!isMerged) {
                        if (j >= expandingColumnIdx) {
                            PostExecuteDomain.tryToAppendMergeBlock(mergeBlocks, j, eachColumnMergedRowStart[j], appendRowIdxAtView - 1);
                        }
                        eachColumnMergedRowStart[j] = appendRowIdxAtView;
                    }
                    if (isMerged) {
                        isCollapsedByAncestor = eachColumnCollapsedByAncestor[j];
                    } else {
                        isCollapsedByAncestor = true;
                        int collapsedLevel = eachColumnCollapsedLevel[j];
                        if (level <= collapsedLevel) {
                            isCollapsedByAncestor = false;
                            eachColumnCollapsedLevel[j] = collapsedLevel = level;
                        }
                        eachColumnCollapsedByAncestor[j] = isCollapsedByAncestor;
                    }
                    votingHide = votingHide || isCollapsedByAncestor;
                }
                if (!isStop && !votingHide) {
                    ++appendRowIdxAtView;
                    if (sbLeftHead.length() > 1) {
                        sbLeftHead.append(',');
                        if (cellColumns > 0) {
                            sbCells.append(',');
                        }
                    }
                    this.appendOneRowCachedJson(sbLeftHead, sbCells, leftHeadColumns, cellColumns);
                    pickedRowsIdx.add(this.getCachedRowNumber());
                }
                for (j = 0; j < leftHeadColumns; ++j) {
                    eachColumnLastCell[j] = this.getCachedLeftHead(j);
                }
            }
            for (int j = expandingColumnIdx; j < leftHeadColumns; ++j) {
                PostExecuteDomain.tryToAppendMergeBlock(mergeBlocks, j, eachColumnMergedRowStart[j], appendRowIdxAtView - 1);
            }
            sbLeftHead.append(']');
            sbCells.append(']');
            StringBuilder sb = new StringBuilder();
            sb.append('{');
            AbstractExhibitionCacheReader.appendJsonKey(sb, "leftHead");
            sb.append((CharSequence)sbLeftHead);
            sb.append(',');
            AbstractExhibitionCacheReader.appendJsonKey(sb, "cells");
            sb.append((CharSequence)sbCells);
            sb.append(',');
            AbstractExhibitionCacheReader.appendJsonKey(sb, "rowsIdx");
            sb.append(JsonUtil.encodeToString(pickedRowsIdx));
            sb.append(',');
            AbstractExhibitionCacheReader.appendJsonKey(sb, "mergeBlocks");
            sb.append(JsonUtil.encodeToString(mergeBlocks));
            sb.append('}');
            return sb.toString();
        }

        private static void appendJsonKey(StringBuilder sb, String key) {
            sb.append('\"');
            sb.append(key);
            sb.append('\"');
            sb.append(':');
        }

        private void appendOneRowCachedJson(StringBuilder sbLeftHead, StringBuilder sbCells, int leftHeadColumns, int cellColumns) {
            this.appendCachedJson(sbLeftHead, leftHeadColumns, "H");
            if (cellColumns > 0) {
                this.appendCachedJson(sbCells, cellColumns, "C");
            }
        }

        private void appendCachedJson(StringBuilder sb, int columns, String fieldPrefix) {
            sb.append('[');
            for (int k = 0; k < columns; ++k) {
                if (k > 0) {
                    sb.append(',');
                }
                String json = (String)this.getCachedValue(fieldPrefix + k);
                sb.append(json);
            }
            sb.append(']');
        }

        private int getCachedRowNumber() {
            return ((BigDecimal)this.getCachedValue("SE")).intValue();
        }

        private String getCachedLeftHead(int colIdx) {
            return (String)this.getCachedValue("H" + colIdx);
        }

        private int getCachedTreeLevel(int colIdx) {
            Object level = this.getCachedValue("L" + colIdx);
            return level == null ? -1 : ((BigDecimal)level).intValue();
        }

        protected abstract void seekCachedRow(String var1, int var2) throws ExhibitionCacheException;

        protected abstract int getLeftHeadColumns();

        protected abstract int getCellColumns();

        protected abstract boolean hasNextCachedRow() throws ExhibitionCacheException;

        protected abstract void nextCachedRow() throws ExhibitionCacheException;

        protected abstract Object getCachedValue(String var1);
    }

    public static abstract class AbstractExhibitionCacheWriter
    extends RelatedConstant
    implements AbstractDomain.IExhibitionCacheWriter {
        @Override
        public abstract String createCacheKey();

        @Override
        public abstract void asyncCache(TableView var1, boolean var2);

        public final void cache(TableView tv) throws ExhibitionCacheException {
            List<Object[]> leftHead = tv.getLeftHead();
            int rows = leftHead.size();
            if (rows == 0) {
                return;
            }
            List<ICell[]> cells = tv.getCells();
            boolean hasCells = cells.size() > 0;
            int leftHeadColumns = leftHead.get(0).length;
            int cellsColumns = 0;
            if (hasCells) {
                cellsColumns = cells.get(0).length;
            }
            ExhibitionCacheException exception = null;
            try {
                this.cacheMeta(leftHeadColumns, cellsColumns);
                for (int i = 0; i < rows; ++i) {
                    this.cacheOneRowStart();
                    Object[] oneRowLeftHead = leftHead.get(i);
                    for (int j = 0; j < oneRowLeftHead.length; ++j) {
                        Object value = oneRowLeftHead[j];
                        String json = JsonUtil.encodeToString((Object)value);
                        this.cacheValue("H" + j, json);
                        if (!(value instanceof TreeNodeCell)) continue;
                        int level = ((TreeNodeCell)value).getLevel();
                        this.cacheValue("L" + j, level);
                    }
                    if (hasCells) {
                        ICell[] oneRowCells = cells.get(i);
                        for (int k = 0; k < oneRowCells.length; ++k) {
                            ICell value = oneRowCells[k];
                            String json = JsonUtil.encodeToString((Object)value);
                            this.cacheValue("C" + k, json);
                        }
                    }
                    this.cacheOneRowEnd();
                }
            }
            catch (ExhibitionCacheException e) {
                exception = e;
                throw e;
            }
            finally {
                this.cacheAllEnd((Exception)((Object)exception));
            }
        }

        protected abstract void cacheMeta(int var1, int var2) throws ExhibitionCacheException;

        protected abstract void cacheOneRowStart() throws ExhibitionCacheException;

        protected abstract void cacheValue(String var1, Object var2) throws ExhibitionCacheException;

        protected abstract void cacheOneRowEnd() throws ExhibitionCacheException;

        protected abstract void cacheAllEnd(Exception var1) throws ExhibitionCacheException;
    }

    private static abstract class RelatedConstant {
        protected static final String ROWNUM_FIELDNAME = "SE";
        protected static final String LEFT_HEAD_PREFIX = "H";
        protected static final String CELLS_PREFIX = "C";
        protected static final String TREE_LEVEL_PREFIX = "L";

        private RelatedConstant() {
        }
    }
}

