/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.export.chart.renderer.longer;

import com.kingdee.bos.qing.core.model.exhibition.common.chart.TreeChartModel;
import com.kingdee.bos.qing.core.model.exhibition.longer.cell.RectTreeCell;
import com.kingdee.bos.qing.export.chart.JsDrawChart;
import com.kingdee.bos.qing.export.chart.mock.Canvas;
import com.kingdee.bos.qing.export.chart.renderer.longer.AbstractCellRenderer;
import com.kingdee.bos.qing.export.common.exception.ExportJavaScriptException;
import com.kingdee.bos.qing.export.common.model.ExStyle;
import com.kingdee.bos.qing.util.LogUtil;
import java.awt.Graphics;

class CellRendererForRectTree
extends AbstractCellRenderer {
    CellRendererForRectTree() {
    }

    @Override
    public Object draw(AbstractCellRenderer.CellRenderParameter parameter) {
        Canvas value = null;
        try {
            Object cellModel = parameter.getCellModel();
            ExStyle style = parameter.getCellStyle();
            int canvasWidth = style.getWidth();
            int canvasHeight = style.getHeight();
            Graphics jdkGraphics = parameter.getJdkGraphics();
            if (cellModel instanceof RectTreeCell) {
                RectTreeCell rtc = (RectTreeCell)cellModel;
                TreeChartModel modelAtCell = rtc.getChart();
                String size = rtc.getSizeRatio();
                float sizeRatio = size == null ? 1.0f : Float.parseFloat(size);
                AbstractCellRenderer.ChartConfigAdpter cca = parameter.getChartConfig();
                value = JsDrawChart.getInstance().drawRectTree(canvasWidth, canvasHeight, modelAtCell, jdkGraphics, sizeRatio, cca.isShowLabel(), cca.getRectTreeChartConfig().isHideNegative());
            }
        }
        catch (ExportJavaScriptException e) {
            LogUtil.error((String)"Init JsDrawChart error.", (Throwable)((Object)e));
        }
        return value;
    }
}

