/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.export.chart.renderer.square;

import com.kingdee.bos.qing.core.exception.ExportException;
import com.kingdee.bos.qing.core.model.analysis.common.OutsideReference;
import com.kingdee.bos.qing.core.model.analysis.square.chart.property.AbstractChartProperty;
import com.kingdee.bos.qing.core.model.analysis.square.chart.property.MapChartProperty;
import com.kingdee.bos.qing.core.model.exhibition.common.chart.AbstractNormalChartModel;
import com.kingdee.bos.qing.export.common.exception.ExportIOException;
import com.kingdee.bos.qing.filesystem.manager.FileFactory;
import com.kingdee.bos.qing.filesystem.manager.api.IQingFile;
import com.kingdee.bos.qing.filesystem.manager.api.IWriteCall;
import com.kingdee.bos.qing.filesystem.manager.model.QingTempFileType;
import com.kingdee.bos.qing.filesystem.stream.QingInputStream;
import com.kingdee.bos.qing.map.MapLoader;
import com.kingdee.bos.qing.util.CloseUtil;
import com.kingdee.bos.qing.util.XmlUtil;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.imageio.ImageIO;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.image.PNGTranscoder;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.Namespace;
import org.jdom2.output.DOMOutputter;

public class ChartImgGeneratorForMap {
    public void writeImg(int width, int height, Object model, AbstractChartProperty chartProperty, IQingFile file, String imageType, InputStream backgroundImage, MapLoader.BackImage backImg) throws ExportException {
        MapChartProperty property = (MapChartProperty)chartProperty;
        Map<String, List<String>> regionMapping = property.getRegionMapping();
        AbstractNormalChartModel chartModel = (AbstractNormalChartModel)model;
        List<AbstractNormalChartModel.Category> categories = chartModel.getCategories();
        OutsideReference outsideReference = property.getOutsideReference();
        String refToId = outsideReference == null ? null : outsideReference.getRefToId();
        String refToFullPath = outsideReference == null ? null : outsideReference.getRefToFullPath();
        Document doc = this.getMapSvg(refToId, refToFullPath);
        Element svgNode = doc.getRootElement();
        Element graphicNode = svgNode.getChild("g");
        List nodes = graphicNode.getChildren("path");
        if (regionMapping != null) {
            for (AbstractNormalChartModel.Category category : categories) {
                String color;
                List<String> regions;
                String label = category.getLabel();
                if (label == null || (regions = regionMapping.get(label)) == null || (color = category.getColor()) == null) continue;
                for (String region : regions) {
                    for (Element node : nodes) {
                        if (!node.getAttribute("name").getValue().equals(region)) continue;
                        node.setAttribute("style", "fill:" + this.hslToHex(color) + ";fill-opacity:1");
                    }
                }
            }
        }
        if (backgroundImage != null && backImg != null) {
            this.transcodeSVGDomToIMG(doc, file, imageType, width, height, backgroundImage, backImg);
        } else {
            this.transcodeSVGDomToIMG(doc, file, imageType, width, height);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Document getMapSvg(String refToId, String refToFullPath) throws ExportException {
        Document e3222222;
        MapLoader.Reference ref = new MapLoader.Reference(refToId, refToFullPath);
        InputStream inStm = null;
        try {
            inStm = MapLoader.loadTemplate(ref);
        }
        catch (MapLoader.MapNotFoundException e2) {
            throw new ExportIOException("get map templete file failed", e2);
        }
        catch (MapLoader.MapLoaderException e3222222) {
            throw new ExportIOException("get map templete file failed", e3222222);
        }
        try {
            e3222222 = XmlUtil.loadDocument((InputStream)inStm);
        }
        catch (JDOMException e4) {
            try {
                throw new ExportIOException("build dom tree failed", (Exception)((Object)e4));
                catch (IOException e5) {
                    throw new ExportIOException("build dom tree failed", e5);
                }
            }
            catch (Throwable throwable) {
                CloseUtil.close((Closeable[])new Closeable[]{inStm});
                throw throwable;
            }
        }
        CloseUtil.close((Closeable[])new Closeable[]{inStm});
        return e3222222;
    }

    private void transcodeSVGDomToIMG(Document doc, IQingFile file, String imageType, int width, int height) throws ExportIOException {
        doc.getRootElement().setNamespace(Namespace.getNamespace((String)"http://www.w3.org/2000/svg"));
        org.w3c.dom.Document w3cDom = this.convertJDOMToDOM(doc);
        InputStream is = this.getDomInputStream(w3cDom);
        String str = new BufferedReader(new InputStreamReader(is)).lines().collect(Collectors.joining("\n"));
        str = str.replaceAll("xmlns=\"\"", "");
        is = new ByteArrayInputStream(str.getBytes());
        final TranscoderInput input = new TranscoderInput(is);
        final PNGTranscoder transcoder = new PNGTranscoder();
        transcoder.addTranscodingHint(PNGTranscoder.KEY_WIDTH, (Object)new Float(width));
        transcoder.addTranscodingHint(PNGTranscoder.KEY_HEIGHT, (Object)new Float(height));
        Object os = null;
        try {
            file.write(new IWriteCall(){

                public void call(OutputStream outputStream) throws IOException {
                    TranscoderOutput output = new TranscoderOutput(outputStream);
                    try {
                        transcoder.transcode(input, output);
                    }
                    catch (TranscoderException e) {
                        throw new IOException(e);
                    }
                }
            }, true);
        }
        catch (IOException e) {
            try {
                throw new ExportIOException(e);
            }
            catch (Throwable throwable) {
                CloseUtil.close((Closeable[])new Closeable[]{is});
                CloseUtil.close((Closeable[])new Closeable[]{os});
                throw throwable;
            }
        }
        CloseUtil.close((Closeable[])new Closeable[]{is});
        CloseUtil.close((Closeable[])new Closeable[]{os});
    }

    private void transcodeSVGDomToIMG(Document doc, IQingFile file, String imageType, int width, int height, InputStream backgroundImage, MapLoader.BackImage backImg) throws ExportIOException {
        IQingFile tempFile = FileFactory.newTempFile((QingTempFileType)QingTempFileType.EXPORT);
        this.transcodeSVGDomToIMG(doc, tempFile, imageType, width, height);
        QingInputStream fileInputStream = null;
        int pageHeight = backImg.getPageHeight();
        int pageWidth = backImg.getPageWidth();
        try {
            float pageWToHRatio = (float)pageWidth / (float)pageHeight;
            float thumbWToHRatio = (float)width / (float)height;
            int x = 0;
            int y = 0;
            int backWidth = width;
            int backHeight = height;
            if (pageWToHRatio > thumbWToHRatio) {
                backHeight = Math.round((float)width / pageWToHRatio);
                y = Math.round((float)(height - backHeight) / 2.0f);
            } else {
                backWidth = Math.round((float)height * pageWToHRatio);
                x = Math.round((float)(width - backWidth) / 2.0f);
            }
            BufferedImage backImageBuffer = ImageIO.read(backgroundImage);
            BufferedImage resizedImg = new BufferedImage(width, height, 1);
            Graphics2D g2d = resizedImg.createGraphics();
            final BufferedImage mergedImageBuffer = g2d.getDeviceConfiguration().createCompatibleImage(width, height, 3);
            g2d.dispose();
            g2d = mergedImageBuffer.createGraphics();
            g2d.drawImage(backImageBuffer, x, y, backWidth, backHeight, null);
            fileInputStream = tempFile.getInputStream();
            BufferedImage imageBuffer = ImageIO.read((InputStream)fileInputStream);
            g2d.drawImage(imageBuffer, 0, 0, width, height, null);
            g2d.dispose();
            file.write(new IWriteCall(){

                public void call(OutputStream outputStream) throws IOException {
                    ImageIO.write((RenderedImage)mergedImageBuffer, "png", outputStream);
                }
            }, true);
        }
        catch (IOException e) {
            try {
                throw new ExportIOException("draw map background failed", e);
            }
            catch (Throwable throwable) {
                CloseUtil.close((Closeable[])new Closeable[]{fileInputStream});
                tempFile.delete();
                throw throwable;
            }
        }
        CloseUtil.close((Closeable[])new Closeable[]{fileInputStream});
        tempFile.delete();
    }

    private InputStream getDomInputStream(org.w3c.dom.Document w3cDom) throws ExportIOException {
        DOMSource xmlSource = new DOMSource(w3cDom);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        StreamResult outputTarget = new StreamResult(outputStream);
        try {
            String factoryClassName = "com.sun.org.apache.xalan.internal.xsltc.trax.TransformerFactoryImpl";
            TransformerFactory factory = TransformerFactory.newInstance(factoryClassName, TransformerFactory.class.getClassLoader());
            factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            factory.newTransformer().transform(xmlSource, outputTarget);
        }
        catch (Exception e) {
            try {
                throw new ExportIOException("transform xml to outPutStream failed", e);
            }
            catch (Throwable throwable) {
                CloseUtil.close((Closeable[])new Closeable[]{outputStream});
                throw throwable;
            }
        }
        CloseUtil.close((Closeable[])new Closeable[]{outputStream});
        ByteArrayInputStream is = new ByteArrayInputStream(outputStream.toByteArray());
        return is;
    }

    private org.w3c.dom.Document convertJDOMToDOM(Document jdomDoc) throws ExportIOException {
        DOMOutputter outputter = new DOMOutputter();
        try {
            return outputter.output(jdomDoc);
        }
        catch (JDOMException e) {
            throw new ExportIOException("convert jdom to w3c dom failed", (Exception)((Object)e));
        }
    }

    private String hslToHex(String hsl) {
        if (!hsl.startsWith("hsl")) {
            return hsl;
        }
        hsl = hsl.trim();
        hsl = hsl.substring("hsl(".length(), hsl.length() - 1);
        String[] valueStrings = hsl.split(",");
        Float hue = Float.valueOf(valueStrings[0]);
        Float saturation = this.getFloatFromPercent(valueStrings[1]);
        Float lightness = this.getFloatFromPercent(valueStrings[2]);
        hue = Float.valueOf(hue.floatValue() / 360.0f);
        int[] rgbValue = this.hslToRgb(hue.floatValue(), saturation.floatValue(), lightness.floatValue());
        StringBuilder hex = new StringBuilder("#");
        for (int i = 0; i < rgbValue.length; ++i) {
            String oneHex = Integer.toHexString(rgbValue[i]);
            if (oneHex.length() == 1) {
                hex.append("0");
            }
            hex.append(oneHex);
        }
        return hex.toString();
    }

    private Float getFloatFromPercent(String value) {
        if (value.endsWith("%")) {
            value = value.substring(0, value.length() - 1);
            return Float.valueOf(Float.parseFloat(value) / 100.0f);
        }
        return Float.valueOf(value);
    }

    private int[] hslToRgb(float h, float s, float l) {
        float r;
        float g;
        float b;
        if (s == 0.0f) {
            g = b = l;
            r = b;
        } else {
            float q = l < 0.5f ? l * (1.0f + s) : l + s - l * s;
            float p = 2.0f * l - q;
            r = this.hueToRgb(p, q, h + 0.33333334f);
            g = this.hueToRgb(p, q, h);
            b = this.hueToRgb(p, q, h - 0.33333334f);
        }
        int[] rgb = new int[]{ChartImgGeneratorForMap.to255(r), ChartImgGeneratorForMap.to255(g), ChartImgGeneratorForMap.to255(b)};
        return rgb;
    }

    private float hueToRgb(float p, float q, float t) {
        if (t < 0.0f) {
            t += 1.0f;
        }
        if (t > 1.0f) {
            t -= 1.0f;
        }
        if (t < 0.16666667f) {
            return p + (q - p) * 6.0f * t;
        }
        if (t < 0.5f) {
            return q;
        }
        if (t < 0.6666667f) {
            return p + (q - p) * (0.6666667f - t) * 6.0f;
        }
        return p;
    }

    public static int to255(float v) {
        return (int)Math.min(255.0f, 256.0f * v);
    }
}

