/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.export.pdf.comp;

import com.kingdee.bos.qing.export.pdf.TableViewExportJob;
import com.kingdee.bos.qing.export.pdf.comp.BasicPainter;
import com.kingdee.bos.qing.export.pdf.comp.HFSystemVar;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.Paragraph;
import com.lowagie.text.pdf.ColumnText;
import com.lowagie.text.pdf.PdfContentByte;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HeaderFooter
extends BasicPainter {
    private static final int ROW_DISTANCE = 3;
    private static final int IDX_LEFT = 0;
    private static final int IDX_CENTER = 1;
    private static final int IDX_RIGHT = 2;
    private int index;
    private boolean isHeader;

    public HeaderFooter(int index, boolean isHeader, TableViewExportJob exportJob) {
        super(exportJob);
        this.index = index;
        this.isHeader = isHeader;
    }

    @Override
    public List<ColumnText> createContent(PdfContentByte pdfContentByte) {
        List<String[]> listHeaderFooter;
        ArrayList<ColumnText> cts = new ArrayList<ColumnText>();
        List<String[]> list = listHeaderFooter = this.isHeader ? this.model.getListHeaderRow() : this.model.getListFooterRow();
        if (listHeaderFooter != null) {
            String[] headfoot;
            int i;
            int maxLen = 0;
            if (this.isHeader) {
                for (i = 0; i < listHeaderFooter.size(); ++i) {
                    headfoot = listHeaderFooter.get(i);
                    if (headfoot == null || headfoot.length == 0 || maxLen >= headfoot.length) continue;
                    maxLen = headfoot.length;
                }
            }
            for (i = 0; i < listHeaderFooter.size(); ++i) {
                headfoot = listHeaderFooter.get(i);
                if (headfoot == null || headfoot.length == 0) continue;
                if (this.isHeader) {
                    if (maxLen > headfoot.length) {
                        headfoot = Arrays.copyOf(headfoot, maxLen);
                    }
                    cts.addAll(this.createHeader(pdfContentByte, i, headfoot));
                    continue;
                }
                cts.addAll(this.createFooter(pdfContentByte, i, headfoot));
            }
        }
        return cts;
    }

    private List<ColumnText> createHeader(PdfContentByte pdfContentByte, int i, String[] headfoot) {
        ArrayList<ColumnText> cts = new ArrayList<ColumnText>(headfoot.length);
        float y = this.getY();
        ColumnText ct = null;
        Font font = this.getFont();
        float textHeight = this.getTextHeight(null);
        for (int j = headfoot.length - 1; j >= 0; --j) {
            String text = headfoot[j];
            if (text == null || text.isEmpty()) {
                text = "";
            }
            text = this.parseHFSystemVar(text);
            Paragraph p = new Paragraph(text, font);
            this.setAlignment(p, i);
            ct = new ColumnText(pdfContentByte);
            if (j == headfoot.length - 1) {
                y += 21.0f;
            }
            ct.setSimpleColumn(this.getX(), 0.0f, this.getX() + this.getWidth(), y);
            ct.addElement((Element)p);
            cts.add(ct);
            y += textHeight + 3.0f;
        }
        return cts;
    }

    private List<ColumnText> createFooter(PdfContentByte pdfContentByte, int i, String[] headfoot) {
        ArrayList<ColumnText> cts = new ArrayList<ColumnText>(headfoot.length);
        float y = this.getY();
        ColumnText ct = null;
        Font font = this.getFont();
        float textHeight = this.getTextHeight(null);
        for (int j = 0; j < headfoot.length; ++j) {
            String text = headfoot[j];
            if (text == null || text.isEmpty()) {
                text = "";
            }
            text = this.parseHFSystemVar(text);
            Paragraph p = new Paragraph(text, font);
            this.setAlignment(p, i);
            ct = new ColumnText(pdfContentByte);
            ct.setSimpleColumn(this.getX(), -10.0f, this.getX() + this.getWidth(), y);
            ct.addElement((Element)p);
            cts.add(ct);
            y -= textHeight + 3.0f;
        }
        return cts;
    }

    private void setAlignment(Paragraph p, int index) {
        switch (index) {
            case 0: {
                p.setAlignment(0);
                break;
            }
            case 1: {
                p.setAlignment(1);
                break;
            }
            case 2: {
                p.setAlignment(2);
            }
        }
    }

    private String parseHFSystemVar(String headfoot) {
        Map<String, String> mapHFVar = this.exportJob.getMapHFVar();
        Pattern p = Pattern.compile("&\\[[a-zA-Z]+\\]");
        Matcher m = p.matcher(headfoot);
        while (m.find()) {
            String value;
            SimpleDateFormat format;
            String g = m.group();
            for (Map.Entry<String, String> entry : mapHFVar.entrySet()) {
                if (!entry.getKey().equalsIgnoreCase(g)) continue;
                headfoot = this.replaceValue(headfoot, g, entry.getValue());
                break;
            }
            if (HFSystemVar.DATE.getName().equalsIgnoreCase(g) && !mapHFVar.containsKey(HFSystemVar.DATE.getName())) {
                format = new SimpleDateFormat("yyyy-MM-dd");
                value = format.format(new Date());
                headfoot = this.replaceValue(headfoot, g, value);
                mapHFVar.put(HFSystemVar.DATE.getName(), value);
                continue;
            }
            if (HFSystemVar.TIME.getName().equalsIgnoreCase(g) && !mapHFVar.containsKey(HFSystemVar.TIME.getName())) {
                format = new SimpleDateFormat("HH:mm:ss");
                value = format.format(new Date());
                headfoot = this.replaceValue(headfoot, g, value);
                mapHFVar.put(HFSystemVar.TIME.getName(), value);
                continue;
            }
            if (HFSystemVar.PAGE.getName().equalsIgnoreCase(g)) {
                headfoot = this.replaceValue(headfoot, g, this.index + 1 + "");
                continue;
            }
            if (!HFSystemVar.PAGECOUNT.getName().equalsIgnoreCase(g) || mapHFVar.containsKey(HFSystemVar.PAGECOUNT.getName())) continue;
            String value2 = this.exportJob.getPageCount() + "";
            headfoot = this.replaceValue(headfoot, g, value2);
            mapHFVar.put(HFSystemVar.PAGECOUNT.getName(), value2);
        }
        return headfoot;
    }

    private String replaceValue(String src, String g, String value) {
        String regex = g.replace("[", "\\[").replace("]", "\\]");
        return src.replaceAll(regex, value);
    }
}

