/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.map.designer.model;

import com.kingdee.bos.qing.map.designer.exception.PersistentModelParseException;
import com.kingdee.bos.qing.map.designer.model.Path;
import com.kingdee.bos.qing.util.XmlUtil;
import java.util.ArrayList;
import java.util.List;
import org.jdom2.Content;
import org.jdom2.Element;

public class Layer {
    private String id;
    private String name;
    private List<Path> paths;

    public Layer() {
    }

    public Layer(String id, String name, List<Path> paths) {
        this.id = id;
        this.name = name;
        this.paths = paths;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public int getPathsCount() {
        return this.paths == null ? 0 : this.paths.size();
    }

    public Path getPath(int idx) {
        return this.paths.get(idx);
    }

    public Element toXml() {
        Element node = new Element("Layer");
        XmlUtil.writeAttrNotNull((Element)node, (String)"id", (String)this.id);
        XmlUtil.writeAttrNotNull((Element)node, (String)"name", (String)this.name);
        Element nodePaths = new Element("Paths");
        int c = this.paths.size();
        for (int i = 0; i < c; ++i) {
            Path path = this.paths.get(i);
            nodePaths.addContent((Content)path.toXml());
        }
        node.addContent((Content)nodePaths);
        return node;
    }

    public void fromXml(Element node) throws PersistentModelParseException {
        Element nodePaths;
        try {
            this.id = XmlUtil.readAttrNotNull((Element)node, (String)"id");
        }
        catch (XmlUtil.NullException e1) {
            throw PersistentModelParseException.createParseError("Path's id is missing.");
        }
        try {
            this.name = XmlUtil.readAttrNotNull((Element)node, (String)"name");
        }
        catch (XmlUtil.NullException e1) {
            throw PersistentModelParseException.createParseError("Path's name is missing.");
        }
        try {
            nodePaths = XmlUtil.getChildNotNull((Element)node, (String)"Paths");
        }
        catch (XmlUtil.NullException e) {
            throw PersistentModelParseException.createParseError("<Paths> not found.");
        }
        List pathNodes = XmlUtil.getChildren((Element)nodePaths);
        this.paths = new ArrayList<Path>(pathNodes.size());
        int c = pathNodes.size();
        for (int i = 0; i < c; ++i) {
            Element nodePath = (Element)pathNodes.get(i);
            Path path = new Path();
            path.fromXml(nodePath);
            this.paths.add(path);
        }
    }
}

