/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.data.domain.source;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.exception.AbstractQingIntegratedException;
import com.kingdee.bos.qing.common.grammar.IExecuteContext;
import com.kingdee.bos.qing.common.grammar.exception.ExecuteException;
import com.kingdee.bos.qing.common.grammar.expr.IExpr;
import com.kingdee.bos.qing.common.i18n.II18nContext;
import com.kingdee.bos.qing.common.i18n.Messages;
import com.kingdee.bos.qing.common.lock.QingLockRequireException;
import com.kingdee.bos.qing.data.domain.source.IDataSourceIterator;
import com.kingdee.bos.qing.data.domain.visitor.AbstractUnionEntityDirectModelDataSourceVisitor;
import com.kingdee.bos.qing.data.domain.visitor.EntitySingleDataSourceVisitorDelegate;
import com.kingdee.bos.qing.data.domain.visitor.SingleEntityDirectModelDataSourceVisitor;
import com.kingdee.bos.qing.data.exception.AbstractSourceException;
import com.kingdee.bos.qing.data.exception.SubjectDataModelingException;
import com.kingdee.bos.qing.data.exception.db.DBCenterNoPermissionException;
import com.kingdee.bos.qing.data.exception.db.DBCenterOwnerNoPermissionException;
import com.kingdee.bos.qing.data.exception.entity.EntityNotSupportQingAnalysisException;
import com.kingdee.bos.qing.data.exception.entity.NoEntityPermissionException;
import com.kingdee.bos.qing.data.model.designtime.AbstractEntity;
import com.kingdee.bos.qing.data.model.designtime.AbstractSource;
import com.kingdee.bos.qing.data.model.designtime.Box;
import com.kingdee.bos.qing.data.model.designtime.CustomSystemVarValue;
import com.kingdee.bos.qing.data.model.designtime.Entity;
import com.kingdee.bos.qing.data.model.designtime.EntityErrorInfo;
import com.kingdee.bos.qing.data.model.designtime.EntityErrorState;
import com.kingdee.bos.qing.data.model.designtime.Property;
import com.kingdee.bos.qing.data.model.designtime.TreeProperty;
import com.kingdee.bos.qing.data.model.designtime.UnionEntity;
import com.kingdee.bos.qing.data.model.designtime.formula.FormulaExecuteContext;
import com.kingdee.bos.qing.data.model.designtime.source.AbstractBizMetaSource;
import com.kingdee.bos.qing.data.model.designtime.source.DBSource;
import com.kingdee.bos.qing.data.model.runtime.CompareFilter;
import com.kingdee.bos.qing.data.model.runtime.IRuntimeFilter;
import com.kingdee.bos.qing.data.model.runtime.LogicalFilter;
import com.kingdee.bos.qing.data.model.runtime.ProgressProcessor;
import com.kingdee.bos.qing.data.model.runtime.RuntimeEntity;
import com.kingdee.bos.qing.data.model.runtime.RuntimeFilterUtil;
import com.kingdee.bos.qing.data.model.runtime.RuntimeProperty;
import com.kingdee.bos.qing.data.model.runtime.process.FixEntityFilterItemWithParentRuntimeProcess;
import com.kingdee.bos.qing.data.model.runtime.process.IParentEntityFilterProcessor;
import com.kingdee.bos.qing.data.model.runtime.process.ITreePropertyProcessor;
import com.kingdee.bos.qing.data.model.vo.AbstractNode;
import com.kingdee.bos.qing.data.model.vo.DesigntimeDataObject;
import com.kingdee.bos.qing.data.model.vo.PreviewDataModel;
import com.kingdee.bos.qing.data.util.AbstractConverter;
import com.kingdee.bos.qing.data.util.PropertyAssociateNameKeySelector;
import com.kingdee.bos.qing.datasource.exception.AbstractDataSourceException;
import com.kingdee.bos.qing.datasource.exception.DataSourceAccessException;
import com.kingdee.bos.qing.datasource.exception.DataSourcePersistenceException;
import com.kingdee.bos.qing.datasource.meta.DSMetaEntity;
import com.kingdee.bos.qing.datasource.meta.DataType;
import com.kingdee.bos.qing.datasource.meta.MetaInfo;
import com.kingdee.bos.qing.datasource.spec.AbstractSingleDataSourceVisitor;
import com.kingdee.bos.qing.datasource.spec.IDataSourceWriter;
import com.kingdee.bos.qing.macro.domain.DesignTimeMacroRegister;
import com.kingdee.bos.qing.macro.domain.ICollectBizMetaSourceRefMacro;
import com.kingdee.bos.qing.macro.util.MacroFormatHelper;
import com.kingdee.bos.qing.util.LogUtil;
import com.kingdee.bos.qing.util.MapUtils;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;

public abstract class AbstractDataSourceDomain {
    public abstract AbstractNode getUsableEntities(QingContext var1, AbstractSource var2) throws AbstractSourceException, AbstractQingIntegratedException;

    public void checkEntityPermission(QingContext qingContext, Entity entity) throws NoEntityPermissionException {
    }

    public void checkEntityPermission(QingContext qingContext, Entity entity, AbstractSource source) throws NoEntityPermissionException {
    }

    public void checkDBCenterPermission(QingContext qingContext, Entity entity) throws DBCenterNoPermissionException, DBCenterOwnerNoPermissionException {
    }

    public boolean supportEntityFixOnSchedule() {
        return false;
    }

    public void checkSupportQingAnalysis(QingContext qingContext, Entity entity) throws EntityNotSupportQingAnalysisException {
    }

    public String getEntityTitle(QingContext qingContext, AbstractEntity entity) {
        String prefix = Messages.getMLS((II18nContext)qingContext.getIi18nContext(), (String)"initialName", (String)"\u521d\u59cb\u540d\u79f0", (Messages.ProjectName)Messages.ProjectName.QING_DATA);
        return prefix + ":" + entity.getAssociateName();
    }

    public abstract long getDataCount(QingContext var1, RuntimeEntity var2) throws AbstractSourceException, AbstractQingIntegratedException;

    public abstract PreviewDataModel getPreviewData(QingContext var1, RuntimeEntity var2, int var3) throws AbstractSourceException, AbstractQingIntegratedException;

    public abstract DesigntimeDataObject getDesigntimeDataObject(QingContext var1, AbstractSource var2, String var3) throws AbstractSourceException, AbstractQingIntegratedException;

    public final boolean isDataFieldUnique(QingContext qingContext, Entity entity, String fieldName, Map<String, AbstractEntity> entityMap, AbstractSource source) throws AbstractSourceException, AbstractQingIntegratedException {
        return true;
    }

    public RuntimeEntity newRuntimeEntity(AbstractEntity designtimeDataObject, Map<String, AbstractEntity> entityMap, Set<String> whitePropertySet, AbstractSource source, QingContext qingContext, String ownerId) {
        return new RuntimeEntity(designtimeDataObject, whitePropertySet, source, qingContext, ownerId);
    }

    public abstract void checkSourceLegality(QingContext var1, AbstractSource var2, List<Entity> var3, AbstractDataSourceDomain var4);

    public void setEntityErrorState(QingContext qingContext, List<Entity> entityArrayList, EntityErrorState errorState) {
        if (!entityArrayList.isEmpty()) {
            for (Entity entity : entityArrayList) {
                EntityErrorInfo entityErrorInfo = new EntityErrorInfo(errorState);
                String msg = errorState.getI18n(qingContext);
                entityErrorInfo.setErrorDesc(msg);
                entityErrorInfo.setEntityName(entity.getName());
                entity.setErrorInfo(entityErrorInfo);
            }
        }
    }

    protected void setEntityErrorState(QingContext qingContext, List<Entity> entityArrayList, EntityErrorState errorState, AbstractSourceException e) {
        if (!entityArrayList.isEmpty()) {
            for (Entity entity : entityArrayList) {
                EntityErrorInfo entityErrorInfo = new EntityErrorInfo(errorState);
                String msg = errorState.getI18n(qingContext);
                entityErrorInfo.setErrorDesc(msg.replace("#1", e.getMessage()));
                entityErrorInfo.setEntityName(entity.getName());
                entity.setErrorInfo(entityErrorInfo);
            }
        }
    }

    protected abstract boolean isDataFieldUnique(QingContext var1, RuntimeEntity var2, RuntimeProperty var3) throws AbstractSourceException, AbstractQingIntegratedException;

    public abstract String extractData(QingContext var1, IDataSourceWriter var2, RuntimeEntity var3, ProgressProcessor var4) throws DataSourcePersistenceException, AbstractSourceException, AbstractQingIntegratedException, InterruptedException, QingLockRequireException;

    public void initEntityTitle(QingContext qingContext, Entity entity, AbstractSource source) {
        entity.setTitle(this.getEntityTitle(qingContext, entity));
    }

    public void addDataSourceCloseListener(IDataSourceWriter dataSourceWriter, RuntimeEntity runtimeEntity) {
    }

    public static final Map<String, Object> getRowDataAfterCalculateAndFilter(Map<String, Object> primaryRowData, RuntimeEntity runtimeEntity) {
        Map<String, Object> outputRowData = AbstractDataSourceDomain.convertPriDataToUserOutputType(primaryRowData, runtimeEntity);
        AbstractDataSourceDomain.calculatePropertyValue(primaryRowData, outputRowData, runtimeEntity);
        IRuntimeFilter runtimeFilter = runtimeEntity.getUnPushdownableFilter();
        if (runtimeFilter == null || runtimeFilter.innerExcuteFilter(primaryRowData, outputRowData)) {
            return outputRowData;
        }
        return null;
    }

    private static void calculatePropertyValue(Map<String, Object> primaryRowData, Map<String, Object> outputRowData, RuntimeEntity runtimeEntity) {
        List<RuntimeProperty> outputCalculateProperties = runtimeEntity.getOutputCalculateProperties();
        if (outputCalculateProperties != null && !outputCalculateProperties.isEmpty()) {
            FormulaExecuteContext executeContext = new FormulaExecuteContext();
            executeContext.bindData(outputRowData);
            executeContext.setCalculatePropertiesMap(runtimeEntity.getCalculatePropertiesMap());
            executeContext.setPriPropertiesMap(runtimeEntity.getSelectedPriPropertyMap());
            executeContext.setAllPropertiesMap(runtimeEntity.getAllPropertiesMap());
            executeContext.setI18nContext(runtimeEntity.getQingContext().getIi18nContext());
            for (RuntimeProperty outputCalculateProperty : outputCalculateProperties) {
                Object primaryColumnValue;
                String outputCalculatePropertyName;
                block4: {
                    outputCalculatePropertyName = outputCalculateProperty.getName();
                    if (outputRowData.containsKey(outputCalculatePropertyName)) continue;
                    IExpr expr = outputCalculateProperty.getExpr();
                    primaryColumnValue = null;
                    try {
                        primaryColumnValue = expr.execute((IExecuteContext)executeContext);
                    }
                    catch (ExecuteException e) {
                        if (!LogUtil.isDebugEnabled()) break block4;
                        LogUtil.debug((String)(outputCalculateProperty.getName() + "\u5b57\u6bb5\u5b57\u6bb5\u9519\u8bef"), (Throwable)e);
                    }
                }
                primaryRowData.put(outputCalculatePropertyName, primaryColumnValue);
                DataType outputCalculatePropertyInputDataType = outputCalculateProperty.getInputDataType();
                DataType outputCalculatePropertyOutputDataType = outputCalculateProperty.getOutputDataType();
                Object outputCalculatePropertyValue = AbstractConverter.convert((DataType)outputCalculatePropertyInputDataType, (DataType)outputCalculatePropertyOutputDataType, (Object)primaryColumnValue);
                outputRowData.put(outputCalculatePropertyName, outputCalculatePropertyValue);
            }
        }
    }

    private static Map<String, Object> convertPriDataToUserOutputType(Map<String, Object> primaryRowData, RuntimeEntity runtimeEntity) {
        List<RuntimeProperty> needToChangeTypeSelectedPriProperties = runtimeEntity.getNeedToChangeTypeSelectedPriProperties();
        if (!needToChangeTypeSelectedPriProperties.isEmpty()) {
            HashMap<String, Object> outputRowData = new HashMap<String, Object>(16);
            outputRowData.putAll(primaryRowData);
            for (RuntimeProperty property : needToChangeTypeSelectedPriProperties) {
                DataType inputdataType = property.getInputDataType();
                DataType outputDataType = property.getOutputDataType();
                String columnName = property.getName();
                Object primaryColumnValue = primaryRowData.get(columnName);
                if (inputdataType == outputDataType) continue;
                Boolean isMulBasedataField = property.getProperty().getExtensionValue("isMulBasedataField", Boolean.class);
                Object columnValue = null != isMulBasedataField && isMulBasedataField != false ? null : AbstractConverter.convert((DataType)inputdataType, (DataType)outputDataType, (Object)primaryColumnValue);
                outputRowData.put(columnName, columnValue);
            }
            return outputRowData;
        }
        return primaryRowData;
    }

    public static Object[] getOutputData(Map<String, Object> calculatedRowData, RuntimeEntity runtimeEntity, boolean isPreview) {
        if (calculatedRowData != null) {
            List<RuntimeProperty> outputProperties = runtimeEntity.getOutputProperties();
            int columnSize = outputProperties.size();
            Object[] oneRowData = new Object[columnSize];
            for (int columnIndxe = 0; columnIndxe < columnSize; ++columnIndxe) {
                Object value;
                RuntimeProperty property = outputProperties.get(columnIndxe);
                if (property.isInvalid4Union() || null == (value = calculatedRowData.get(property.getName()))) continue;
                if (isPreview) {
                    if (value instanceof Calendar) {
                        value = ((Calendar)value).getTimeInMillis();
                    } else if (value instanceof Date) {
                        value = ((Date)value).getTime();
                    } else if (value instanceof Long) {
                        value = value.toString();
                    }
                }
                oneRowData[columnIndxe] = value;
            }
            return oneRowData;
        }
        return null;
    }

    public String scanAllEntity(QingContext qingContext, AbstractSource source) throws SubjectDataModelingException, AbstractQingIntegratedException {
        throw new UnsupportedOperationException("unsupport scanAllEntity:" + source.getType().toPersistance());
    }

    public RuntimeFilterUtil.Prediction initRuntimeFilter(RuntimeEntity runtimeEntity) {
        RuntimeFilterUtil.Prediction prediction = new RuntimeFilterUtil.Prediction();
        runtimeEntity.initFilter(CompareFilter.class, LogicalFilter.class, prediction);
        return prediction;
    }

    public IDataSourceIterator createDataSourceIterator(QingContext qingContext, RuntimeEntity runtimeEntity) throws AbstractSourceException {
        throw new UnsupportedOperationException("unsupport createDataSourceIterator :" + runtimeEntity.getSource().getType().toPersistance());
    }

    public AbstractUnionEntityDirectModelDataSourceVisitor createDirectDataSourceVisitor(QingContext qingContext, AbstractSource source, UnionEntity unionEntity, DSMetaEntity dsMetaEntity, Set<String> whitePropertySet, String ownerId) throws DataSourceAccessException {
        throw new DataSourceAccessException("unsupport Direct Model DataSourceVisitor :" + source.getType().toPersistance());
    }

    public SingleEntityDirectModelDataSourceVisitor createDirectModelDataSourceVisitor(QingContext qingContext, AbstractSource source, Entity entity, DSMetaEntity dsMetaEntity, Set<String> whitePropertySet, String ownerId) throws AbstractDataSourceException {
        return new SingleEntityDirectModelDataSourceVisitor(qingContext, source, entity, dsMetaEntity, whitePropertySet, ownerId);
    }

    public AbstractSingleDataSourceVisitor createEntityExtractModelDataSourceVisitor(AbstractEntity abstractEntity, DSMetaEntity dsMetaEntity, AbstractSingleDataSourceVisitor dataSourceVisitor) {
        return new EntitySingleDataSourceVisitorDelegate(abstractEntity, dsMetaEntity, dataSourceVisitor);
    }

    public void fixRuntimeExtractModeDSMetaEntity(AbstractEntity entity, DSMetaEntity dsMetaEntity, MetaInfo metaInfo) {
    }

    public List<Property> fixLocalEntityPropertyFromLive(Entity local, Entity live, boolean removeIfNotExist) {
        if (null == live) {
            return null;
        }
        Map livePropertyAssociateNameWithPropertyMap = MapUtils.collectionToMap(live.getProperties(), (MapUtils.IMapKeySelector)new PropertyAssociateNameKeySelector());
        Iterator<Property> it = local.getProperties().iterator();
        ArrayList<Property> removed = new ArrayList<Property>();
        while (it.hasNext()) {
            Property prop = it.next();
            if (prop.isCalculation()) continue;
            Property liveProp = (Property)livePropertyAssociateNameWithPropertyMap.get(prop.getAssociateName());
            if (liveProp != null) {
                this.syncLocalPropertyFromLiveProperty(prop, liveProp);
                continue;
            }
            if (!removeIfNotExist) {
                prop.setNotExisted(true);
                continue;
            }
            if (!this.isNeedRemoveNotExistedProperty(local, prop)) continue;
            it.remove();
            removed.add(prop);
        }
        this.syncTreePropertyFromLiveEntity(local, live);
        return removed;
    }

    private void syncTreePropertyFromLiveEntity(Entity local, Entity myLiveEntity) {
        ArrayList<TreeProperty> treeProperties = new ArrayList<TreeProperty>();
        List<TreeProperty> liveTreeProps = myLiveEntity.getTreeNodeProperties();
        for (TreeProperty liveTreeProp : liveTreeProps) {
            Property localProp = local.getPropertyByAssociateName(liveTreeProp.getInnerProp().getAssociateName());
            if (null == localProp) continue;
            TreeProperty localTreeProperty = new TreeProperty(localProp, liveTreeProp.createCopyChildren(), liveTreeProp.getTreeType());
            treeProperties.add(localTreeProperty);
        }
        local.setTreeNodeProperties(treeProperties);
    }

    protected boolean isNeedRemoveNotExistedProperty(Entity local, Property notExistProp) {
        return true;
    }

    protected void syncLocalPropertyFromLiveProperty(Property local, Property live) {
        if (local.getDataType() != live.getDataType()) {
            local.setDataType(live.getDataType());
        }
        local.setEnumValue(live.getEnumValue());
        local.setForeignKey(live.getForeignKey());
        local.getExtensionProps().putAll(live.getExtensionProps());
    }

    public void fixHistoryErrorEntity(QingContext qingContext, Box box, Entity dmEntity, Map<String, DesigntimeDataObject> designtimeDataObjectMap) {
    }

    public void fixHistoryErrorEntity(QingContext qingContext, AbstractDataSourceDomain sourceDomain, Entity dmEntity, AbstractSource source) {
    }

    public void fixEntityExtension(QingContext qingContext, Entity local, DesigntimeDataObject designtimeDataObject) {
    }

    public void fixEntityPkFilterItem(Entity target) {
    }

    public ITreePropertyProcessor createTreePropertyProcessor() {
        return null;
    }

    public IParentEntityFilterProcessor createParentFilterProcessor() {
        return new FixEntityFilterItemWithParentRuntimeProcess(this);
    }

    public void appendParentEntityMetaField(Property parentProperty, Entity currentEntity, Entity parentEntity) {
    }

    public boolean canEntityChangeOnline() {
        return true;
    }

    public boolean isDesignDataObjCachable() {
        return false;
    }

    public Set<String> getCustomSystemVarValue(QingContext qingContex, AbstractSource source, RuntimeEntity runtimeEntity, RuntimeProperty runtimeProperty, CustomSystemVarValue customSystemVarValue) throws AbstractSourceException {
        return Collections.emptySet();
    }

    protected List<String> parseSqlOutMacroVals(AbstractSource source, String sourceName) {
        ArrayList<String> macroIds = new ArrayList<String>(8);
        if (source instanceof DBSource) {
            List userSQLs = ((DBSource)source).getUserSqls();
            if (userSQLs != null) {
                for (DBSource.UserSQL userSQL : userSQLs) {
                    if (!userSQL.getName().equals(sourceName)) continue;
                    String sql = userSQL.getContent();
                    Matcher matcher = MacroFormatHelper.matcher((String)sql);
                    ArrayList<String> list = new ArrayList<String>(8);
                    while (matcher.find()) {
                        list.add(matcher.group());
                    }
                    macroIds.addAll(list);
                    break;
                }
            }
        } else if (source instanceof AbstractBizMetaSource) {
            ICollectBizMetaSourceRefMacro collector = DesignTimeMacroRegister.getBizMetaSourceMacroRefCollector();
            List collectedIds = collector.collectMacroUId((AbstractBizMetaSource)source, sourceName);
            macroIds.addAll(collectedIds);
        }
        return macroIds;
    }
}

