/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.data.domain.source;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.grammar.IExecuteContext;
import com.kingdee.bos.qing.common.grammar.exception.ExecuteException;
import com.kingdee.bos.qing.common.grammar.expr.IExpr;
import com.kingdee.bos.qing.common.strategy.CustomStrategyRegistrar;
import com.kingdee.bos.qing.data.domain.source.IDataSourceIterator;
import com.kingdee.bos.qing.data.domain.source.bizmeta.strategy.IEnumValueStrategy;
import com.kingdee.bos.qing.data.model.designtime.formula.FormulaExecuteContext;
import com.kingdee.bos.qing.data.model.runtime.IRuntimeFilter;
import com.kingdee.bos.qing.data.model.runtime.RuntimeEntity;
import com.kingdee.bos.qing.data.model.runtime.RuntimeProperty;
import com.kingdee.bos.qing.data.util.AbstractConverter;
import com.kingdee.bos.qing.datasource.meta.DataType;
import com.kingdee.bos.qing.util.LogUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class AbstractDataSourceIterator
implements IDataSourceIterator {
    protected QingContext qingContext;
    protected RuntimeEntity runtimeEntity;

    public AbstractDataSourceIterator(QingContext qingContext, RuntimeEntity runtimeEntity) {
        this.qingContext = qingContext;
        this.runtimeEntity = runtimeEntity;
    }

    protected static final Map<String, Object> getRowDataAfterCalculateAndFilter(Map<String, Object> primaryRowData, RuntimeEntity runtimeEntity) {
        Map<String, Object> outputRowData = AbstractDataSourceIterator.convertPriDataToUserOutputType(primaryRowData, runtimeEntity);
        AbstractDataSourceIterator.calculatePropertyValue(primaryRowData, outputRowData, runtimeEntity);
        IRuntimeFilter runtimeFilter = runtimeEntity.getUnPushdownableFilter();
        if (runtimeFilter == null || runtimeFilter.innerExcuteFilter(primaryRowData, outputRowData)) {
            return outputRowData;
        }
        return null;
    }

    private static void calculatePropertyValue(Map<String, Object> primaryRowData, Map<String, Object> outputRowData, RuntimeEntity runtimeEntity) {
        List<RuntimeProperty> outputCalculateProperties = runtimeEntity.getOutputCalculateProperties();
        if (outputCalculateProperties != null && !outputCalculateProperties.isEmpty()) {
            FormulaExecuteContext executeContext = new FormulaExecuteContext();
            executeContext.bindData(outputRowData);
            executeContext.setCalculatePropertiesMap(runtimeEntity.getCalculatePropertiesMap());
            executeContext.setPriPropertiesMap(runtimeEntity.getSelectedPriPropertyMap());
            executeContext.setAllPropertiesMap(runtimeEntity.getAllPropertiesMap());
            for (RuntimeProperty outputCalculateProperty : outputCalculateProperties) {
                Object primaryColumnValue;
                String outputCalculatePropertyName;
                block4: {
                    outputCalculatePropertyName = outputCalculateProperty.getName();
                    if (outputRowData.containsKey(outputCalculatePropertyName)) continue;
                    IExpr expr = outputCalculateProperty.getExpr();
                    primaryColumnValue = null;
                    try {
                        primaryColumnValue = expr.execute((IExecuteContext)executeContext);
                    }
                    catch (ExecuteException e) {
                        if (!LogUtil.isDebugEnabled()) break block4;
                        LogUtil.debug((String)(outputCalculateProperty.getName() + "\u5b57\u6bb5\u5b57\u6bb5\u9519\u8bef"), (Throwable)e);
                    }
                }
                primaryRowData.put(outputCalculatePropertyName, primaryColumnValue);
                DataType outputCalculatePropertyInputDataType = outputCalculateProperty.getInputDataType();
                DataType outputCalculatePropertyOutputDataType = outputCalculateProperty.getOutputDataType();
                Object outputCalculatePropertyValue = AbstractConverter.convert((DataType)outputCalculatePropertyInputDataType, (DataType)outputCalculatePropertyOutputDataType, (Object)primaryColumnValue);
                outputRowData.put(outputCalculatePropertyName, outputCalculatePropertyValue);
            }
        }
    }

    private static Map<String, Object> convertPriDataToUserOutputType(Map<String, Object> primaryRowData, RuntimeEntity runtimeEntity) {
        List<RuntimeProperty> needToChangeTypeSelectedPriProperties = runtimeEntity.getNeedToChangeTypeSelectedPriProperties();
        if (!needToChangeTypeSelectedPriProperties.isEmpty()) {
            HashMap<String, Object> outputRowData = new HashMap<String, Object>();
            outputRowData.putAll(primaryRowData);
            for (RuntimeProperty property : needToChangeTypeSelectedPriProperties) {
                DataType inputdataType = property.getInputDataType();
                DataType outputDataType = property.getOutputDataType();
                String columnName = property.getName();
                Object primaryColumnValue = primaryRowData.get(columnName);
                Map<String, String> enumValueMap = property.getEnumValue();
                if (enumValueMap != null && primaryColumnValue != null) {
                    String primaryColumnValueStr = String.valueOf(primaryColumnValue);
                    IEnumValueStrategy enumValueStrategyService = (IEnumValueStrategy)CustomStrategyRegistrar.getStrategy(IEnumValueStrategy.class);
                    primaryColumnValue = enumValueStrategyService != null ? enumValueStrategyService.handEnumValue(enumValueMap, primaryColumnValueStr) : enumValueMap.get(primaryColumnValueStr);
                    outputRowData.put(columnName, primaryColumnValue);
                }
                if (inputdataType.equals((Object)outputDataType)) continue;
                Object columnValue = AbstractConverter.convert((DataType)inputdataType, (DataType)outputDataType, (Object)primaryColumnValue);
                outputRowData.put(columnName, columnValue);
            }
            return outputRowData;
        }
        return primaryRowData;
    }
}

