/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.data.domain.source.api.http;

import com.kingdee.bos.qing.common.context.QingContext;
import com.kingdee.bos.qing.common.i18n.Messages;
import com.kingdee.bos.qing.data.domain.source.db.util.SQLHelper;
import com.kingdee.bos.qing.data.exception.api.OpenAPIException;
import com.kingdee.bos.qing.util.HttpUtil;
import com.kingdee.bos.qing.util.LogUtil;
import com.kingdee.bos.qing.util.StackTraceUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;

public class RESTfulHttp {
    private static final String CODE = "UTF-8";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String checkConnectable(String url, Map<String, String> headers, Map<String, Object> params) {
        HttpClient httpClient = HttpUtil.createIgnoreSSLHttpClient();
        BufferedReader in = null;
        try {
            Object e22;
            HttpPost httpPost = null;
            try {
                httpPost = new HttpPost(url);
            }
            catch (Exception e) {
                String string = StackTraceUtil.getStackTrace((Throwable)e.fillInStackTrace());
                httpClient.getConnectionManager().shutdown();
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (Exception e22) {
                    LogUtil.error((String)"fail to check connectable", (Throwable)e22);
                }
                return string;
            }
            if (headers != null) {
                for (Map.Entry<String, String> entry : headers.entrySet()) {
                    httpPost.setHeader(entry.getKey(), entry.getValue());
                }
            }
            HttpResponse response = null;
            try {
                if (params != null) {
                    ArrayList<BasicNameValuePair> pairList = new ArrayList<BasicNameValuePair>(params.size());
                    e22 = params.entrySet().iterator();
                    while (e22.hasNext()) {
                        Map.Entry<String, Object> entry;
                        BasicNameValuePair pair = new BasicNameValuePair(entry.getKey(), (entry = e22.next()).getValue() == null ? "" : entry.getValue().toString());
                        pairList.add(pair);
                    }
                    httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(pairList, Charset.forName(CODE)));
                }
                RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(1000).setConnectionRequestTimeout(2000).build();
                httpPost.setConfig(requestConfig);
                response = httpClient.execute((HttpUriRequest)httpPost);
            }
            catch (Exception e) {
                String e22 = StackTraceUtil.getStackTrace((Throwable)e.fillInStackTrace());
                httpClient.getConnectionManager().shutdown();
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (Exception e23) {
                    LogUtil.error((String)"fail to check connectable", (Throwable)e23);
                }
                return e22;
            }
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode != 200) {
                String line;
                if (statusCode == 401) {
                    e22 = "401";
                    return e22;
                }
                StringBuffer result = new StringBuffer();
                in = new BufferedReader(new InputStreamReader(response.getEntity().getContent(), CODE));
                while ((line = in.readLine()) != null) {
                    result.append(line);
                }
                String string = result.toString();
                return string;
            }
        }
        catch (IOException e) {
            LogUtil.error((String)"postByJson() occours an exception!", (Throwable)e);
        }
        finally {
            httpClient.getConnectionManager().shutdown();
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception e2) {
                LogUtil.error((String)"fail to check connectable", (Throwable)e2);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String post(QingContext qingContext, String url, Map<String, String> headers, Map<String, Object> params, Boolean checkResponseLengthFlag) throws OpenAPIException {
        String result;
        url = SQLHelper.openAPISystemVarTransformToSql((QingContext)qingContext, (String)url);
        HttpClient httpClient = HttpUtil.createIgnoreSSLHttpClient();
        try {
            HttpPost httpPost = new HttpPost(url);
            if (headers != null) {
                for (Map.Entry<String, String> entry : headers.entrySet()) {
                    httpPost.setHeader(entry.getKey(), entry.getValue());
                }
            }
            try {
                if (params != null) {
                    ArrayList<BasicNameValuePair> pairList = new ArrayList<BasicNameValuePair>(params.size());
                    for (Map.Entry<String, Object> entry : params.entrySet()) {
                        BasicNameValuePair pair = new BasicNameValuePair(entry.getKey(), entry.getValue().toString());
                        pairList.add(pair);
                    }
                    httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(pairList, Charset.forName(CODE)));
                }
                RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(1000).setConnectionRequestTimeout(2000).build();
                httpPost.setConfig(requestConfig);
                HttpResponse httpResponse = httpClient.execute((HttpUriRequest)httpPost);
                HttpEntity httpEntity = httpResponse.getEntity();
                if (checkResponseLengthFlag.booleanValue()) {
                    Long contentLengthLimit = Long.parseLong(System.getProperty("qing.openapi.response.contentlengthlimit", "10")) * 1024L * 1024L;
                    if (httpEntity.getContentLength() > contentLengthLimit) {
                        String errorMsg = RESTfulHttp.getOverContentLengthErrorMsg(qingContext, contentLengthLimit);
                        throw new OpenAPIException(2061101, errorMsg);
                    }
                }
                result = EntityUtils.toString((HttpEntity)httpEntity, (String)CODE);
                EntityUtils.consume((HttpEntity)httpEntity);
            }
            catch (IOException e) {
                result = StackTraceUtil.getStackTrace((Throwable)e.fillInStackTrace());
            }
        }
        finally {
            httpClient.getConnectionManager().shutdown();
        }
        return result;
    }

    private static String getOverContentLengthErrorMsg(QingContext qingContext, Long contentLengthLimit) {
        String errorMsg = Messages.getMLS((QingContext)qingContext, (String)String.valueOf(2061101), (String)"\u7f51\u7edc\u6216\u670d\u52a1\u5668\u5f02\u5e38", (Messages.ProjectName)Messages.ProjectName.QING_DATA);
        StringBuilder errorMsgSb = new StringBuilder(errorMsg);
        String greaterThanMsg = Messages.getMLS((QingContext)qingContext, (String)"greaterThan", (String)"\u5927\u4e8e\u4e86", (Messages.ProjectName)Messages.ProjectName.QING_DATA);
        errorMsgSb.append("(").append(greaterThanMsg).append(String.valueOf(contentLengthLimit / 0x100000L)).append("M)");
        return errorMsgSb.toString();
    }
}

