/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.data.domain.source.api.parser;

import com.kingdee.bos.qing.data.exception.ModelParseException;
import com.kingdee.bos.qing.data.exception.api.OpenAPIException;
import com.kingdee.bos.qing.data.model.designtime.DesigningDataType;
import com.kingdee.bos.qing.data.model.designtime.Entity;
import com.kingdee.bos.qing.data.model.designtime.Property;
import com.kingdee.bos.qing.data.model.designtime.source.OpenAPISource;
import com.kingdee.bos.qing.data.model.runtime.api.APIField;
import com.kingdee.bos.qing.data.model.runtime.api.APITable;
import com.kingdee.bos.qing.data.model.vo.AbstractNode;
import com.kingdee.bos.qing.data.model.vo.DesigntimeDataObject;
import com.kingdee.bos.qing.data.model.vo.FolderNode;
import com.kingdee.bos.qing.data.model.vo.LeafNode;
import com.kingdee.bos.qing.util.StackTraceUtil;
import java.util.ArrayList;

public class ProgramDataSetResultParseTool {
    public static AbstractNode getUsableEntities(DesigntimeDataObject designtimeDataObject) {
        FolderNode root = new FolderNode();
        LeafNode leafNode = new LeafNode();
        String alias = designtimeDataObject.getEntities().get(0).getAlias();
        String name = designtimeDataObject.getEntities().get(0).getName();
        leafNode.setName(name);
        leafNode.setDisplayName(alias);
        leafNode.setCommentInfo(alias);
        leafNode.setType("table");
        root.addChild((AbstractNode)leafNode);
        return root;
    }

    public static DesigntimeDataObject getDesigntimeDataObject(APITable apiTable, OpenAPISource openAPISource, String associateName) throws OpenAPIException {
        ArrayList<Entity> entities = new ArrayList<Entity>();
        Entity entity = new Entity();
        entity.setSource(openAPISource.getName());
        entity.setUnionUnit(false);
        entity.setName(apiTable.getName());
        entity.setAlias(apiTable.getAlias());
        entity.setAssociateName(apiTable.getName());
        entity.setCommentInfo(apiTable.getAlias());
        ArrayList<Property> properties = new ArrayList<Property>(apiTable.getAPIFields().size());
        for (APIField APIField2 : apiTable.getAPIFields()) {
            Property property = new Property();
            property.setName(APIField2.getName());
            property.setAlias(APIField2.getAlias());
            property.setCommentInfo(APIField2.getName());
            try {
                property.setDataType(DesigningDataType.fromPersistance(APIField2.getDataType().toPersistance()));
            }
            catch (ModelParseException e) {
                throw new OpenAPIException(2062200, StackTraceUtil.getStackTrace((Throwable)e.fillInStackTrace()));
            }
            property.setAssociateName(APIField2.getName());
            properties.add(property);
        }
        entity.setProperties(properties);
        entities.add(entity);
        DesigntimeDataObject designtimeDataObject = new DesigntimeDataObject();
        designtimeDataObject.setName(associateName);
        designtimeDataObject.setEntities(entities);
        return designtimeDataObject;
    }
}

