/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.data.domain.source.file.excel07.cell;

import com.kingdee.bos.qing.data.domain.source.file.excel07.cell.CellInfo;
import com.kingdee.bos.qing.data.util.DataTypeUtils;
import com.kingdee.bos.qing.data.util.DateUtils;
import com.kingdee.bos.qing.data.util.formate.DateFormateHelper;
import com.kingdee.bos.qing.data.util.formate.DateFormateMatchResult;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;

public abstract class AbstractStringCellInfo
extends CellInfo {
    protected String rawValue;

    @Override
    public String getDataTypeClassName() {
        if (null == this.rawValue || this.rawValue.isEmpty()) {
            return null;
        }
        return DataTypeUtils.getDataTypeClassName(this.rawValue);
    }

    @Override
    protected String getFormateString() {
        return this.rawValue;
    }

    @Override
    public Object getRawValue() {
        return this.rawValue;
    }

    @Override
    protected BigDecimal getNumericValue() throws ParseException {
        BigDecimal decimal = new BigDecimal(this.rawValue);
        if (decimal.scale() > 15) {
            decimal = decimal.setScale(15, RoundingMode.HALF_UP);
        }
        return decimal;
    }

    @Override
    protected BigDecimal getBigInt() throws ParseException {
        BigDecimal decimal = new BigDecimal(this.rawValue);
        long bigInt = decimal.longValue();
        return BigDecimal.valueOf(bigInt);
    }

    @Override
    protected Calendar getDateValue() throws ParseException {
        DateFormateMatchResult matchResult = DateFormateHelper.executeMatch(this.rawValue);
        if (matchResult.isSucceed()) {
            Date date = DateUtils.stringToDate(this.rawValue, matchResult.getDateFormate());
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            return calendar;
        }
        throw new ParseException("is not a date formate value:" + this.rawValue, 0);
    }

    @Override
    protected Long getLongValue() throws ParseException {
        return Long.valueOf(this.rawValue);
    }

    @Override
    protected Boolean getBooleanValue() throws ParseException {
        return Boolean.valueOf(this.rawValue);
    }
}

